<?php 
session_start();
require_once("connectioni.php");
date_default_timezone_set('Asia/Colombo');
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Utilization GIN</title>
    <!-- Bootstrap 3.3.7 -->
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/css/bootstrap.min.css">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
    
    <!-- Scripts -->
    <script language="JavaScript" src="js/utilization_gin.js"></script>

    <!-- Popup Window Script -->
    <script language="javascript" type="text/javascript">
    var win=null;
    function NewWindow(mypage,myname,w,h,scroll,pos){
        if(pos=="random"){LeftPosition=(screen.width)?Math.floor(Math.random()*(screen.width-w)):100;TopPosition=(screen.height)?Math.floor(Math.random()*((screen.height-h)-75)):100;}
        if(pos=="center"){LeftPosition=(screen.width)?(screen.width-w)/2:100;TopPosition=(screen.height)?(screen.height-h)/2:100;}
        else if((pos!="center" && pos!="random") || pos==null){LeftPosition=0;TopPosition=20}
        settings='width='+w+',height='+h+',top='+TopPosition+',left='+LeftPosition+',scrollbars='+scroll+',location=no,directories=no,status=no,menubar=no,toolbar=no,resizable=no';
        win=window.open(mypage,myname,settings);
    }
    
    function close_form() {
        close();
    }
    </script>
    
    <!-- Initial Load Script -->
    <script type="text/javascript">
     window.onload = function(){
        new_inv(); // Initialize
     };
     
     // JS Date Pickle Loader (Legacy Shim if needed, though replaced with type="date")
     function load_calader(tar){
        // No-op or replaced by native date picker
     }
    </script>

    <style>
        body {
            background-color: #ecf0f5;
            font-family: 'Source Sans Pro', 'Helvetica Neue', Helvetica, Arial, sans-serif;
            font-size: 14px;
        }
        
        /* Navbar Styles */
        .navbar-custom {
            background-color: #2c3e50;
            color: white;
            padding: 10px 20px;
            display: flex;
            justify-content: space-between;
            align-items: center;
            box-shadow: 0 2px 5px rgba(0,0,0,0.1);
            margin-bottom: 20px;
        }
        .navbar-brand {
            font-size: 24px;
            font-weight: bold;
            color: white !important;
            text-decoration: none;
            padding: 0;
            height: auto;
            line-height: normal;
        }
        .page-title-box {
            background: rgba(255, 255, 255, 0.1);
            border: 1px solid rgba(255, 255, 255, 0.2);
            padding: 8px 30px;
            border-radius: 5px;
            font-size: 18px;
            font-weight: 600;
            letter-spacing: 1px;
            text-transform: uppercase;
        }
        .user-info {
            display: flex;
            align-items: center;
            gap: 15px;
        }
        .logout-btn {
            background-color: #e74c3c;
            color: white;
            border: none;
            padding: 6px 15px;
            border-radius: 4px;
            font-weight: 600;
            transition: background 0.3s;
            text-decoration: none !important;
        }
        .logout-btn:hover {
            background-color: #c0392b;
            color: white;
        }
        .user-name {
            font-weight: bold;
        }

        /* Content Wrapper */
        .content-wrapper {
            padding: 20px;
        }
        
        /* Box/Card Styling */
        .box {
            background: #fff;
            border-top: 3px solid #d2d6de;
            margin-bottom: 20px;
            width: 100%;
            box-shadow: 0 1px 1px rgba(0,0,0,0.1);
            border-radius: 3px;
        }
        .box.box-primary {
            border-top-color: #3c8dbc;
        }
        .box-header {
            color: #444;
            display: block;
            padding: 10px;
            position: relative;
            border-bottom: 1px solid #f4f4f4;
        }
        .box-header .box-title {
            display: inline-block;
            font-size: 18px;
            margin: 0;
            line-height: 1;
        }
        .box-body {
            border-top-left-radius: 0;
            border-top-right-radius: 0;
            border-bottom-right-radius: 3px;
            border-bottom-left-radius: 3px;
            padding: 20px;
        }

        /* Form Controls */
        .form-control {
            border-radius: 0;
            box-shadow: none;
            border-color: #d2d6de;
        }
        .form-control:focus {
            border-color: #3c8dbc;
            box-shadow: none;
        }
        .control-label {
            font-weight: 600;
            text-align: left !important;
            padding-top: 7px;
        }
        
        /* Buttons */
        .btn {
            border-radius: 3px;
            box-shadow: none;
            border: 1px solid transparent;
        }

        /* Table Styling Overrides */
        .table-custom th {
            background-color: #3c8dbc;
            color: white;
        }
        
        /* Legacy overrides */
        input[disabled], select[disabled], textarea[disabled] {
            cursor: not-allowed;
            background-color: #eee;
            opacity: 1;
        }
        
        /* CSSTableGenerator override */
        .CSSTableGenerator table {
            width: 100%;
            border-collapse: collapse;
        }
        .CSSTableGenerator th, .CSSTableGenerator td {
            padding: 8px;
            line-height: 1.42857143;
            vertical-align: top;
            border-top: 1px solid #ddd;
        }
        
        /* Visibility helper classes */
        .vis-hidden { visibility: hidden; }
    </style>
</head>
<body class="hold-transition skin-blue layout-top-nav">

    <!-- Custom Navbar -->
    <div class="navbar-custom">
        <div class="navbar-brand">ERP SYSTEM MENU</div>
        
        <div class="page-title-box">
            Utilization GIN
        </div>
        
        <div class="user-info">
             <span>Welcome, <span class="user-name"><?php echo $_SESSION['user_name']; ?></span> [<?php echo $_SESSION['company']; ?>]</span>
            <a href="logout.php" class="logout-btn">Logout (Ctrl+Q)</a>
        </div>
    </div>

<div class="content-wrapper">
    <section class="content">

        <!-- Action Toolbar -->
        <div class="box box-solid">
            <div class="box-body">
                <a onclick="new_inv();" class="btn btn-app">
                    <i class="fa fa-plus"></i> New
                </a>
                <?php 
                // Permissions Logic preserved from original
                $sql_per="select * from view_userpermission where username='".$_SESSION["UserName"]."' and docname='Utilization Gin' and grp='Data Capture' ";
                $result_per =mysqli_query($GLOBALS['dbinv'],$sql_per);
                if ($row_per = mysqli_fetch_array($result_per)) {
                    if($row_per['doc_feed']==1){
                        echo '<a onclick="save_crec();" class="btn btn-app"><i class="fa fa-save"></i> Save</a>';
                    }
                    if($row_per['doc_cancel']==1){
                        echo '<a onclick="delete_rec();" class="btn btn-app"><i class="fa fa-times"></i> Cancel</a>';
                    }
                    if($row_per['doc_print']==1){
                        echo '<a onclick="print_inv();" class="btn btn-app"><i class="fa fa-print"></i> Print</a>';
                    }
                    if($row_per['doc_feed']==1){
                        echo '<a onclick="utilization();" class="btn btn-app"><i class="fa fa-check-square-o"></i> Utilization</a>';
                    }
                }
                ?>
                <a onclick="close_form();" class="btn btn-app">
                    <i class="fa fa-close"></i> Close
                </a>
            </div>
        </div>

        <div class="row">
            <!-- Details -->
            <div class="col-md-12">
                <div class="box box-primary">
                    <div class="box-header with-border">
                        <h3 class="box-title">Utilization GIN Details</h3>
                    </div>
                    <div class="box-body">
                        <form role="form" name="form1" id="form1" class="form-horizontal">
                            
                             <!-- Hidden Fields -->
                            <input type="hidden" name="txt_stat" id="txt_stats" />
                            <input type="hidden" name="mcount" id="mcount" />
                            <input type="hidden" name="mcount_chq" id="mcount_chq" />
                            <input type="hidden" name="cmdsave" id="cmdsave" value="1" />
                            <input type="hidden" name="cmdcancel" id="cmdcancel" value="1" />
                            
                            <!-- Row 1: Ref No, Date -->
                            <div class="form-group bg-info" style="padding: 10px 0; margin-bottom: 15px;">
                                <label class="col-sm-1 control-label">Ref No</label>
                                <div class="col-sm-3">
                                    <div class="input-group">
                                        <input type="text" class="form-control input-sm" name="txtrefno" id="txtrefno" disabled onkeypress="keyset('searchcust',event);" onfocus="got_focus('invno');"  onblur="lost_focus('invno');">
                                        <span class="input-group-btn">
                                            <a class="btn btn-default btn-sm" href="serach_uti.php?stname=uti" onClick="NewWindow(this.href,'mywin','800','700','yes','center');return false"><i class="fa fa-search"></i></a>
                                        </span>
                                    </div>
                                </div>
                                <label class="col-sm-1 control-label">Date</label>
                                <div class="col-sm-2">
                                     <input type="date" class="form-control input-sm" name="dtdate" id="dtdate" value="<?php echo date("Y-m-d"); ?>">
                                </div>
                            </div>

                            <!-- Row 2: Customer, Settlements -->
                            <div class="form-group">
                                <label class="col-sm-1 control-label">Customer</label>
                                <div class="col-sm-2">
                                     <input type="text" class="form-control input-sm" name="Txtcusco" id="Txtcusco" disabled>
                                </div>
                                <div class="col-sm-4">
                                    <div class="input-group">
                                        <input type="text" class="form-control input-sm" id="txt_cusname" name="txt_cusname" disabled>
                                        <span class="input-group-btn">
                                            <a class="btn btn-default btn-sm" href="" onclick="NewWindow('utilization_gin_cus_search.php?stname=utilization','mywin','800','700','yes','center');return false"><i class="fa fa-search"></i></a>
                                        </span>
                                    </div>
                                </div>
                                <div class="col-sm-5">
                                    <label class="checkbox-inline">
                                        <input type="checkbox" name="chkinv" id="chkinv" onclick="settle_inv();"> Settle Invoice
                                    </label>
                                    <label class="checkbox-inline" style="visibility:hidden">
                                        <input type="checkbox" name="chkcash" id="chkcash" onclick="settle_cash();"> Cash Pay
                                    </label>
                                    <label class="checkbox-inline" style="visibility:hidden">
                                         <input type="checkbox" name="chkret" id="chkret" onclick="ret_chq_settle();"> Return Cheque
                                    </label>
                                </div>
                            </div>
                            
                            <!-- Row 3: Address -->
                            <div class="form-group">
                                <label class="col-sm-1 control-label">Address</label>
                                <div class="col-sm-6">
                                    <input type="text" class="form-control input-sm" id="TXTADD" name="TXTADD" disabled>
                                </div>
                            </div>
                            
                            <!-- Row 4: ARN/GRN/CRN, Pending Balance, Links -->
                             <div class="form-group">
                                <label class="col-sm-2 control-label">ARN/GRN/CRN/PAY</label>
                                <div class="col-sm-3">
                                    <input type="text" class="form-control input-sm" name="txtcrnno" id="txtcrnno" disabled>
                                </div>
                                <div class="col-sm-1">
                                     <a onclick="NewWindow('serach_rec.php?stname=cash_rec','mywin','800','700','yes','center');return false" class="btn btn-default btn-sm">Search</a>
                                </div>
                                <div class="col-sm-1">
                                     <a onclick="NewWindow('utilization_gin_arn_grn_crn_search.php','mywin','800','700','yes','center');return false" class="btn btn-warning btn-sm">Search All</a>
                                </div>

                                <label class="col-sm-2 control-label">Pending Balance</label>
                                <div class="col-sm-3">
                                    <input type="text" name="txtcrnamount" id="txtcrnamount" class="form-control input-sm text-right" disabled>
                                </div>
                            </div>
                            
                             <!-- Row 5: Remaining Balance -->
                            <div class="form-group">
                                <label class="col-sm-9 control-label">Remaining Balance</label>
                                <div class="col-sm-3">
                                    <input type="text" name="txtrem_bal" id="txtrem_bal" class="form-control input-sm text-right">
                                </div>
                            </div>
                            
                            <!-- Dynamic Content Areas -->
                            <div id="cashcre"></div>
                            
                            <hr>
                            
                            <!-- Tables -->
                            <div class="row">
                                <div class="col-md-12">
                                    <fieldset>
                                        <legend>Utilization Details</legend>
                                        <div id="invdetails" class="CSSTableGenerator">
                                            <!-- Default Header to match legacy HTML -->
                                            <table class="table table-bordered table-striped">
                                                <tr>
                                                    <th width="10%">Code</th>
                                                    <th width="20%">Description</th>
                                                    <th width="10%">Rate</th>
                                                    <th width="10%">Qty</th>
                                                    <th width="10%">Discount</th>
                                                    <th width="10%">Sub Total</th>
                                                </tr>
                                            </table>
                                        </div>
                                    </fieldset>
                                </div>
                            </div>
                            
                            <br>
                            
                             <div class="row">
                                <div class="col-md-12">
                                     <fieldset>
                                        <legend>Cheque Details</legend>
                                        <div id="chkdetails" class="CSSTableGenerator">
                                            <table class="table table-bordered table-striped">
                                                  <tr>
                                                    <th width="10%">Code</th>
                                                    <th width="20%">Description</th>
                                                    <th width="10%">Rate</th>
                                                    <th width="10%">Qty</th>
                                                    <th width="10%">Discount</th>
                                                    <th width="10%">Sub Total</th>
                                                  </tr>
                                            </table>
                                        </div>
                                     </fieldset>
                                </div>
                             </div>
                             
                             <hr>
                             
                             <!-- Payment Section (Hidden by Default per JS) -->
                             <div class="row">
                                 <!-- Cash -->
                                 <div class="col-sm-4">
                                     <div class="form-group">
                                         <label class="col-sm-4 control-label" id="lblcah" style="visibility:hidden">Cash</label>
                                         <div class="col-sm-8">
                                             <input type="text" name="txtcash" id="txtcash" class="form-control input-sm text-right" style="visibility:hidden" onblur="settot();">
                                         </div>
                                     </div>
                                 </div>
                                 
                                 <!-- Buttons -->
                                 <div class="col-sm-4 text-center">
                                     <button type="button" name="searchcust4" id="searchcust4" class="btn btn-default" onclick="inv_btn();">Invoice</button>
                                     <button type="button" name="searchcust5" id="searchcust5" class="btn btn-default" onclick="settlement();">Settlement</button>
                                 </div>
                                 
                                  <!-- Total -->
                                 <div class="col-sm-4">
                                      <div class="form-group">
                                         <label class="col-sm-4 control-label">Total</label>
                                         <div class="col-sm-8">
                                             <input type="text" name="lblPaid" id="lblPaid" class="form-control input-sm text-right" disabled>
                                         </div>
                                     </div>
                                 </div>
                             </div>
                             
                             <!-- Cheque Payment Section -->
                             <fieldset>
                                 <legend>Cheque Pay</legend>
                                 <div class="row">
                                     <div class="col-sm-6">
                                          <div class="form-group">
                                             <label class="col-sm-4 control-label" id="lblchqno" style="visibility:hidden">Cheque No</label>
                                             <div class="col-sm-8">
                                                 <input type="text" name="txtchno" id="txtchno" class="form-control input-sm" style="visibility:hidden">
                                             </div>
                                         </div>
                                         <div class="form-group">
                                             <label class="col-sm-4 control-label" id="lblchbank" style="visibility:hidden">Bank</label>
                                             <div class="col-sm-8">
                                                 <input type="text" name="txtchbank" id="txtchbank" class="form-control input-sm" style="visibility:hidden">
                                             </div>
                                         </div>
                                     </div>
                                     <div class="col-sm-6">
                                         <div class="form-group">
                                             <label class="col-sm-4 control-label" id="lblchqdate" style="visibility:hidden">Cheque Date</label>
                                             <div class="col-sm-8">
                                                 <!-- Note: ID kept as DTPicker1 for JS compatibility, but type updated to Date -->
                                                 <input type="date" name="DTPicker1" id="DTPicker1" class="form-control input-sm" style="visibility:hidden">
                                             </div>
                                         </div>
                                          <div class="form-group">
                                             <label class="col-sm-4 control-label" id="lblamt" style="visibility:hidden">Amount</label>
                                             <div class="col-sm-8">
                                                 <input type="text" name="txtamount" id="txtamount" class="form-control input-sm text-right" style="visibility:hidden" onblur="set_cash_pay();">
                                             </div>
                                         </div>
                                     </div>
                                 </div>
                             </fieldset>
                             
                             <br><br>
                             
                             <!-- Reporting Sections -->
                             <div class="row">
                                 <!-- As at Credit Note Balance -->
                                 <div class="col-md-4">
                                     <div class="box box-warning">
                                         <div class="box-header with-border">
                                             <h3 class="box-title">As at Credit Note Balance</h3>
                                         </div>
                                         <div class="box-body">
                                             <div class="form-group">
                                                 <label class="col-sm-4 control-label">As at Date</label>
                                                 <div class="col-sm-8">
                                                     <input type="date" name="DTasat" id="DTasat" class="form-control input-sm">
                                                 </div>
                                             </div>
                                             <div class="form-group">
                                                 <div class="col-sm-12">
                                                     <select name="com_type" id="com_type" class="form-control input-sm">
                                                      <?php
                                                        $sql="select * from s_stomas  order by CODE";
                                                        $result =mysqli_query($GLOBALS['dbinv'],$sql) ; 
                                                        while($row = mysqli_fetch_array($result)){
                                                            echo "<option value='".$row["CODE"]."'>".$row["CODE"]." ".$row["DESCRIPTION"]."</option>";
                                                        }
                                                        ?>
                                                    </select>
                                                 </div>
                                             </div>
                                              <div class="form-group">
                                                 <label class="col-sm-4 control-label">Process</label>
                                                 <div class="col-sm-8">
                                                     <input type="checkbox" name="Check1" id="Check1">
                                                 </div>
                                             </div>
                                             <div class="form-group">
                                                 <div class="col-sm-12 text-center">
                                                     <a onclick="NewWindow('serach_customer.php?stname=ret_chq_settle','mywin','800','700','yes','center');return false" class="btn btn-warning btn-sm btn-block">View</a>
                                                 </div>
                                             </div>
                                         </div>
                                     </div>
                                 </div>
                                 
                                 <!-- Periodic Report -->
                                 <div class="col-md-8">
                                     <div class="box box-info">
                                         <div class="box-header with-border">
                                             <h3 class="box-title">Periodic Report</h3>
                                         </div>
                                         <div class="box-body">
                                             <div class="form-group">
                                                 <label class="col-sm-2 control-label">From</label>
                                                 <div class="col-sm-4">
                                                     <input type="date" name="dtfrom" id="dtfrom" class="form-control input-sm">
                                                 </div>
                                                 <label class="col-sm-2 control-label">To</label>
                                                 <div class="col-sm-4">
                                                     <input type="date" name="dtto" id="dtto" class="form-control input-sm">
                                                 </div>
                                             </div>
                                             
                                             <div class="form-group">
                                                 <div class="col-sm-4">
                                                     <select name="Combo1" id="Combo1" class="form-control input-sm">
                                                      <?php
                                                        $sql="select * from s_stomas    order by CODE";
                                                        $result =mysqli_query($GLOBALS['dbinv'],$sql) ; 
                                                        while($row = mysqli_fetch_array($result)){
                                                            echo "<option value='".$row["CODE"]."'>".$row["CODE"]." ".$row["DESCRIPTION"]."</option>";
                                                        }
                                                        ?>
                                                    </select>
                                                 </div>
                                                 <div class="col-sm-4">
                                                     <label class="radio-inline">
                                                         <input type="radio" name="op_crenote" id="op_crenote" value="radio"> Credit Note
                                                     </label>
                                                 </div>
                                                  <div class="col-sm-4">
                                                     <label class="radio-inline">
                                                         <input type="radio" name="op_Settlement" id="op_Settlement" value="radio"> Settlement
                                                     </label>
                                                 </div>
                                             </div>
                                             
                                             <div class="form-group">
                                                 <div class="col-sm-12 text-center">
                                                      <a onclick="NewWindow('serach_customer.php?stname=ret_chq_settle','mywin','800','700','yes','center');return false" class="btn btn-info btn-sm">View Report</a>
                                                 </div>
                                             </div>
                                         </div>
                                     </div>
                                 </div>
                             </div>

                        </form>
                    </div><!-- /.box-body -->
                </div><!-- /.box -->
            </div><!-- /.col -->
        </div><!-- /.row -->

    </section>
</div>

<script>
    // Keyboard Shortcut for Logout (Ctrl+Q)
    document.addEventListener('keydown', function(event) {
        if (event.ctrlKey && (event.key === 'q' || event.key === 'Q')) {
            event.preventDefault();
            window.location.href = 'logout.php';
        }
    });
</script>
</body>
</html>
