<?php 
session_start();
require_once("connectioni.php");
$_SESSION["save_sales_ord"]=0;
$_SESSION["brand"]="";
date_default_timezone_set('Asia/Colombo');
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Proforma Invoice</title>
    <!-- Bootstrap 3.3.7 -->
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/css/bootstrap.min.css">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
    
    <!-- Scripts -->
    <script language="JavaScript" src="js/ord_new.js"></script>

    <!-- Popup Window Script -->
    <script language="javascript" type="text/javascript">
    var win=null;
    function NewWindow(mypage,myname,w,h,scroll,pos){
        if(pos=="random"){LeftPosition=(screen.width)?Math.floor(Math.random()*(screen.width-w)):100;TopPosition=(screen.height)?Math.floor(Math.random()*((screen.height-h)-75)):100;}
        if(pos=="center"){LeftPosition=(screen.width)?(screen.width-w)/2:100;TopPosition=(screen.height)?(screen.height-h)/2:100;}
        else if((pos!="center" && pos!="random") || pos==null){LeftPosition=0;TopPosition=20}
        settings='width='+w+',height='+h+',top='+TopPosition+',left='+LeftPosition+',scrollbars='+scroll+',location=no,directories=no,status=no,menubar=no,toolbar=no,resizable=no';
        win=window.open(mypage,myname,settings);
    }
    function mm() {
        close();
    }
    </script>
    
    <!-- Initial Load Script -->
    <script type="text/javascript">
     window.onload = function(){
        new_inv(); // Initialize
     };
    </script>

    <style>
        body {
            background-color: #ecf0f5; /* Light grey background for ERP feel */
            font-family: 'Source Sans Pro', 'Helvetica Neue', Helvetica, Arial, sans-serif;
            font-size: 14px;
        }
        
        /* Navbar Styles */
        .navbar-custom {
            background-color: #2c3e50; /* Primary Color */
            color: white;
            padding: 10px 20px;
            display: flex;
            justify-content: space-between;
            align-items: center;
            box-shadow: 0 2px 5px rgba(0,0,0,0.1);
            margin-bottom: 20px;
        }
        .navbar-brand {
            font-size: 24px;
            font-weight: bold;
            color: white !important;
            text-decoration: none;
            padding: 0;
            height: auto;
            line-height: normal;
        }
        .page-title-box {
            background: rgba(255, 255, 255, 0.1);
            border: 1px solid rgba(255, 255, 255, 0.2);
            padding: 8px 30px;
            border-radius: 5px;
            font-size: 18px;
            font-weight: 600;
            letter-spacing: 1px;
            text-transform: uppercase;
        }
        .user-info {
            display: flex;
            align-items: center;
            gap: 15px;
        }
        .logout-btn {
            background-color: #e74c3c; /* Danger Color */
            color: white;
            border: none;
            padding: 6px 15px;
            border-radius: 4px;
            font-weight: 600;
            transition: background 0.3s;
            text-decoration: none !important;
        }
        .logout-btn:hover {
            background-color: #c0392b;
            color: white;
        }
        .user-name {
            font-weight: bold;
        }

        /* Content Wrapper */
        .content-wrapper {
            padding: 20px;
        }
        
        /* Box/Card Styling */
        .box {
            background: #fff;
            border-top: 3px solid #d2d6de;
            margin-bottom: 20px;
            width: 100%;
            box-shadow: 0 1px 1px rgba(0,0,0,0.1);
            border-radius: 3px;
        }
        .box.box-primary {
            border-top-color: #3c8dbc;
        }
        .box-header {
            color: #444;
            display: block;
            padding: 10px;
            position: relative;
            border-bottom: 1px solid #f4f4f4;
        }
        .box-header .box-title {
            display: inline-block;
            font-size: 18px;
            margin: 0;
            line-height: 1;
        }
        .box-body {
            border-top-left-radius: 0;
            border-top-right-radius: 0;
            border-bottom-right-radius: 3px;
            border-bottom-left-radius: 3px;
            padding: 20px;
        }

        /* Form Controls */
        .form-control {
            border-radius: 0;
            box-shadow: none;
            border-color: #d2d6de;
        }
        .form-control:focus {
            border-color: #3c8dbc;
            box-shadow: none;
        }
        .control-label {
            font-weight: 600;
            text-align: left !important;
            padding-top: 7px;
        }
        
        /* Buttons */
        .btn {
            border-radius: 3px;
            box-shadow: none;
            border: 1px solid transparent;
        }

        /* Radio Buttons */
        .radio-inline {
            font-weight: bold;
            font-size: 14px;
            padding-left: 25px;
        }

        /* Table Styling Overrides (for AJAX Content) */
        #itemdetails table, #storgrid table {
            width: 100%;
            margin-bottom: 20px;
            border: 1px solid #f4f4f4;
            border-collapse: collapse;
            font-size: 13px;
        }
        #itemdetails table th, #itemdetails table td,
        #storgrid table th, #storgrid table td {
            padding: 8px;
            line-height: 1.42857143;
            vertical-align: top;
            border: 1px solid #ddd;
        }
        #itemdetails table tr:first-child td,
        #storgrid table tr:first-child td {
            background-color: #3c8dbc !important;
            color: white !important;
            font-weight: bold;
            border-bottom: 2px solid #3c8dbc;
        }
        
        /* Utility */
        .mt-10 { margin-top: 10px; }
        .mb-10 { margin-bottom: 10px; }
        
        /* Legacy overrides */
        .hidden { display: none; }
        input[disabled], select[disabled], textarea[disabled] {
            cursor: not-allowed;
            background-color: #eee;
            opacity: 1;
        }
    </style>
</head>
<body class="hold-transition skin-blue layout-top-nav">

    <!-- Custom Navbar -->
    <div class="navbar-custom">
        <div class="navbar-brand">ERP SYSTEM MENU</div>
        
        <div class="page-title-box">
            Proforma Invoice
        </div>
        
        <div class="user-info">
             <span>Welcome, <span class="user-name"><?php echo $_SESSION['user_name']; ?></span> [<?php echo $_SESSION['company']; ?>]</span>
            <a href="logout.php" class="logout-btn">Logout (Ctrl+Q)</a>
        </div>
    </div>

<div class="content-wrapper">
    <section class="content">

        <!-- Action Toolbar -->
        <div class="box box-solid">
            <div class="box-body">
                <a onclick="new_inv();" class="btn btn-app">
                    <i class="fa fa-plus"></i> New
                </a>
                <a onclick="save_inv();" class="btn btn-app">
                    <i class="fa fa-save"></i> Save
                </a>
                <a onclick="cancel_inv();" class="btn btn-app">
                    <i class="fa fa-trash"></i> Delete
                </a>
                <a onclick="print_inv();" class="btn btn-app">
                    <i class="fa fa-print"></i> Print
                </a>
                 <a onclick="to_wd();" class="btn btn-app">
                    <i class="fa fa-arrow-right"></i> To MD
                </a>
                <a onclick="mm();" class="btn btn-app">
                    <i class="fa fa-close"></i> Close
                </a>
            </div>
        </div>

        <div class="row">
            <!-- Details -->
            <div class="col-md-12">
                <div class="box box-primary">
                    <div class="box-header with-border">
                        <h3 class="box-title">Proforma Invoice Details</h3>
                    </div>
                    <div class="box-body">
                        <form role="form" name="form1" id="form1" class="form-horizontal">
                            <input type="hidden" name="cmd_new" id="cmd_new" value="1" />
                            <input type="hidden" name="cmd_save" id="cmd_save" value="0"/>
                            <input type="hidden" name="cmd_cancel" id="cmd_cancel" value="0"/>
                            <input type="hidden" name="cmd_print" id="cmd_print" value="0"/>
                            <input type="hidden" name="hiddencount" id="hiddencount" />
                            <input type="hidden" name="c_subcode" id="c_subcode" />
                            <input type="hidden" name="over60" id="over60" />
                            <input type="hidden" name="crebal" id="crebal" />
                            
                            <!-- Row 1: Payment Method, SO No, Search, Entry Date -->
                            <div class="form-group bg-info" style="padding: 10px 0; margin-bottom: 15px;">
                                <div class="col-sm-3">
                                    <label class="radio-inline">
                                        <input type="radio" name="paymethod" value="credit" id="paymethod_0"> Credit
                                    </label>
                                    <label class="radio-inline">
                                        <input type="radio" name="paymethod" value="cash" id="paymethod_1"> Cash
                                    </label>
                                </div>
                                <label class="col-sm-1 control-label">SO No</label>
                                <div class="col-sm-3">
                                    <div class="input-group">
                                        <input type="text" class="form-control input-sm" name="salesord1" id="salesord1" disabled onkeypress="keyset('searchcust',event);">
                                        <span class="input-group-btn">
                                            <button type="button" class="btn btn-default btn-sm" onclick="load_ord_lst();"><i class="fa fa-search"></i></button>
                                        </span>
                                    </div>
                                </div>
                                <label class="col-sm-2 control-label">Entry Date</label>
                                <div class="col-sm-3">
                                     <input type="date" class="form-control input-sm" name="invdate" id="invdate" value="<?php echo date("Y-m-d"); ?>">
                                </div>
                            </div>
                            
                            <!-- Row 2: Type, Dup Inv No, Hidden Fields -->
                            <div class="form-group">
                                <label class="col-sm-1 control-label">Type</label>
                                <div class="col-sm-3">
                                    <select name="type" id="type" onkeypress="keyset('brand',event);" class="form-control input-sm">
                                         <option value='Proforma Invoice'>Proforma Invoice</option> 
                                         <option value='Duplicate Invoice'>Duplicate Invoice</option> 
                                    </select>
                                </div>
                                <label class="col-sm-2 control-label">Duplicate Inv.No</label>
                                <div class="col-sm-3">
                                     <input type="text" class="form-control input-sm" name="salesord2" id="salesord2" onkeypress="keyset('searchcust', event);">
                                </div>
                                <input type="hidden" name="ordno" id="ordno" class="form-control">
                                <input type="hidden" name="invno" id="invno" class="form-control">
                                <input type="hidden" name="txtdono" id="txtdono" class="form-control">
                                <input id="dte_dor" name="dte_dor" type="hidden" value="">
                            </div>

                            <!-- Row 3: Customer, Search, Credit Limit, Credit Balance -->
                            <div class="form-group">
                                <label class="col-sm-1 control-label">Customer</label>
                                <div class="col-sm-2">
                                     <div class="input-group">
                                        <input type="text" class="form-control input-sm" name="firstname_hidden" id="firstname_hidden" disabled onblur="custno_ind('');" onkeypress="keyset('department',event);">
                                        <span class="input-group-btn">
                                            <a class="btn btn-default btn-sm" href="" onClick="NewWindow('serach_customer.php?stname=sales_order','mywin','800','700','yes','center');return false"><i class="fa fa-search"></i></a>
                                        </span>
                                    </div>
                                </div>
                                <div class="col-sm-3">
                                    <input type="text" class="form-control input-sm" id="firstname" disabled name="firstname">
                                </div>
                                <label class="col-sm-1 control-label">Cr Limit</label>
                                <div class="col-sm-2">
                                     <input type="text" class="form-control input-sm" name="creditlimit" id="creditlimit" value="0" disabled>
                                </div>
                                <label class="col-sm-1 control-label">Cr Bal</label>
                                <div class="col-sm-2">
                                     <input type="text" class="form-control input-sm" name="balance" id="balance" value="0" disabled>
                                </div>
                            </div>

                             <!-- Row 4: Address, Department, Brand, TBR Check -->
                            <div class="form-group">
                                <label class="col-sm-1 control-label">Address</label>
                                <div class="col-sm-5">
                                    <input type="text" class="form-control input-sm" id="cus_address" name="cus_address">
                                </div>
                                <label class="col-sm-1 control-label">Dept</label>
                                <div class="col-sm-2">
                                    <select name="department" id="department" onkeypress="keyset('brand',event);" class="form-control input-sm" >
                                      <?php
                                         if ($_SESSION["CURRENT_DEP"] != "") {
                                           $sql="select * from s_stomas where  act='1' and CODE='".$_SESSION["CURRENT_DEP"] ."' order by CODE";
                                        }else{
                                          $sql="select * from s_stomas where  act='1'  order by CODE";
                                        } 
                                        $result =mysqli_query($GLOBALS['dbinv'],$sql) ; 
                                        while($row = mysqli_fetch_array($result)){
                                        echo "<option value='".$row["CODE"]."'>".$row["DESCRIPTION"]."</option>";
                                        }                                                                   
                                        ?>
                                    </select>
                                </div>
                                <label class="col-sm-1 control-label">Brand</label>
                                <div class="col-sm-2">
                                    <div class="input-group">
                                        <select name="brand" id="brand" disabled class="form-control input-sm" onkeypress="keyset('salesrep',event);" onblur="setord();">
                                            <option value=''></option>
                                              <?php
                                                if (($_SESSION["CURRENT_DEP"] != "") and (!is_numeric($_SESSION["CURRENT_DEP"]))) {
                                                    $sql="select * from brand_mas where act ='1' and costcenter='".$_SESSION["CURRENT_DEP"]."' order by barnd_name"; 
                                                }else{
                                                    $sql="select * from brand_mas where act ='1' order by barnd_name";
                                                } 
                                                $result =mysqli_query($GLOBALS['dbinv'],$sql) ; 
                                                while($row = mysqli_fetch_array($result)){
                                                     echo "<option value='".$row["barnd_name"]."'>".$row["barnd_name"]."</option>";
                                                }
                                                ?>
                                        </select>
                                        <span class="input-group-addon" style="padding:0 5px; font-size:10px;">
                                            <input type="checkbox" name="tbrcheck" onClick="tbrsession();" id="tbrcheck"> TBR
                                        </span>
                                    </div>
                                </div>
                            </div>

                             <!-- Row 5: VAT No, VAT Group -->
                            <div class="form-group">
                                <label class="col-sm-1 control-label">VAT No</label>
                                <div class="col-sm-2">
                                     <input type="text" class="form-control input-sm" name="vat1" id="vat1" disabled onkeypress="keyset('vat2',event);">
                                </div>
                                <div class="col-sm-2">
                                     <input type="text" class="form-control input-sm" name="vat2" id="vat2" disabled onkeypress="keyset('salesrep',event);">
                                </div>
                                <div class="col-sm-7 bg-info" style="padding-top:5px; padding-bottom:5px;">
                                    <label class="radio-inline"><input type="radio" name="vatgroup" value="vat" id="vatgroup_0" onclick="calc1_table_discount1();"> VAT Inv</label>
                                    <label class="radio-inline"><input type="radio" name="vatgroup" value="non" id="vatgroup_1" onclick="calc1_table_discount1();"> Non VAT</label>
                                    <label class="radio-inline"><input type="radio" name="vatgroup" value="svat" id="vatgroup_2" onclick="calc1_table_discount1();"> SVAT Inv</label>
                                    <label class="radio-inline"><input type="radio" name="vatgroup" value="evat" id="vatgroup_3" onclick="calc1_table_discount1();"> EVAT Inv</label>
                                </div>
                            </div>
                            
                            <!-- Row 6: Sales Exec, Discounts -->
                            <div class="form-group">
                                <label class="col-sm-1 control-label">Sales Exec</label>
                                <div class="col-sm-3">
                                    <select name="salesrep" id="salesrep" onkeypress="keyset('discount_org1',event);" onblur="setord();" class="form-control input-sm">
                                      <?php
                                      require_once("connectioni.php");
                                        if (($_SESSION["MANAGER"] !="") &&  ($_SESSION["CURRENT_REP"] !="")){                                                    
                                            $sql="select * from s_salrep where pactive='1' and repcode = '" . $_SESSION["CURRENT_REP"] ."' order by REPCODE";
                                            $result =mysqli_query($GLOBALS['dbinv'],$sql) ; 
                                            while($row = mysqli_fetch_array($result)){
                                                echo "<option value='".$row["REPCODE"]."'>".$row["REPCODE"]." ".$row["Name"]."</option>";
                                            }
                                         }else if ($_SESSION["MANAGER"]!="") {                  
                                            $sql="select * from s_salrep where pactive='1' and manager='".$_SESSION["MANAGER"]."'order by REPCODE"; 
                                            $result =mysqli_query($GLOBALS['dbinv'],$sql) ; 
                                            while($row = mysqli_fetch_array($result)){
                                                echo "<option value='".$row["REPCODE"]."'>".$row["REPCODE"]." ".$row["Name"]."</option>";
                                            }
                                         }else if ($_SESSION["CURRENT_REP"]=="") {                                                    
                                            $sql="select * from s_salrep where pactive='1' order by REPCODE";
                                            $result =mysqli_query($GLOBALS['dbinv'],$sql) ; 
                                            while($row = mysqli_fetch_array($result)){
                                                echo "<option value='".$row["REPCODE"]."'>".$row["REPCODE"]." ".$row["Name"]."</option>";
                                            }
                                         } else {
                                             $sql="select * from s_salrep where pactive='1' and repcode = '" . $_SESSION["CURRENT_REP"] ."' order by REPCODE";
                                             $result =mysqli_query($GLOBALS['dbinv'],$sql) ; 
                                             while($row = mysqli_fetch_array($result)){
                                             echo "<option value='".$row["REPCODE"]."'>".$row["REPCODE"]." ".$row["Name"]."</option>";
                                             }
                                         }
                                        ?>
                                    </select>
                                </div>
                                <label class="col-sm-1 control-label">Disc 1</label>
                                <div class="col-sm-1">
                                    <input type="text" class="form-control input-sm" name="discount_org1" id="discount_org1" onkeyup="calc1_table_discount1();" onkeydown="calc1_table_discount1();" onkeypress="keyset('discount_org2',event);" onblur="calc1_table_discount1();">
                                </div>
                                <label class="col-sm-1 control-label">Disc 2</label>
                                <div class="col-sm-1">
                                    <input type="text" class="form-control input-sm" name="discount_org2" id="discount_org2" disabled onkeyup="calc1_table_discount1();" onkeydown="calc1_table_discount1();" onkeypress="keyset('itemd_hidden',event);" onblur="calc1_table_discount2();">
                                </div>
                                <input type="hidden" name="discount_org3" id="discount_org3" value="0">
                            </div>

                            <hr>
                            <h4 class="box-title text-primary">Item Details</h4>
                            <input type="hidden" name="item_count" id="item_count" value="0" />
                            
                            <!-- Item Input Row -->
                             <div class="row" style="margin-bottom: 10px;">
                                <div class="col-sm-2">
                                    <label>Item Code</label>
                                    <input type="text" class="form-control input-sm" name="itemd_hidden" id="itemd_hidden" onkeypress="keyset('qty',event);" onblur="itno_ind();">
                                </div>
                                <div class="col-sm-2">
                                     <label>&nbsp;</label>
                                     <button type="button" class="btn btn-default btn-sm btn-block" onclick="NewWindow('serach_item.php?stname=sales_order','mywin','800','700','yes','center');return false"><i class="fa fa-search"></i> Search Item</button>
                                </div>
                                <div class="col-sm-3">
                                    <label>Description</label>
                                    <input type="text" class="form-control input-sm" id="itemd" name="itemd" disabled>
                                </div>
                                <div class="col-sm-1">
                                    <label>Price</label>
                                    <input type="text" class="form-control input-sm" name="rate" id="rate" onkeypress="keyset('qty',event);">
                                    <input type="hidden" name="part_no" id="part_no"> 
                                    <input type="hidden" name="actual_selling" id="actual_selling">
                                </div>
                                <div class="col-sm-1">
                                    <label>Qty</label>
                                    <input type="text" class="form-control input-sm" name="qty" id="qty" onblur="calc1();" onkeypress="keyset('additem_tmp',event);">
                                </div>
                                <div class="col-sm-1">
                                    <label>Disc %</label>
                                    <input type="text" class="form-control input-sm" name="discountper" id="discountper" disabled onkeypress="keyset('subtotal',event);">
                                    <input type="hidden" name="discount" id="discount" class="form-control">
                                </div>
                                <div class="col-sm-1">
                                    <label>Total</label>
                                    <input type="text" class="form-control input-sm" name="subtotal" id="subtotal" disabled onkeypress="keyset('additem_tmp',event);">
                                </div>
                                <div class="col-sm-1">
                                    <label>&nbsp;</label>
                                    <button type="button" class="btn btn-primary btn-sm btn-block" id="additem_tmp" onClick="add_tmp();"><i class="fa fa-plus"></i></button>
                                </div>
                            </div>
                            
                            <div class="row mt-10">
                                <div class="col-md-12">
                                    <div id="itemdetails" style="min-height: 150px; overflow-y: auto;">
                                        <!-- AJAX Grid Content -->
                                    </div>
                                </div>
                            </div>

                             <!-- Inventory & Credit Info -->
                            <div class="row" style="margin-top:15px;">
                                <div class="col-sm-6">
                                     <div class="form-group">
                                        <label class="col-sm-4 control-label">Available Qty</label>
                                        <div class="col-sm-4">
                                            <input type="text" class="form-control input-sm" name="stklevel" id="stklevel" disabled>
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label class="col-sm-4 control-label">Credit Period</label>
                                        <div class="col-sm-4">
                                            <input type="text" class="form-control input-sm" name="credper" id="credper">
                                        </div>
                                    </div>
                                     <div class="form-group">
                                        <label class="col-sm-4 control-label">Month Qty</label>
                                        <div class="col-sm-4">
                                            <input type="text" class="form-control input-sm" name="txtinvt" id="txtinvt">
                                        </div>
                                    </div>
                                    <div class="form-group">
                                         <div class="col-sm-12">
                                            <div id="storgrid"></div>
                                         </div>
                                    </div>
                                </div>
                                
                                <!-- Totals -->
                                <div class="col-sm-6">
                                     <div class="form-group">
                                        <label class="col-sm-8 control-label">Sub Total</label>
                                        <div class="col-sm-4">
                                            <input type="text" class="form-control input-sm text-right" name="subtot" id="subtot" disabled value="0">
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label class="col-sm-8 control-label">Discount</label>
                                        <div class="col-sm-4">
                                            <input type="text" class="form-control input-sm text-right" name="totdiscount" id="totdiscount" disabled value="0">
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label class="col-sm-8 control-label">Tax</label>
                                        <div class="col-sm-4">
                                            <input type="text" class="form-control input-sm text-right" name="tax" id="tax" disabled value="0">
                                            <input type="hidden" name="OutInvAmt" id="OutInvAmt" />
                                            <input type="hidden" name="OutREtAmt" id="OutREtAmt" />
                                            <input type="hidden" name="OutpDAMT" id="OutpDAMT" />
                                        </div>
                                    </div>
                                     <div class="form-group">
                                        <label class="col-sm-8 control-label" style="font-size: 16px;">Grand Total</label>
                                        <div class="col-sm-4">
                                            <input type="text" class="form-control input-sm text-right" name="invtot" id="invtot" disabled value="0" style="font-size: 16px; font-weight:bold;">
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label class="col-sm-2 control-label">Remark</label>
                                        <div class="col-sm-10">
                                            <textarea name="remark" id="remark" class="form-control" rows="3"></textarea>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                            
                        </form>
                    </div><!-- /.box-body -->
                </div><!-- /.box -->
            </div><!-- /.col -->
        </div><!-- /.row -->

    </section>
</div>

<script>
    // Keyboard Shortcut for Logout (Ctrl+Q)
    document.addEventListener('keydown', function(event) {
        if (event.ctrlKey && (event.key === 'q' || event.key === 'Q')) {
            event.preventDefault();
            window.location.href = 'logout.php';
        }
    });
</script>
</body>
</html>
