<?php
session_start();
require_once("connectioni.php");

if (!isset($_SESSION['company']) || $_SESSION['company'] == "") {
	exit("Please Login");
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
	<meta charset="UTF-8">
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	<title>Return Cheque Settlement</title>
	<!-- Bootstrap 3.3.7 -->
	<link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/css/bootstrap.min.css">
	<!-- Font Awesome -->
	<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
	
	<style>
		body { background-color: #ecf0f5; font-family: 'Source Sans Pro', 'Helvetica Neue', Helvetica, Arial, sans-serif; }
		 .navbar-custom { background-color: #2c3e50; color: white; padding: 10px 20px; display: flex; justify-content: space-between; align-items: center; margin-bottom: 20px; }
		.navbar-brand { font-size: 24px; font-weight: bold; color: white !important; padding: 0; }
		.page-title-box { background: rgba(255, 255, 255, 0.1); padding: 8px 30px; border-radius: 5px; font-size: 18px; font-weight: 600; text-transform: uppercase; }
		.box { background: #fff; border-top: 3px solid #d2d6de; box-shadow: 0 1px 1px rgba(0, 0, 0, 0.1); margin-bottom: 20px; border-radius: 3px; }
		.box.box-primary { border-top-color: #3c8dbc; }
		.box-header { color: #444; border-bottom: 1px solid #f4f4f4; padding: 10px; }
		.box-body { padding: 20px; }
		.btn-app { margin-right: 5px; }
	</style>
	 <script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
	<script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/js/bootstrap.min.js"></script>
	<script src="js/ret_chq_settle.js"></script>
</head>

<body class="hold-transition skin-blue layout-top-nav">

	<!-- Navbar -->
	<div class="navbar-custom">
		<div class="navbar-brand">ERP SYSTEM MENU</div>
		<div class="page-title-box">RETURN CHEQUE SETTLEMENT</div>
		<div class="user-info">
			 [<?php echo isset($_SESSION['company']) ? $_SESSION['company'] : ''; ?>]
			<a href="logout.php" class="btn btn-danger btn-xs">Logout</a>
		</div>
	</div>

	<!-- Content -->
	<div class="container-fluid">
		<section class="content">

			<!-- Toolbar -->
			<div class="box box-solid">
				<div class="box-body">
					<button onclick="new_inv()" class="btn btn-default"><i class="fa fa-file"></i> New</button>
					<button onclick="save_crec()" class="btn btn-success"><i class="fa fa-save"></i> Save</button>
					<button onclick="window.close()" class="btn btn-danger"><i class="fa fa-times"></i> Close</button>
					<button onclick="print_inv()" class="btn btn-default"><i class="fa fa-print"></i> Print</button>
					 <a onclick="NewWindow('serach_rec_settle.php?stname=PAY', 'mywin', '800', '700', 'yes');" class="btn btn-info"><i class="fa fa-search"></i> Search Record</a>
				</div>
			</div>

			<div class="row">
				<!-- Header Info -->
				<div class="col-md-12">
					 <div class="box box-primary">
						<div class="box-header with-border"> <h3 class="box-title">Settlement Header</h3> </div>
						<div class="box-body">
							<div class="row">
								<div class="col-md-2">
									<div class="form-group">
										<label>Ref No</label>
										<input type="text" id="invno" class="form-control" disabled>
									</div>
								</div>
								<div class="col-md-2">
									 <div class="form-group">
										<label>Date</label>
										<input type="date" id="invdate" class="form-control" value="<?php echo date('Y-m-d'); ?>">
									</div>
								</div>
								<div class="col-md-2">
									 <div class="form-group">
										<label>Cost Center</label>
										<select id="costcenter" class="form-control"></select>
									</div>
								</div>
								<div class="col-md-2">
									 <div class="form-group">
										<label>Sales Rep</label>
										<select id="salesrep" class="form-control"></select>
									</div>
								</div>
								 <div class="col-md-2">
									 <div class="form-group">
										<label>Pay Type</label>
										<select id="paytype" class="form-control">
											<option value="Cash">Cash</option>
											<option value="Cheque" selected>Cheque</option>
											<option value="J/Entry">J/Entry</option>
										</select>
									</div>
								</div>
							</div>
							
							<div class="row">
								<div class="col-md-2">
									 <div class="form-group">
										<label>Customer</label> 
										<input type="text" id="cuscode" class="form-control" disabled>
									</div>
								</div>
								<div class="col-md-4">
									 <div class="form-group">
										<label>Name</label>
										<div class="input-group">
											<input type="text" id="cusname" class="form-control" disabled>
											<span class="input-group-btn">
												 <button class="btn btn-default" onclick="NewWindow('serach_customer.php?stname=ret_chq_settle', 'mywin', '800', '700', 'yes')"><i class="fa fa-search"></i></button>
											</span>
										</div>
									</div>
								</div>
								 <div class="col-md-4">
									 <div class="form-group">
										<label>Debit Account</label>
										 <select id="account" class="form-control"></select>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>

			<!-- Content Split: Returned Cheques vs New Payments -->
			<div class="row">
				
				<!-- Returned Cheques (To be settled) -->
				<div class="col-md-7">
					<div class="box box-warning">
						<div class="box-header with-border"> <h3 class="box-title">Unsettled Returned Cheques</h3> </div>
						<div class="box-body table-responsive" style="height: 300px; overflow-y: auto;">
							<table class="table table-bordered table-condensed table-hover">
								<thead>
									<tr>
										<th>Ref No</th>
										<th>Chq No</th>
										<th>Date</th>
										<th class="text-right">Amount</th>
										<th class="text-right">Balance</th>
										<th class="text-right" width="120">Settle</th>
									</tr>
								</thead>
								<tbody id="chq_table_body"></tbody>
							</table>
						</div>
						<div class="box-footer">
							 <div class="form-horizontal">
								<div class="form-group">
									<label class="col-sm-8 control-label">Total to Settle</label>
									<div class="col-sm-4">
										<input type="text" id="txttotalsettle" class="form-control text-right" disabled value="0.00">
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
				
				<!-- New Payment Entry -->
				<div class="col-md-5">
					 <div class="box box-success">
						<div class="box-header with-border"> <h3 class="box-title">New Payment Details</h3> </div>
						<div class="box-body">
							 <!-- Cash Entry -->
							 <div class="form-group">
								<label>Cash Payment</label>
								<input type="number" id="cashamt" class="form-control text-right" placeholder="0.00" onkeyup="updateTotals()">
							</div>
							<hr>
							<!-- Cheque Entry -->
							<div class="well well-sm">
								<div class="row">
									<div class="col-md-6"><input type="text" id="chqno" class="form-control input-sm" placeholder="Cheque No"></div>
									<div class="col-md-6"><input type="date" id="chqdate" class="form-control input-sm"></div>
								</div>
								<div class="row" style="margin-top:5px;">
									<div class="col-md-6"><input type="text" id="bank" class="form-control input-sm" placeholder="Bank"></div>
									<div class="col-md-6">
										<div class="input-group input-group-sm">
											<input type="number" id="chqamt" class="form-control" placeholder="Amount">
											<span class="input-group-btn">
												<button class="btn btn-success" onclick="add_payment_cheque()"> Add</button>
											</span>
										</div>
									</div>
								</div>
							</div>
							
							<!-- Payment List -->
							 <table class="table table-striped table-condensed">
								<thead>
									<tr>
										<th>Type</th>
										<th>Ref/Chq</th>
										<th>Date</th>
										<th class="text-right">Amount</th>
										<th></th>
									</tr>
								</thead>
								<tbody id="payment_list_body"></tbody>
							</table>
						</div>
						 <div class="box-footer">
							 <div class="form-horizontal">
								<div class="form-group">
									<label class="col-sm-7 control-label">Total Payment</label>
									<div class="col-sm-5">
										<input type="text" id="txttotalpay" class="form-control text-right" disabled value="0.00">
									</div>
								</div>
								<div class="form-group">
									<label class="col-sm-7 control-label">Over/Under</label>
									<div class="col-sm-5">
										<input type="text" id="txtoverunder" class="form-control text-right" disabled value="0.00" style="font-weight:bold;">
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>

			</div>

		</section>
	</div>
</body>
</html>