<?php
session_start();

// Security checks
if (empty($_SESSION['company']) || empty($_SESSION['CURRENT_USER'])) {
    header('Content-Type: application/json');
    echo json_encode(['status' => 'error', 'message' => 'Please Login']);
    exit;
}

require_once("connectioni.php");

header('Content-Type: application/json');
date_default_timezone_set('Asia/Colombo');

$command = isset($_GET['Command']) ? $_GET['Command'] : '';

// Helper to handle MySQL errors
function handleDBError($conn)
{
    return json_encode(['status' => 'error', 'message' => mysqli_error($conn)]);
}

// 1. ADD ADDRESS (Legacy)
if ($command == "add_address") {
    $sqlt = "Select * from customer_mast where id ='" . $_GET['customerid'] . "'";
    $resultt = mysqli_query($GLOBALS['dbinv'], $sqlt);
    if ($rowt = mysqli_fetch_array($resultt)) {
        echo json_encode(['status' => 'success', 'address' => $rowt["str_address"]]);
    } else {
        echo json_encode(['status' => 'error', 'message' => 'Address not found']);
    }
    exit;
}

// 2. GET CHEQUE (New - For Population)
if ($command == "get_cheque") {
    $refno = isset($_GET['refno']) ? $_GET['refno'] : '';
    $sql = "SELECT * FROM s_cheq WHERE CR_REFNO = '$refno'";
    $result = mysqli_query($GLOBALS['dbinv'], $sql);
    if ($row = mysqli_fetch_array($result)) {
        echo json_encode([
            'status' => 'success',
            'data' => [
                'CR_REFNO' => $row['CR_REFNO'],
                'CR_C_CODE' => $row['CR_C_CODE'],
                'CR_C_NAME' => $row['CR_C_NAME'],
                'CR_CHNO' => $row['CR_CHNO'],
                'CR_BANK' => $row['CR_BANK'],
                'CR_CHEVAL' => $row['CR_CHEVAL'],
                'CR_DATE' => $row['CR_DATE'],
                'CR_CHDATE' => $row['CR_CHDATE'],
                'depobank' => $row['depobank'],
                'DEPARTMENT' => $row['DEPARTMENT'],
                'S_REF' => $row['S_REF'],
                'reason' => $row['reason'],
                'REMARK' => $row['REMARK']
            ]
        ]);
    } else {
        echo json_encode(['status' => 'error', 'message' => 'Cheque not found']);
    }
    exit;
}

// 2. CHECK NUMBER (Legacy)
if ($command == "chk_number") {
    $sql = "select * from vendor where CODE = '" . trim($_GET["txt_cuscode"]) . "'";
    $result = mysqli_query($GLOBALS['dbinv'], $sql);
    if ($row = mysqli_fetch_array($result)) {
        echo json_encode(['status' => 'success', 'result' => 'included']);
    } else {
        echo json_encode(['status' => 'success', 'result' => 'no']);
    }
    exit;
}

// 3. NEW INVOICE
if ($command == "new_inv") {
    if ($_SESSION["dev"] == "") {
        echo json_encode(['status' => 'error', 'message' => 'No dev session']);
        exit;
    }
    $_SESSION["print"] = 0;

    $invno = "";
    if (isset($_GET["chk_crenote"]) && $_GET["chk_crenote"] == "true") {
        $sql = "Select debnoteno from invpara where flag='" . $_SESSION['company'] . "'";
        $result = mysqli_query($GLOBALS['dbinv'], $sql);
        $row = mysqli_fetch_array($result);
        $tmpinvno = "0000000" . $row["debnoteno"];
        $lenth = strlen($tmpinvno);
        $invno = trim("" . $_SESSION['company'] . "DEB/ ") . substr($tmpinvno, $lenth - 8);
    } else {
        $sql = "Select CHE_RET from invpara where flag='" . $_SESSION['company'] . "'";
        $result = mysqli_query($GLOBALS['dbinv'], $sql);
        $row = mysqli_fetch_array($result);
        $tmpinvno = "0000000" . $row["CHE_RET"];
        $lenth = strlen($tmpinvno);
        $invno = trim("" . $_SESSION['company'] . "RCH/ ") . substr($tmpinvno, $lenth - 8);
    }
    $_SESSION["txt_cuscode"] = "";

    echo json_encode([
        'status' => 'success',
        'invno' => $invno,
        'curdate' => date("Y-m-d")
    ]);
    exit;
}

// 4. CANCEL INVOICE
if ($command == "cancel_inv") {
    $sql_status = 0;
    mysqli_query($GLOBALS['dbinv'], "SET AUTOCOMMIT=0");
    mysqli_query($GLOBALS['dbinv'], "START TRANSACTION");

    $sql_rscheque = "Select * from s_cheq where CR_REFNO='" . trim($_GET["lblReciptNo"]) . "' and PAID=0";
    $result_rscheque = mysqli_query($GLOBALS['dbinv'], $sql_rscheque);

    if ($row_rscheque = mysqli_fetch_array($result_rscheque)) {
        $sql_strsqlstr = "update s_cheq set CR_FLAG='c' where CR_REFNO='" . trim($_GET["lblReciptNo"]) . "'";
        $result_strsqlstr = mysqli_query($GLOBALS['dbinv'], $sql_strsqlstr);
        if (!$result_strsqlstr)
            $sql_status = 1;

        $sql = "delete from s_led where REF_NO='" . $_GET["lblReciptNo"] . "'";
        $result = mysqli_query($GLOBALS['dbinv'], $sql);
        if (!$result)
            $sql_status = 2;

        $sql = "delete from a_ledger where l_refno='" . trim($_GET["lblReciptNo"]) . "' and chno='" . $_GET["txtChequeNo"] . "'";
        $result = mysqli_query($GLOBALS['dbinv'], $sql);
        if (!$result)
            $sql_status = 3;

        $sql = "update s_invcheq set ch_count_ret= '0' where cheque_no = '" . trim($_GET["txtChequeNo"]) . "' and cus_code = '" . trim($_GET["Txtcusco"]) . "' and bank = '" . trim($_GET["cmbBankname"]) . "'";
        $result = mysqli_query($GLOBALS['dbinv'], $sql);
        if (!$result)
            $sql_status = 4;

        $sql = "insert into entry_log(refno, username, docname, trnType, stime, sdate,COMPANY) values 
        ('" . trim($_GET["lblReciptNo"]) . "', '" . $_SESSION["CURRENT_USER"] . "', 'RetChqEntry', 'Cancel', '" . date("Y-m-d H:i:s") . "', '" . date("Y-m-d") . "','" . $_SESSION['company'] . "')";
        $result = mysqli_query($GLOBALS['dbinv'], $sql);
        if (!$result)
            $sql_status = 5;

        if ($sql_status == 0) {
            mysqli_query($GLOBALS['dbinv'], "COMMIT");
            echo json_encode(['status' => 'success', 'message' => 'Cancelled Successfully']);
        } else {
            mysqli_query($GLOBALS['dbinv'], "ROLLBACK");
            echo json_encode(['status' => 'error', 'message' => "Error has occured. Can't Delete - $sql_status"]);
        }
    } else {
        echo json_encode(['status' => 'error', 'message' => 'Record Not Found or Already Paid']);
    }
    exit;
}

// 5. ADD TEMP ITEM
if ($command == "add_tmp") {
    $department = $_GET["department"];

    $sql = "delete from tmp_inv_data where str_code='" . $_GET['itemcode'] . "' and str_invno='" . $_GET['invno'] . "' ";
    mysqli_query($GLOBALS['dbinv'], $sql);

    $rate = str_replace(",", "", $_GET["rate"]);
    $qty = str_replace(",", "", $_GET["qty"]);
    $discount = str_replace(",", "", $_GET["discount"]);
    $subtotal = str_replace(",", "", $_GET["subtotal"]);

    $sql = "Insert into tmp_inv_data (str_invno, str_code, str_description, cur_rate, cur_qty, dis_per, cur_discount, cur_subtot) values 
            ('" . $_GET['invno'] . "', '" . $_GET['itemcode'] . "', '" . $_GET['item'] . "', " . $rate . ", " . $qty . ", " . $_GET["discountper"] . ", " . $discount . ", " . $subtotal . ") ";
    mysqli_query($GLOBALS['dbinv'], $sql);

    // Return the updated grid data
    echo get_tmp_grid_json($department);
    exit;
}

// 6. DELETE TEMP ITEM
if ($command == "del_item") {
    $sql = "delete from tmp_inv_data where str_code='" . $_GET['code'] . "' and str_invno='" . $_GET['invno'] . "' ";
    mysqli_query($GLOBALS['dbinv'], $sql);

    echo get_tmp_grid_json($_GET["department"]);
    exit;
}

// Helper function to return Grid Data as JSON
function get_tmp_grid_json($department)
{
    if (!isset($_GET['invno']))
        return json_encode(['status' => 'error', 'message' => 'InvNo missing']);

    $items = [];
    $sql = "Select * from tmp_inv_data where str_invno='" . $_GET['invno'] . "'";
    $result = mysqli_query($GLOBALS['dbinv'], $sql);
    while ($row = mysqli_fetch_array($result)) {

        $qty = 0;
        $sqlqty = mysqli_query($GLOBALS['dbinv'], "select QTYINHAND from s_submas where STK_NO='" . $row['str_code'] . "' AND STO_CODE='" . $department . "'");
        if ($rowqty = mysqli_fetch_array($sqlqty)) {
            $qty = $rowqty['QTYINHAND'];
        }

        $items[] = [
            'code' => $row['str_code'],
            'description' => $row['str_description'],
            'rate' => number_format($row['cur_rate'], 2, ".", ","),
            'qty' => number_format($row['cur_qty'], 2, ".", ","),
            'discount_per' => number_format($row['dis_per'], 2, ".", ","),
            'subtotal' => number_format($row['cur_subtot'], 2, ".", ","),
            'qty_in_hand' => $qty
        ];
    }

    $sql = "Select sum(cur_subtot) as tot_sub, sum(cur_discount) as tot_dis from tmp_inv_data where str_invno='" . $_GET['invno'] . "'";
    $result = mysqli_query($GLOBALS['dbinv'], $sql);
    $row = mysqli_fetch_array($result);

    $tot_sub = $row['tot_sub'];
    $tot_dis = $row['tot_dis'];

    $vatrate = 0.12;
    $vatmethod = isset($_GET["vatmethod"]) ? $_GET["vatmethod"] : 'vat';
    $tax = 0;
    $taxname = "Tax";

    if ($vatmethod == "vat") {
        $tax = $tot_sub * $vatrate;
        $taxname = "Tax (VAT 12%)";
    } else if ($vatmethod == "svat") {
        $tax = $tot_sub * $vatrate;
        $taxname = "Tax (SVAT 12%)";
    } else if ($vatmethod == "evat") {
        $tax = $tot_sub * $vatrate;
        $taxname = "Tax (EVAT 12%)";
    } else if ($vatmethod == "non") { // Legacy code says "non"
        $tax = 0;
        $taxname = "Tax";
    }

    $invtot = $tot_sub + $tax;

    return json_encode([
        'status' => 'success',
        'items' => $items,
        'subtot' => number_format($tot_sub, 2, ".", ","),
        'tot_dis' => number_format($tot_dis, 2, ".", ","),
        'tax' => number_format($tax, 2, ".", ","),
        'taxname' => $taxname,
        'invtot' => number_format($invtot, 2, ".", ",")
    ]);
}


// 7. SAVE ITEM
if ($command == "save_item") {

    if ($_SESSION["dev"] == "") {
        echo json_encode(['status' => 'error', 'message' => 'No dev session']);
        exit;
    }

    $sqltmp = "select * from invpara where flag='" . $_SESSION['company'] . "'";
    $resulttmp = mysqli_query($GLOBALS['dbinv'], $sqltmp);
    $rowtmp = mysqli_fetch_array($resulttmp);

    if ($rowtmp["form_loc"] == "1") {
        echo json_encode(['status' => 'error', 'message' => 'Form Locked']);
        exit;
    }

    $_SESSION["CURRENT_DOC"] = 1;
    $_SESSION["FEED_DOC"] = true;

    $sql_status = 0;

    mysqli_query($GLOBALS['dbinv'], "SET AUTOCOMMIT=0");
    mysqli_query($GLOBALS['dbinv'], "START TRANSACTION");

    // Check Vendor
    $sql_strsqlstr = "Select * from vendor where CODE='" . trim($_GET["Txtcusco"]) . "'";
    $result_strsqlstr = mysqli_query($GLOBALS['dbinv'], $sql_strsqlstr);
    if (!mysqli_fetch_array($result_strsqlstr)) {
        echo json_encode(['status' => 'error', 'message' => 'Invalid Customer']);
        exit;
    }

    // Check Cheque Duplication
    $sql_rscheque = "Select CR_CHNO from s_cheq where CR_CHNO='" . trim($_GET["txtChequeNo"]) . "' AND CR_CHNO='0'";
    $result_rscheque = mysqli_query($GLOBALS['dbinv'], $sql_rscheque);
    if ($row_rscheque = mysqli_fetch_array($result_rscheque)) {
        if ($_GET["txt_stat"] == "NEW") {
            echo json_encode(['status' => 'error', 'message' => 'Cheque No Already Entered']);
            exit;
        }
    }

    // Update Counter
    $sql_rscheque = "Select * from s_cheq where CR_REFNO='" . trim($_GET["lblReciptNo"]) . "'";
    $result_rscheque = mysqli_query($GLOBALS['dbinv'], $sql_rscheque);
    if (!$row_rscheque = mysqli_fetch_array($result_rscheque)) {
        $sql = "update invpara set CHE_RET=CHE_RET+1 where flag='" . $_SESSION['company'] . "'";
        $result = mysqli_query($GLOBALS['dbinv'], $sql);
        if ($result == false)
            $sql_status = 1;
    }

    $dev = ($_GET["op_computer"] == "true") ? 0 : 0; // Logic copied from legacy
    $chk_crenote = ($_GET["chk_crenote"] == "true") ? 1 : 0;
    $lblnoof = $_GET["lblnoof"] + 1;
    $countrtn = ($_GET["Check1"] == "true") ? 1 : 0;

    // Update or Insert s_cheq
    $sql_rscheque1 = "Select * from s_cheq where CR_REFNO='" . trim($_GET["lblReciptNo"]) . "'";
    $result_rscheque1 = mysqli_query($GLOBALS['dbinv'], $sql_rscheque1);

    if ($row_rscheque1 = mysqli_fetch_array($result_rscheque1)) {
        $sql_rscheque = "update s_cheq set depobank='" . $_GET["cheq_dpo_bank"] . "', REMARK='" . $_GET["txtremark"] . "',ch_count_ret='" . $countrtn . "', reason='" . $_GET["reason"] . "' where CR_REFNO='" . $_GET["lblReciptNo"] . "'";
        $result_rscheque = mysqli_query($GLOBALS['dbinv'], $sql_rscheque);
        if (!$result_rscheque)
            $sql_status = 2;
    } else {
        $sql_rscheque = "insert into s_cheq (CR_REFNO, CR_DATE, CR_C_CODE, CR_C_NAME, CR_REPAY, CR_BANK, REMARK, reason, CR_CHEVAL, CR_CHNO, DEPARTMENT, S_REF, CR_CHDATE, DEBACC, depobank, ret_chno, ret_chdate, noof, ret_refno, tmp, FORwhat, crenoteno, crenoteamo, dev, debnoteno, CR_REPOSIT, CR_FLAG, PAID, CR_CRVAL,retcout,pdno,ch_count_ret,company) values
        ('" . $_GET["lblReciptNo"] . "', '" . $_GET["DTPicker1"] . "', '" . $_GET["Txtcusco"] . "', '" . $_GET["txtcusname"] . "', '" . $_GET["txtRetChCha"] . "', '" . $_GET["cmbBankname"] . "', '" . $_GET["txtremark"] . "', '" . $_GET["reason"] . "', '" . $_GET["txtChequeAmount"] . "', '" . $_GET["txtChequeNo"] . "', '" . $_GET["com_dep"] . "', '" . $_GET["com_rep"] . "', '" . $_GET["DTPicker2"] . "', '" . $_GET["Txtacco"] . "', '" . $_GET["cheq_dpo_bank"] . "', '" . $_GET["lblRET_chno"] . "', '" . $_GET["lblretdate"] . "', '" . $lblnoof . "', '" . $_GET["lblretrefno"] . "', '0', '" . $_GET["txtforwhat"] . "', '" . $_GET["txtcrenoteno"] . "', '" . $_GET["txtcrenoteamo"] . "', '" . $dev . "', '" . $chk_crenote . "', 1, '0', 0, 0,'" . $_GET['txtretcount'] . "','" . $_GET['txtoriginal'] . "','" . $countrtn . "','" . $_SESSION['company'] . "')";
        $result_rscheque = mysqli_query($GLOBALS['dbinv'], $sql_rscheque);
        if (!$result_rscheque)
            $sql_status = 3;
    }

    // Insert s_cheq_tmp
    $sql_rscheque = "insert into s_cheq_tmp (CR_REFNO, CR_DATE, CR_C_CODE, CR_C_NAME, CR_REPAY, CR_BANK, REMARK, reason, CR_CHEVAL, CR_CHNO, DEPARTMENT, S_REF, CR_CHDATE, DEBACC, depobank, ret_chno, ret_chdate, noof, ret_refno, tmp, FORwhat, crenoteno, crenoteamo, dev, debnoteno, CR_REPOSIT, CR_FLAG, PAID, CR_CRVAL, updated,company) values 
    ('" . $_GET["lblReciptNo"] . "', '" . $_GET["DTPicker1"] . "', '" . $_GET["Txtcusco"] . "', '" . $_GET["txtcusname"] . "', '" . $_GET["txtRetChCha"] . "', '" . $_GET["cmbBankname"] . "', '" . $_GET["txtremark"] . "', '" . $_GET["reason"] . "', '" . $_GET["txtChequeAmount"] . "', '" . $_GET["txtChequeNo"] . "', '" . $_GET["com_dep"] . "', '" . $_GET["com_rep"] . "', '" . $_GET["DTPicker2"] . "', '" . $_GET["Txtacco"] . "', '" . $_GET["cheq_dpo_bank"] . "', '" . $_GET["lblRET_chno"] . "', '" . $_GET["lblretdate"] . "', '" . $lblnoof . "', '" . $_GET["lblretrefno"] . "', '0', '" . $_GET["txtforwhat"] . "', '" . $_GET["txtcrenoteno"] . "', '" . $_GET["txtcrenoteamo"] . "', '" . $dev . "', '" . $chk_crenote . "', 1, '0', 0, 0, '0','" . $_SESSION['company'] . "')";
    $result_rscheque = mysqli_query($GLOBALS['dbinv'], $sql_rscheque);
    if (!$result_rscheque)
        $sql_status = 4;

    // Delete existing ledger entries
    $sql = "delete from s_led where REF_NO='" . $_GET["lblReciptNo"] . "'";
    $result = mysqli_query($GLOBALS['dbinv'], $sql);
    if (!$result)
        $sql_status = 5;

    // Insert s_led
    $m_flag = "RCH";
    $sql = "Insert into s_led (REF_NO, SDATE, C_CODE, AMOUNT, FLAG, DEPARTMENT,company) values 
    ('" . trim($_GET["lblReciptNo"]) . "', '" . $_GET["DTPicker1"] . "','" . trim($_GET["Txtcusco"]) . "', " . $_GET["txtChequeAmount"] . ", '" . $m_flag . "','" . trim($_GET["com_dep"]) . "','" . $_SESSION['company'] . "')";
    $result = mysqli_query($GLOBALS['dbinv'], $sql);
    if (!$result)
        $sql_status = 6;


    $mretch = 0;
    if ($_GET["txtRetChCha"] != "") {
        $mretch = floatval($_GET["txtRetChCha"]);
    }

    $macc = "";
    $sql_para = "select * from invpara where flag='" . $_SESSION['company'] . "'";
    $result_para = mysqli_query($GLOBALS['dbinv'], $sql_para);
    if ($row_para = mysqli_fetch_array($result_para)) {
        $macc = $row_para['RETCH_AC'];
    }

    $mNara = "RETURN CHEQUE - " . $_GET["txtChequeNo"];

    $sql = "delete from a_ledger where l_refno='" . trim($_GET["lblReciptNo"]) . "' and chno='" . $_GET["txtChequeNo"] . "'";
    $result = mysqli_query($GLOBALS['dbinv'], $sql);
    if (!$result)
        $sql_status = 7;

    $accsdate = $_GET["bank_st_date"]; // Caution: This GET parameter was NOT in the user's legacy 'save_item' URL params in JS, but used in PHp. Need to ensure Frontend passes it.
    // Assuming user sends it. If not, fallback to today.
    if (empty($accsdate))
        $accsdate = date("Y-m-d");

    $accmonth = date("m", strtotime($accsdate));
    $accyear = date("Y", strtotime($accsdate));

    if ($accmonth <= 3) {
        $ayear = $accyear - 1;
    } else {
        $ayear = $accyear;
    }

    $sql1 = "Insert into a_ledger(l_refno, l_date, l_code, l_amount, l_flag, l_flag1, l_lmem, rights, l_flag2, l_flag3, comcode, l_yearfl, recdate, Acyear, chno) Values 
    ('" . trim($_GET["lblReciptNo"]) . "', '" . $accsdate . "', '" . trim($_GET["Txtacco"]) . "', '" . ($_GET["txtChequeAmount"] + $mretch) . "', 'RTN', 'DEB', '" . $mNara . "', '" . $_SESSION['UserName'] . "', '0', 'R', '" . $_SESSION['company'] . "', '0', '0', '" . $ayear . "', '" . $_GET["txtChequeNo"] . "')";
    $result1 = mysqli_query($GLOBALS['dbinv'], $sql1);
    if (!$result1)
        $sql_status = 8;

    $sql1 = "Insert into a_ledger(l_refno, l_date, l_code, l_amount, l_flag, l_flag1, l_lmem, rights, l_flag2, l_flag3, comcode, l_yearfl, recdate, Acyear, chno) Values
    ('" . trim($_GET["lblReciptNo"]) . "', '" . $accsdate . "', '" . trim($_GET["cheq_dpo_bank"]) . "', '" . $_GET["txtChequeAmount"] . "', 'RTN', 'CRE', '" . $mNara . "', '" . $_SESSION['UserName'] . "', '0', 'R', '" . $_SESSION['company'] . "', '0', '0', '" . $ayear . "', '" . $_GET["txtChequeNo"] . "')";
    $result1 = mysqli_query($GLOBALS['dbinv'], $sql1);
    if (!$result1)
        $sql_status = 9;

    $sql1 = "Insert into a_ledger(l_refno, l_date, l_code, l_amount, l_flag, l_flag1, l_lmem, rights, l_flag2, l_flag3, comcode, l_yearfl, recdate, Acyear, chno) Values 
    ('" . trim($_GET["lblReciptNo"]) . "', '" . $accsdate . "', '" . trim($macc) . "','" . $mretch . "', 'RTN', 'CRE', '" . addslashes($mNara) . "', '" . $_SESSION['UserName'] . "', '0', 'R', '" . $_SESSION['company'] . "', '0', '0', '" . $ayear . "', '" . $_GET["txtChequeNo"] . "')";
    $result1 = mysqli_query($GLOBALS['dbinv'], $sql1);
    if (!$result1)
        $sql_status = 10;

    // History (Optional loop from filtered get params)
    $a = 1;
    if (isset($_GET["mcount"])) {
        while ($_GET["mcount"] > $a) {
            $REF_NO = "REF_NO_" . $a;
            $SDATE = "SDATE_" . $a;
            $GRAND_TOT = "GRAND_TOT_" . $a;
            $st_amou = "st_amou_" . $a;

            if (isset($_GET[$REF_NO]) && trim($_GET[$REF_NO]) != "") {
                $sql_strsqlstr = "delete from ret_chq_history where Ref_no='" . trim($_GET[$REF_NO]) . "' and chk_no='" . $_GET["txtChequeNo"] . "'";
                $result_strsqlstr = mysqli_query($GLOBALS['dbinv'], $sql_strsqlstr);
                if (!$result_strsqlstr)
                    $sql_status = 11;

                $sql_chq = "insert into ret_chq_history (Ref_no, Inv_no, Inv_date, inv_Amt, st_amt, chk_no,company) values 
                ('" . trim($_GET["lblReciptNo"]) . "','" . trim($_GET[$REF_NO]) . "', '" . $_GET[$SDATE] . "', " . $_GET[$GRAND_TOT] . ", '" . $_GET[$st_amou] . "', '" . $_GET['txtChequeNo'] . "','" . $_SESSION['company'] . "')";
                $result_chq = mysqli_query($GLOBALS['dbinv'], $sql_chq);
                if (!$result_chq)
                    $sql_status = 12;
            }
            $a = $a + 1;
        }
    }

    if ($_GET["Check1"] == "true") {
        $sql = "update s_invcheq set ch_count_ret= '1' where cheque_no = '" . trim($_GET["txtChequeNo"]) . "' and cus_code = '" . trim($_GET["Txtcusco"]) . "' and bank = '" . trim($_GET["cmbBankname"]) . "'";
        $result = mysqli_query($GLOBALS['dbinv'], $sql);
        if (!$result)
            $sql_status = 13;

        $sql = "insert into s_invcheq_tmp (CR_REFNO, ch_count_ret, cheque_no, cus_code, bank,company) value 
        ('" . trim($_GET["lblReciptNo"]) . "', '1', '" . trim($_GET["txtChequeNo"]) . "', '" . trim($_GET["Txtcusco"]) . "', '" . trim($_GET["cmbBankname"]) . "','" . $_SESSION['company'] . "')";
        $result = mysqli_query($GLOBALS['dbinv'], $sql);
        if (!$result)
            $sql_status = 14;
    } else {
        $sql = "update s_invcheq set ch_count_ret= '0' where cheque_no = '" . trim($_GET["txtChequeNo"]) . "' and cus_code = '" . trim($_GET["Txtcusco"]) . "' and bank = '" . trim($_GET["cmbBankname"]) . "'";
        $result = mysqli_query($GLOBALS['dbinv'], $sql);
        if (!$result)
            $sql_status = 15;

        $sql = "insert into s_invcheq_tmp (CR_REFNO, ch_count_ret, cheque_no, cus_code, bank,company) value 
        ('" . trim($_GET["lblReciptNo"]) . "', '0', '" . trim($_GET["txtChequeNo"]) . "', '" . trim($_GET["Txtcusco"]) . "', '" . trim($_GET["cmbBankname"]) . "','" . $_SESSION['company'] . "')";
        $result = mysqli_query($GLOBALS['dbinv'], $sql);
        if (!$result)
            $sql_status = 16;
    }

    $sqlSave = "insert into entry_log(refno, username, docname, trnType, stime, sdate,COMPANY) values 
    ('" . trim($_GET["lblReciptNo"]) . "', '" . $_SESSION["CURRENT_USER"] . "', 'RetChqEntry', 'Save', '" . date("Y-m-d H:i:s") . "', '" . date("Y-m-d") . "','" . $_SESSION['company'] . "')";
    $resultSave = mysqli_query($GLOBALS['dbinv'], $sqlSave);
    if (!$resultSave)
        $sql_status = 17;

    if ($sql_status == 0) {
        mysqli_query($GLOBALS['dbinv'], "COMMIT");
        mysqli_query($GLOBALS['dbacc'], "COMMIT"); // Assuming dbacc is also open
        echo json_encode(['status' => 'success', 'message' => 'Saved']);
    } else {
        mysqli_query($GLOBALS['dbinv'], "ROLLBACK");
        mysqli_query($GLOBALS['dbacc'], "ROLLBACK");
        echo json_encode(['status' => 'error', 'message' => 'Error has occured. Can\'t Save - Error No : ' . $sql_status]);
    }
    exit;
}

if ($command == "check_print") {
    echo json_encode(['status' => 'success', 'print' => $_SESSION["print"]]);
    exit;
}

if ($command == "up_remark") {
    $sqlblack = "update s_cheq set reason='" . $_GET["reason"] . "'  where CR_REFNO='" . trim($_GET["lblReciptNo"]) . "'";
    $resultblack = mysqli_query($GLOBALS['dbinv'], $sqlblack);

    $sqlblack1 = "update s_cheq_tmp set reason='" . $_GET["reason"] . "'  where CR_REFNO='" . trim($_GET["lblReciptNo"]) . "'";
    $resultblack1 = mysqli_query($GLOBALS['dbinv'], $sqlblack1);

    echo json_encode(['status' => 'success', 'message' => 'Updated..']);
    exit;
}

// Default
echo json_encode(['status' => 'error', 'message' => 'Invalid Command']);
?>