<?php
session_start();
require_once("connectioni.php");
?>
<!DOCTYPE html>
<html lang="en">

<head>
	<meta charset="UTF-8">
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	<title>Return Cheque Entry</title>

	<!-- Bootstrap 3.3.7 -->
	<link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/css/bootstrap.min.css">
	<!-- Font Awesome -->
	<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">

	<style>
		body {
			background-color: #ecf0f5;
			font-family: 'Source Sans Pro', sans-serif;
		}

		.box {
			background: #fff;
			border-top: 3px solid #d2d6de;
			box-shadow: 0 1px 1px rgba(0, 0, 0, 0.1);
			margin-bottom: 20px;
		}

		.box.box-primary {
			border-top-color: #3c8dbc;
		}

		.box-header {
			padding: 10px;
			border-bottom: 1px solid #f4f4f4;
		}

		.btn-app {
			color: #444;
			background: #f4f4f4;
			border: 1px solid #ddd;
			padding: 12px 5px;
			height: 60px;
			min-width: 80px;
			margin: 0 5px 5px 0;
		}

		.btn-app:hover {
			background: #e7e7e7;
		}

		.form-control {
			border-radius: 0;
		}

		.navbar-custom {
			background-color: #2c3e50;
			color: white;
			padding: 10px 20px;
			display: flex;
			justify-content: space-between;
			margin-bottom: 20px;
		}
	</style>

	<script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
	<script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/js/bootstrap.min.js"></script>
	<script src="js/ret_cheque_entry.js"></script>
</head>

<body>

	<div style="font-size: 24px; font-weight: bold;">ERP SYSTEM</div>
	<div style="font-size: 18px;">Return Cheque Entry</div>
	<div>Welcome, <?php echo isset($_SESSION['CURRENT_USER']) ? $_SESSION['CURRENT_USER'] : 'User'; ?></div>
	</div>

	<div class="container-fluid">

		<!-- Toolbar -->
		<div class="box box-solid">
			<div class="box-body">
				<a onclick="new_inv()" class="btn btn-app"><i class="fa fa-file"></i> New</a>
				<a onclick="save_inv()" class="btn btn-app"><i class="fa fa-save"></i> Save</a>
				<a onclick="cancel_inv()" class="btn btn-app"><i class="fa fa-ban"></i> Cancel</a>
				<a onclick="print_inv()" class="btn btn-app"><i class="fa fa-print"></i> Print</a>
				<a onclick="close_form()" class="btn btn-app"><i class="fa fa-close"></i> Close</a>
			</div>
		</div>

		<div class="row">
			<!-- Main Form -->
			<div class="col-md-12">
				<div class="box box-primary">
					<div class="box-header with-border">
						<h3 class="box-title">Return Details</h3>
					</div>
					<div class="box-body">
						<form class="form-horizontal">

							<!-- Top Section: Reference & Department -->
							<div class="form-group">
								<label class="col-sm-2 control-label">Ref No</label>
								<div class="col-sm-2">
									<input type="text" id="lblReciptNo" class="form-control" readonly>
								</div>
								<div class="col-sm-1">
									<a class="btn btn-default" onclick="search_cheque()"><i
											class="fa fa-search"></i></a>
								</div>

								<label class="col-sm-2 control-label">Date</label>
								<div class="col-sm-2">
									<input type="date" id="DTPicker1" class="form-control"
										value="<?php echo date('Y-m-d'); ?>">
								</div>

								<label class="col-sm-1 control-label">Cost Center</label>
								<div class="col-sm-2">
									<select id="com_costcent" class="form-control">
										<option value="">Select</option>
										<?php
										$sql = "select * from s_stomas order by CODE";
										$result = mysqli_query($GLOBALS['dbinv'], $sql);
										while ($row = mysqli_fetch_array($result)) {
											echo "<option value='" . $row["CODE"] . "'>" . $row["CODE"] . " " . $row["DESCRIPTION"] . "</option>";
										}
										?>
									</select>
								</div>
							</div>

							<!-- Department & Rep -->
							<div class="form-group">
								<label class="col-sm-2 control-label">Department</label>
								<div class="col-sm-2">
									<select id="com_dep" class="form-control">
										<option value="">Select Department</option>
										<?php
										$sql = "select * from s_stomas order by CODE";
										$result = mysqli_query($GLOBALS['dbinv'], $sql);
										while ($row = mysqli_fetch_array($result)) {
											echo "<option value='" . $row["CODE"] . "'>" . $row["CODE"] . " " . $row["DESCRIPTION"] . "</option>";
										}
										?>
									</select>
								</div>

								<label class="col-sm-2 control-label">Marketing Ex.</label>
								<div class="col-sm-2">
									<select id="com_rep" class="form-control">
										<option value="">Select Rep</option>
										<?php
										$sql = "select * from s_salrep order by CODE";
										$result = mysqli_query($GLOBALS['dbinv'], $sql);
										while ($row = mysqli_fetch_array($result)) {
											echo "<option value='" . $row["REPCODE"] . "'>" . $row["REPCODE"] . " " . $row["Name"] . "</option>";
										}
										?>
									</select>
								</div>
							</div>

							<hr>

							<!-- Customer Section -->
							<div class="form-group">
								<label class="col-sm-2 control-label">Customer</label>
								<div class="col-sm-2">
									<input type="text" id="Txtcusco" class="form-control" placeholder="Code">
								</div>
								<div class="col-sm-6">
									<input type="text" id="txtcusname" class="form-control" placeholder="Name">
								</div>
							</div>

							<!-- Cheque Details -->
							<div class="form-group">
								<label class="col-sm-2 control-label">Cheque No</label>
								<div class="col-sm-2">
									<input type="text" id="txtChequeNo" class="form-control">
								</div>

								<label class="col-sm-2 control-label">Bank</label>
								<div class="col-sm-2">
									<select id="cmbBankname" class="form-control">
										<option value="">Select Bank</option>
										<?php
										$sql = "select * from bank_mas order by bcode";
										$result = mysqli_query($GLOBALS['dbinv'], $sql);
										while ($row = mysqli_fetch_array($result)) {
											echo "<option value='" . $row["bcode"] . "'>" . $row["bcode"] . " " . $row["bname"] . "</option>";
										}
										?>
									</select>
								</div>

								<label class="col-sm-2 control-label">Amount</label>
								<div class="col-sm-2">
									<input type="text" id="txtChequeAmount" class="form-control text-right"
										style="color:red; font-weight:bold;">
								</div>
							</div>

							<!-- More Dates & Accounts -->
							<div class="form-group">
								<label class="col-sm-2 control-label">Cheque Date</label>
								<div class="col-sm-2">
									<input type="date" id="DTPicker2" class="form-control">
								</div>

								<label class="col-sm-2 control-label">Deposit Bank</label>
								<div class="col-sm-2">
									<select id="cheq_dpo_bank" class="form-control">
										<option value="">Select Account</option>
										<?php
										$sql = "select * from bank_mas order by bcode";
										$result = mysqli_query($GLOBALS['dbinv'], $sql);
										while ($row = mysqli_fetch_array($result)) {
											echo "<option value='" . $row["bcode"] . "'>" . $row["bcode"] . " " . $row["bname"] . "</option>";
										}
										?>
									</select>
								</div>

								<label class="col-sm-2 control-label">Return Date</label>
								<div class="col-sm-2">
									<input type="date" id="lblretdate" class="form-control">
								</div>
							</div>

							<div class="form-group">
								<label class="col-sm-2 control-label">Reason</label>
								<div class="col-sm-4">
									<select id="reason" class="form-control">
										<option value="1">1 - Refer to drawer</option>
										<option value="2">2 - Effects not realized</option>
										<option value="50">50 - Stale cheque</option>
										<option value="60">60 - Other</option>
									</select>
								</div>

								<label class="col-sm-2 control-label">Remarks</label>
								<div class="col-sm-4">
									<textarea id="txtremark" class="form-control" rows="1"></textarea>
								</div>
							</div>

							<!-- Hidden / Legacy Fields -->
							<div class="form-group hidden">
								<input type="checkbox" id="chk_crenote"> Credit Note
								<input type="checkbox" id="Check1"> Return Counter
								<input type="checkbox" id="op_computer"> Computer
								<input type="text" id="txtRetChCha"> Charges
								<input type="text" id="txtforwhat"> For What
								<input type="text" id="lblRET_chno"> Ret Ch No
								<input type="text" id="lblnoof"> No Of
								<input type="text" id="lblretrefno"> Ret Ref No
								<input type="text" id="txtcrenoteno"> CN No
								<input type="text" id="txtcrenoteamo"> CN Amt
								<!-- Fields for account logic -->
								<input type="text" id="Txtacco" value="">
								<input type="text" id="txtretcount" value="">
								<input type="text" id="txtoriginal" value="">

							</div>

						</form>
					</div>
				</div>
			</div>
		</div>
	</div>

</body>

</html>