<?php
session_start();

// Database Connection
require_once("connection_sql.php");

// Set content type to JSON
header('Content-Type: application/json');

date_default_timezone_set('Asia/Colombo');

try {
    $command = $_GET['Command'] ?? '';

    if ($command === 'get_arn') {
        $arnNo = $_GET['arnno'] ?? '';

        // Fetch Header
        $sql = "SELECT * FROM s_purmas WHERE REFNO = :refno";
        $stmt = $conn->prepare($sql);
        $stmt->bindParam(':refno', $arnNo);
        $stmt->execute();
        $header = $stmt->fetch(PDO::FETCH_ASSOC);

        if (!$header) {
            echo json_encode(['status' => 'error', 'message' => 'ARN not found']);
            exit;
        }

        // Fetch Details
        $sqlDetails = "SELECT * FROM s_purtrn WHERE REFNO = :refno";
        $stmtDetails = $conn->prepare($sqlDetails);
        $stmtDetails->bindParam(':refno', $arnNo);
        $stmtDetails->execute();
        $items = $stmtDetails->fetchAll(PDO::FETCH_ASSOC);

        echo json_encode(['status' => 'success', 'header' => $header, 'items' => $items]);
        exit;
    }

    if ($command === 'save_return') {
        $conn->beginTransaction();

        $refNo = $_POST['refno'] ?? '';
        $arnNo = $_POST['arnno'] ?? '';
        $date = $_POST['date'] ?? date('Y-m-d');
        $department = $_POST['department'] ?? '';
        $supplierCode = $_POST['supplier_code'] ?? '';
        $supplierName = $_POST['supplier_name'] ?? '';
        $remarks = $_POST['remarks'] ?? '';
        $totalValue = str_replace(',', '', $_POST['total_value'] ?? '0');

        // Items JSON
        $items = json_decode($_POST['items'], true);

        // Generate Auto Number if new
        if (empty($refNo) || $refNo == 'New') {
            $sqlPara = "SELECT * FROM invpara";
            $stmtPara = $conn->query($sqlPara);
            $rowPara = $stmtPara->fetch(PDO::FETCH_ASSOC);

            // Assuming simplified auto-gen logic based on typical patterns in this codebase
            // You might want to update a specific table like `tmpinvpara` or `invpara` to increment the counter
            // For safety, let's look for a counter for PurRet (often sharing `s_purmas` sequence or separate)
            // I'll assume we use a prefix + sequence

            // Check for Pur Return sequence in invpara, if not found, use a fallback

            $sqlGetRef = "SELECT max(REFNO) as max_ref FROM s_purmas WHERE REFNO LIKE 'RET/%'";
            $stmtGetRef = $conn->query($sqlGetRef);
            $rowGetRef = $stmtGetRef->fetch(PDO::FETCH_ASSOC);

            $lastRef = $rowGetRef['max_ref'];
            if ($lastRef) {
                $num = intval(substr($lastRef, 4)) + 1;
                $refNo = 'RET/' . str_pad($num, 6, "0", STR_PAD_LEFT);
            } else {
                $refNo = 'RET/000001';
            }
        }

        // Insert Header
        // Storing in s_purmas with TYPE='RET' to differentiate from ARN
        $sqlHead = "INSERT INTO s_purmas (REFNO, SDATE, SUP_CODE, SUP_NAME, DEPARTMENT, REMARK, AMOUNT, PTYPE, CANCEL, COMPANY) VALUES (:refno, :sdate, :sup_code, :sup_name, :dept, :remark, :amount, 'RET', '0', :company)";
        $stmtHead = $conn->prepare($sqlHead);
        $stmtHead->execute([
            ':refno' => $refNo,
            ':sdate' => $date,
            ':sup_code' => $supplierCode,
            ':sup_name' => $supplierName,
            ':dept' => $department,
            ':remark' => $remarks,
            ':amount' => $totalValue,
            ':company' => $_SESSION['company'] ?? ''
        ]);

        // Insert Items and Update Stock
        foreach ($items as $item) {
            if ($item['return_qty'] > 0) {
                $sqlItem = "INSERT INTO s_purtrn (REFNO, SDATE, STK_NO, DESCRIPT, REC_QTY, PRICE, COST, SUB_TOTAL) VALUES (:refno, :sdate, :stk_no, :desc, :qty, :price, :cost, :subtot)";
                $stmtItem = $conn->prepare($sqlItem);

                $subTotal = floatval($item['return_qty']) * floatval($item['price']);

                $stmtItem->execute([
                    ':refno' => $refNo,
                    ':sdate' => $date,
                    ':stk_no' => $item['code'],
                    ':desc' => $item['description'],
                    ':qty' => $item['return_qty'], // Storing positive qty for return record
                    ':price' => $item['price'],
                    ':cost' => $item['cost'] ?? 0,
                    ':subtot' => $subTotal
                ]);

                // Stock Update (Subtract from Stock)
                $sqlStk = "UPDATE s_mas SET QTYINHAND = QTYINHAND - :qty WHERE STK_NO = :stk_no";
                $stmtStk = $conn->prepare($sqlStk);
                $stmtStk->execute([':qty' => $item['return_qty'], ':stk_no' => $item['code']]);

                $sqlSubStk = "UPDATE s_submas SET QTYINHAND = QTYINHAND - :qty WHERE STK_NO = :stk_no AND STO_CODE = :dept";
                $stmtSubStk = $conn->prepare($sqlSubStk);
                $stmtSubStk->execute([':qty' => $item['return_qty'], ':stk_no' => $item['code'], ':dept' => $department]);
            }
        }

        // Ledger Entry check (Vendor update)
        $sqlVen = "UPDATE vendor SET CUR_BAL = CUR_BAL - :val WHERE CODE = :code";
        $stmtVen = $conn->prepare($sqlVen);
        $stmtVen->execute([':val' => $totalValue, ':code' => $supplierCode]);

        $conn->commit();
        echo json_encode(['status' => 'success', 'refno' => $refNo, 'message' => 'Saved Successfully']);
        exit;
    }

} catch (Exception $e) {
    if ($conn->inTransaction()) {
        $conn->rollBack();
    }
    echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
    exit;
}
?>