<?php
session_start();
require_once("connection_sql.php");
date_default_timezone_set('Asia/Colombo');
?>
<!DOCTYPE html>
<html lang="en">

<head>
	<meta charset="UTF-8">
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	<title>Purchase Return</title>
	<!-- Bootstrap 3.3.7 -->
	<link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/css/bootstrap.min.css">
	<!-- Font Awesome -->
	<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">

	<!-- Scripts -->
	<script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
	<script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/js/bootstrap.min.js"></script>
	<script language="JavaScript" src="js/purchase_ret.js"></script>

	<!-- Popup Window Script -->
	<script language="javascript" type="text/javascript">
		var win = null;
		function NewWindow(mypage, myname, w, h, scroll, pos) {
			if (pos == "random") { LeftPosition = (screen.width) ? Math.floor(Math.random() * (screen.width - w)) : 100; TopPosition = (screen.height) ? Math.floor(Math.random() * ((screen.height - h) - 75)) : 100; }
			if (pos == "center") { LeftPosition = (screen.width) ? (screen.width - w) / 2 : 100; TopPosition = (screen.height) ? (screen.height - h) / 2 : 100; }
			else if ((pos != "center" && pos != "random") || pos == null) { LeftPosition = 0; TopPosition = 20 }
			settings = 'width=' + w + ',height=' + h + ',top=' + TopPosition + ',left=' + LeftPosition + ',scrollbars=' + scroll + ',location=no,directories=no,status=no,menubar=no,toolbar=no,resizable=no';
			win = window.open(mypage, myname, settings);
		}
		function close_form() {
			window.location.href = "index.php";
		}
	</script>

	<!-- Initial Load Script -->
	<script type="text/javascript">
		window.onload = function () {
			new_inv(); // Initialize
		};
	</script>

	<style>
		body {
			background-color: #ecf0f5;
			font-family: 'Source Sans Pro', 'Helvetica Neue', Helvetica, Arial, sans-serif;
			font-size: 14px;
		}

		/* Navbar Styles */
		.navbar-custom {
			background-color: #2c3e50;
			color: white;
			padding: 10px 20px;
			display: flex;
			justify-content: space-between;
			align-items: center;
			box-shadow: 0 2px 5px rgba(0, 0, 0, 0.1);
			margin-bottom: 20px;
		}

		.navbar-brand {
			font-size: 24px;
			font-weight: bold;
			color: white !important;
			text-decoration: none;
			padding: 0;
			height: auto;
			line-height: normal;
		}

		.page-title-box {
			background: rgba(255, 255, 255, 0.1);
			border: 1px solid rgba(255, 255, 255, 0.2);
			padding: 8px 30px;
			border-radius: 5px;
			font-size: 18px;
			font-weight: 600;
			letter-spacing: 1px;
			text-transform: uppercase;
		}

		.user-info {
			display: flex;
			align-items: center;
			gap: 15px;
		}

		.logout-btn {
			background-color: #e74c3c;
			color: white;
			border: none;
			padding: 6px 15px;
			border-radius: 4px;
			font-weight: 600;
			transition: background 0.3s;
			text-decoration: none !important;
		}

		.logout-btn:hover {
			background-color: #c0392b;
			color: white;
		}

		.user-name {
			font-weight: bold;
		}

		/* Content Wrapper */
		.content-wrapper {
			padding: 20px;
		}

		/* Box/Card Styling */
		.box {
			background: #fff;
			border-top: 3px solid #d2d6de;
			margin-bottom: 20px;
			width: 100%;
			box-shadow: 0 1px 1px rgba(0, 0, 0, 0.1);
			border-radius: 3px;
		}

		.box.box-primary {
			border-top-color: #3c8dbc;
		}

		.box-header {
			color: #444;
			display: block;
			padding: 10px;
			position: relative;
			border-bottom: 1px solid #f4f4f4;
		}

		.box-header .box-title {
			display: inline-block;
			font-size: 18px;
			margin: 0;
			line-height: 1;
		}

		.box-body {
			border-top-left-radius: 0;
			border-top-right-radius: 0;
			border-bottom-right-radius: 3px;
			border-bottom-left-radius: 3px;
			padding: 20px;
		}

		/* Form Controls */
		.form-control {
			border-radius: 0;
			box-shadow: none;
			border-color: #d2d6de;
		}

		.form-control:focus {
			border-color: #3c8dbc;
			box-shadow: none;
		}

		.control-label {
			font-weight: 600;
			text-align: left !important;
			padding-top: 7px;
		}

		/* Buttons */
		.btn {
			border-radius: 3px;
			box-shadow: none;
			border: 1px solid transparent;
		}

		.btn-app {
			color: #444;
			background-color: #f4f4f4;
			border-radius: 3px;
			margin: 0 5px 5px 0;
			padding: 12px 5px;
			height: 60px;
			min-width: 80px;
			border: 1px solid #ddd;
			text-align: center;
		}

		.btn-app:hover {
			background-color: #e7e7e7;
		}

		.btn-app>.fa {
			font-size: 20px;
			display: block;
		}

		/* Table Styling Overrides */
		#itemdetails table,
		#storgrid table {
			width: 100%;
			margin-bottom: 20px;
			border: 1px solid #f4f4f4;
			border-collapse: collapse;
			font-size: 13px;
		}

		#itemdetails table th,
		#itemdetails table td,
		#storgrid table th,
		#storgrid table td {
			padding: 8px;
			line-height: 1.42857143;
			vertical-align: top;
			border: 1px solid #ddd;
		}

		#itemdetails table tr:first-child td,
		#storgrid table tr:first-child td {
			background-color: #3c8dbc !important;
			color: white !important;
			font-weight: bold;
			border-bottom: 2px solid #3c8dbc;
		}

		/* Utility */
		.mt-10 {
			margin-top: 10px;
		}

		/* Legacy overrides */
		.hidden {
			display: none;
		}

		input[disabled],
		select[disabled],
		textarea[disabled] {
			cursor: not-allowed;
			background-color: #eee;
			opacity: 1;
		}
	</style>
</head>

<body class="hold-transition skin-blue layout-top-nav">

	<!-- Custom Navbar -->
	<div class="navbar-custom">
		<div class="navbar-brand">ERP SYSTEM MENU</div>

		<div class="page-title-box">
			Purchase Return
		</div>

		<div class="user-info">
			<span>Welcome, <span class="user-name"><?php echo $_SESSION['CURRENT_USER'] ?? 'User'; ?></span>
				[<?php echo $_SESSION['company'] ?? ''; ?>]</span>
			<a href="logout.php" class="logout-btn">Logout (Ctrl+Q)</a>
		</div>
	</div>

	<div class="content-wrapper">
		<section class="content">

			<!-- Action Toolbar -->
			<div class="box box-solid">
				<div class="box-body">
					<a onclick="new_inv();" class="btn btn-app">
						<i class="fa fa-plus"></i> New
					</a>
					<a onclick="save_inv();" class="btn btn-app">
						<i class="fa fa-save"></i> Save
					</a>
					<a onclick="cancel_inv();" class="btn btn-app">
						<i class="fa fa-ban"></i> Cancel
					</a>
					<a class="btn btn-app" href="purchase_ret.php">
						<i class="fa fa-refresh"></i> Refresh
					</a>
					<a onclick="close_form();" class="btn btn-app">
						<i class="fa fa-close"></i> Close
					</a>
				</div>
			</div>

			<div class="row">
				<!-- Details -->
				<div class="col-md-12">
					<div class="box box-primary">
						<div class="box-header with-border">
							<h3 class="box-title">Return Details</h3>
						</div>
						<div class="box-body">
							<form role="form" name="form1" id="form1" class="form-horizontal">

								<!-- Row 1: Ref No, Date, Dept -->
								<div class="form-group bg-info" style="padding: 10px 0; margin-bottom: 15px;">
									<label class="col-sm-1 control-label">Ref No</label>
									<div class="col-sm-3">
										<input type="text" class="form-control input-sm" name="refno" id="refno"
											value="New" disabled>
									</div>
									<label class="col-sm-1 control-label">Date</label>
									<div class="col-sm-3">
										<input type="date" class="form-control input-sm" name="date" id="date"
											value="<?php echo date("Y-m-d"); ?>">
									</div>
									<label class="col-sm-1 control-label">Dept</label>
									<div class="col-sm-3">
										<select name="department" id="department" class="form-control input-sm">
											<?php
											// Simple department list logic
											$sql = "select * from s_stomas where act='1' order by CODE";
											$result = $conn->query($sql);
											foreach ($result as $row) {
												$selected = ($_SESSION["CURRENT_DEP"] ?? '') == $row["CODE"] ? 'selected' : '';
												echo "<option value='" . $row["CODE"] . "' $selected>" . $row["CODE"] . " " . $row["DESCRIPTION"] . "</option>";
											}
											?>
										</select>
									</div>
								</div>

								<!-- Row 2: ARN Selection -->
								<div class="form-group">
									<label class="col-sm-1 control-label">ARN No</label>
									<div class="col-sm-3">
										<div class="input-group">
											<input type="text" class="form-control input-sm" name="arnno" id="arnno"
												disabled placeholder="Select ARN...">
											<span class="input-group-btn">
												<a class="btn btn-default btn-sm"
													onclick="search_arn(); return false;"><i
														class="fa fa-search"></i></a>
											</span>
										</div>
									</div>
									<label class="col-sm-1 control-label">Supplier</label>
									<div class="col-sm-2">
										<input type="text" class="form-control input-sm" name="supplier_code"
											id="supplier_code" disabled>
									</div>
									<div class="col-sm-4">
										<input type="text" class="form-control input-sm" name="supplier_name"
											id="supplier_name" disabled>
									</div>
								</div>

								<!-- Row 3: Remarks -->
								<div class="form-group">
									<label class="col-sm-1 control-label">Remarks</label>
									<div class="col-sm-11">
										<textarea name="remarks" id="remarks" class="form-control" rows="2"></textarea>
									</div>
								</div>

								<hr>
								<h4 class="box-title text-primary">Item Details</h4>

								<!-- Grid -->
								<div class="row mt-10">
									<div class="col-md-12">
										<div class="table-responsive" style="min-height: 200px; background: #fff;">
											<table class="table table-bordered table-striped">
												<thead>
													<tr>
														<th style="width: 15%">Item Code</th>
														<th style="width: 35%">Description</th>
														<th style="width: 10%; text-align:right;">Rec. Qty</th>
														<th style="width: 15%; text-align:right;">Price</th>
														<th style="width: 10%; text-align:right;">Ret. Qty</th>
														<th style="width: 15%; text-align:right;">Total</th>
													</tr>
												</thead>
												<tbody id="itemTableBody">
													<!-- Items loaded via JS -->
												</tbody>
											</table>
										</div>
									</div>
								</div>

								<!-- Totals -->
								<div class="row" style="margin-top:15px;">
									<div class="col-md-8"></div>
									<div class="col-md-4">
										<div class="form-group">
											<label class="col-sm-6 control-label" style="font-size: 16px;">Total
												Value</label>
											<div class="col-sm-6">
												<input type="text" class="form-control input-sm text-right"
													name="total_value" id="total_value" disabled value="0.00"
													style="font-size: 16px; font-weight:bold;">
											</div>
										</div>
									</div>
								</div>

							</form>
						</div><!-- /.box-body -->
					</div><!-- /.box -->
				</div><!-- /.col -->
			</div><!-- /.row -->

		</section>
	</div>

	<script>
		// Keyboard Shortcut for Logout (Ctrl+Q)
		document.addEventListener('keydown', function (event) {
			if (event.ctrlKey && (event.key === 'q' || event.key === 'Q')) {
				event.preventDefault();
				window.location.href = 'logout.php';
			}
		});
	</script>
</body>

</html>