<?php 
session_start();
require_once("connectioni.php");

if ($_SESSION['company'] == "") { 
    exit("Please Login");
}
if ($_SESSION['CURRENT_USER'] == "") { 
    exit("Please Login");
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Limit Exceed Form</title>
    <!-- Bootstrap 3.3.7 -->
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/css/bootstrap.min.css">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
    
    <!-- Scripts -->
    <script type="text/javascript" src="js/over_limit.js"></script>

    <script type="text/javascript">
    function close_form() {
        close();
    }
    
    // Window Popup Helper
    function NewWindow(mypage,myname,w,h,scroll,pos){
        if(pos=="random"){LeftPosition=(screen.width)?Math.floor(Math.random()*(screen.width-w)):100;TopPosition=(screen.height)?Math.floor(Math.random()*((screen.height-h)-75)):100;}
        if(pos=="center"){LeftPosition=(screen.width)?(screen.width-w)/2:100;TopPosition=(screen.height)?(screen.height-h)/2:100;}
        else if((pos!="center" && pos!="random") || pos==null){LeftPosition=0;TopPosition=20}
        settings='width='+w+',height='+h+',top='+TopPosition+',left='+LeftPosition+',scrollbars='+scroll+',location=no,directories=no,status=no,menubar=no,toolbar=no,resizable=no';
        win=window.open(mypage,myname,settings);
    }
    </script>

    <style>
        body {
            background-color: #ecf0f5;
            font-family: 'Source Sans Pro', 'Helvetica Neue', Helvetica, Arial, sans-serif;
            font-size: 14px;
        }
        
        /* Navbar Styles */
        .navbar-custom {
            background-color: #2c3e50;
            color: white;
            padding: 10px 20px;
            display: flex;
            justify-content: space-between;
            align-items: center;
            box-shadow: 0 2px 5px rgba(0,0,0,0.1);
            margin-bottom: 20px;
        }
        .navbar-brand {
            font-size: 24px;
            font-weight: bold;
            color: white !important;
            text-decoration: none;
            padding: 0;
            height: auto;
            line-height: normal;
        }
        .page-title-box {
            background: rgba(255, 255, 255, 0.1);
            border: 1px solid rgba(255, 255, 255, 0.2);
            padding: 8px 30px;
            border-radius: 5px;
            font-size: 18px;
            font-weight: 600;
            letter-spacing: 1px;
            text-transform: uppercase;
        }
        .user-info {
            display: flex;
            align-items: center;
            gap: 15px;
        }
        .logout-btn {
            background-color: #e74c3c;
            color: white;
            border: none;
            padding: 6px 15px;
            border-radius: 4px;
            font-weight: 600;
            transition: background 0.3s;
            text-decoration: none !important;
        }
        .logout-btn:hover {
            background-color: #c0392b;
            color: white;
        }
        .user-name {
            font-weight: bold;
        }

        /* Content Wrapper */
        .content-wrapper {
            padding: 20px;
        }
        
        /* Box/Card Styling */
        .box {
            background: #fff;
            border-top: 3px solid #d2d6de;
            margin-bottom: 20px;
            width: 100%;
            box-shadow: 0 1px 1px rgba(0,0,0,0.1);
            border-radius: 3px;
        }
        .box-primary { border-top-color: #3c8dbc; }
        .box-success { border-top-color: #00a65a; }
        .box-warning { border-top-color: #f39c12; }
        .box-danger  { border-top-color: #dd4b39; }
        
        .box-header {
            color: #444;
            display: block;
            padding: 10px;
            position: relative;
            border-bottom: 1px solid #f4f4f4;
            background-color: #f9fafc;
        }
        .box-header .box-title {
            display: inline-block;
            font-size: 18px;
            margin: 0;
            line-height: 1;
            font-weight: 600;
        }
        .box-body {
            border-top-left-radius: 0;
            border-top-right-radius: 0;
            border-bottom-right-radius: 3px;
            border-bottom-left-radius: 3px;
            padding: 20px;
        }

        /* Form Controls */
        .form-control {
            border-radius: 0;
            box-shadow: none;
            border-color: #d2d6de;
        }
        .form-control:focus {
            border-color: #3c8dbc;
            box-shadow: none;
        }
        .form-control[disabled], .form-control[readonly], fieldset[disabled] .form-control {
            background-color: #eee;
        }

        /* Buttons */
        .btn {
            border-radius: 3px;
            box-shadow: none;
            border: 1px solid transparent;
        }
        .btn-app {
            border-radius: 3px;
            position: relative;
            padding: 15px 5px;
            margin: 0 0 10px 10px;
            min-width: 80px;
            height: 60px;
            text-align: center;
            color: #666;
            border: 1px solid #ddd;
            background-color: #f4f4f4;
            font-size: 12px;
        }
        .btn-app > .fa, .btn-app > .glyphicon, .btn-app > .ion {
            font-size: 20px;
            display: block;
            margin-bottom: 10px;
        }
        .btn-app:hover {
            background: #f4f4f4;
            color: #444;
            border-color: #aaa;
        }
    </style>
</head>
<body class="hold-transition skin-blue layout-top-nav">

    <!-- Custom Navbar -->
    <div class="navbar-custom">
        <div class="navbar-brand">ERP SYSTEM MENU</div>
        
        <div class="page-title-box">
            Limit Exceed Form
        </div>
        
        <div class="user-info">
             <span>Welcome, <span class="user-name"><?php echo $_SESSION['user_name']; ?></span> [<?php echo $_SESSION['company']; ?>]</span>
            <a href="logout.php" class="logout-btn">Logout (Ctrl+Q)</a>
        </div>
    </div>

<div class="content-wrapper">
    <section class="content">

        <!-- Action Toolbar -->
        <div class="box box-solid">
            <div class="box-body">
                <a onclick="view_from();" class="btn btn-app">
                    <i class="fa fa-eye"></i> View
                </a>
                <a onclick="save_inv();" class="btn btn-app">
                    <i class="fa fa-save"></i> Save
                </a>
                <a onclick="close_form();" class="btn btn-app">
                    <i class="fa fa-close"></i> Close
                </a>
            </div>
        </div>

        <form role="form" name="form1" id="form1">
            <input type="hidden" name="txt_stat" id="txt_stat" />
            <input type="hidden" name="mcount" id="mcount" />
            <div id="wait_lbl"></div>

            <div class="row">
                <!-- Filter Info -->
                <div class="col-md-12">
                    <div class="box box-primary">
                        <div class="box-header with-border">
                            <h3 class="box-title">Filters</h3>
                        </div>
                        <div class="box-body">
                            <div class="row">
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label>Date</label>
                                        <input type="date" class="form-control" name="dtfrom" id="dtfrom" value="<?php echo date("Y-m-d"); ?>">
                                    </div>
                                </div>
                                <div class="col-md-4">
                                     <div class="form-group">
                                        <label>Rep</label>
                                        <select name="cmbrep" id="cmbrep" class="form-control" onkeypress="keyset('dte_dor', event);" onchange="setord();">
                                            <option value='All'>All</option>
                                            <?php
                                            require_once("connectioni.php");
                                            if ($_SESSION["MANAGER"]!="") { 			 						
                                                $sql="select * from s_salrep where cancel='1' and manager='".$_SESSION["MANAGER"]."'order by REPCODE"; 
                                                $result =mysqli_query($GLOBALS['dbinv'],$sql) ; 
                                                while($row = mysqli_fetch_array($result)){
                                                    echo "<option value='".$row["REPCODE"]."'>".$row["REPCODE"]." ".$row["Name"]."</option>";
                                                }
                                             }else if ($_SESSION["CURRENT_REP"]=="") { 			 						
                                                $sql="select * from s_salrep where cancel='1' order by REPCODE";
                                                $result =mysqli_query($GLOBALS['dbinv'],$sql) ; 
                                                while($row = mysqli_fetch_array($result)){
                                                    echo "<option value='".$row["REPCODE"]."'>".$row["REPCODE"]." ".$row["Name"]."</option>";
                                                }
                                             } else {
                                                 $sql="select * from s_salrep where cancel='1' and repcode = '" . $_SESSION["CURRENT_REP"] ."' order by REPCODE";
                                                 $result =mysqli_query($GLOBALS['dbinv'],$sql) ; 
                                                 while($row = mysqli_fetch_array($result)){
                                                 echo "<option value='".$row["REPCODE"]."'>".$row["REPCODE"]." ".$row["Name"]."</option>";
                                                 }
                                             }
                                            ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label>Type</label>
                                        <select name="cmbbrand" id="cmbbrand" class="form-control" onkeypress="keyset('searchitem', event);" onchange="setord();">
                                            <option value='All'>All</option>
                                            <?php
                                            $sql = "select class from brand_mas where act='1' group by class";
                                            $result = mysqli_query($GLOBALS['dbinv'],$sql) ; 
                                            while ($row = mysqli_fetch_array($result)) {
                                                echo "<option value='" . $row["class"] . "'>" . $row["class"] . "</option>";
                                            }
                                            ?>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Item Details Grid -->
            <div class="row">
                <div class="col-md-12">
                     <div class="box box-success">
                        <div class="box-header with-border">
                            <h3 class="box-title">Details</h3>
                        </div>
                         <div class="box-body">
                             <!-- Legacy JS injects table here -->
                             <div id="itemdetails" style="min-height: 300px; overflow: auto; border: 1px solid #ddd; padding: 10px;"></div>
                         </div>
                     </div>
                </div>
            </div>
            
             <div class="row">
                 <div class="col-md-12">
                      <div class="box box-default">
                          <div class="box-body">
                             <div id="storgrid"></div>
                             <input type="hidden" name="mcou" id="mcou" />
                          </div>
                      </div>
                 </div>
             </div>

        </form>

    </section>
</div>

<script>
    // Keyboard Shortcut for Logout (Ctrl+Q)
    document.addEventListener('keydown', function(event) {
        if (event.ctrlKey && (event.key === 'q' || event.key === 'Q')) {
            event.preventDefault();
            window.location.href = 'logout.php';
        }
    });
</script>
</body>
</html>