<?php
session_start();
require_once("connection_sql.php");
header('Content-Type: application/json');
date_default_timezone_set('Asia/Colombo');

$command = isset($_POST['Command']) ? $_POST['Command'] : (isset($_GET['Command']) ? $_GET['Command'] : '');

if ($command == "get_list") {
    try {
        $sql = "select * from dag_item WHERE flag='3' and cancel='0' ORDER BY id DESC";

        // Filter by company if needed (commented out in original, keeping logic available)
        // if(isset($_SESSION['company']) && $_SESSION['company'] != "" && $_SESSION['company'] != "ALL") {
        //     $sql = "select * from dag_item WHERE flag='3' and cancel='0' and company='".$_SESSION['company']."' ORDER BY id DESC";
        // }

        $result = $conn->query($sql);

        $data = [];
        $i = 1;

        foreach ($result as $row) {

            // History Count Logic
            $sql1 = "Select count(*) as count from dag_item  where cancel='0'  and  serialno='" . $row['serialno'] . "' group by  serialno asc";
            $result_1 = $conn->query($sql1);
            $row_1 = $result_1->fetch();
            $history_count = $row_1['count'] ?? 0;

            $data[] = [
                'id' => $row['id'],
                'jobno' => $row['jobno'],
                'refno' => $row['refno'],
                'sdate' => $row['sdate'],
                'customer' => $row['cuscode'] . '-' . $row['cusname'],
                'marker' => $row['marker'], // Make
                'size' => $row['size'],
                'belt' => $row['belt'],
                'serialno' => $row['serialno'],
                'cascost' => $row['cascost'],
                'remark' => $row['remark'],
                'ocompany' => $row['ocompany'],
                'onhand_date' => $row['onhand_date'],
                'history_count' => $history_count
            ];
            $i++;
        }

        echo json_encode(['status' => 'success', 'data' => $data]);

    } catch (Exception $e) {
        echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
    }
    exit;
}

if ($command == "sendinvoice") {
    try {
        $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        $conn->beginTransaction();

        $id = $_POST['id'] ?? '';
        $cost = $_POST['cost'] ?? '';
        $selling = $_POST['selling'] ?? '';
        $newjobno = $_POST['newjobno'] ?? '';
        $remark = $_POST['remark'] ?? '';
        $warrenty = $_POST['warrenty'] ?? '';
        $belt = $_POST['belt'] ?? '';

        if ($cost == "") {
            echo json_encode(['status' => 'error', 'message' => 'Enter Cost']);
            exit;
        }
        if ($selling == "") {
            echo json_encode(['status' => 'error', 'message' => 'Enter Selling']);
            exit;
        }
        if ($newjobno == "") {
            echo json_encode(['status' => 'error', 'message' => 'Enter New Job No']);
            exit;
        }
        if ($remark == "") {
            echo json_encode(['status' => 'error', 'message' => 'Enter Remark']);
            exit;
        }
        if ($warrenty == "") {
            echo json_encode(['status' => 'error', 'message' => 'Enter Warrenty']);
            exit;
        }
        if ($belt == "") {
            echo json_encode(['status' => 'error', 'message' => 'Enter Belt']);
            exit;
        }

        $sql = "Select * from dag_item  where id='" . $id . "'";
        $result = $conn->query($sql);
        if ($rowM = $result->fetch()) {

            $sql_invpara = "SELECT * FROM invpara where flag='" . $rowM['department'] . "'";
            $result_invpara = $conn->query($sql_invpara);
            $row_invpara = $result_invpara->fetch();
            $vatrate = $row_invpara["vatrate"];

            // Update dag_item
            // Note: Original code appended remark: $rowM['remark']." -".$remark
            // And updated total=total+selling, cost=cost+cost.
            // FLAG 5 = INVOICED
            $sql = "UPDATE dag_item set warrenty='" . $warrenty . "', belt='" . $belt . "', remark='" . $rowM['remark'] . " - " . $remark . "', flag='5', jobno='" . $newjobno . "', total=total+" . $selling . ", cost=cost+" . $cost . ", com_date='" . date("Y-m-d") . "' where id='" . $id . "'";
            $conn->query($sql);

            // Insert into c_bal (Ledger)
            // trn_type = ARN ? (Preserved from original code)
            $sql1 = "insert into c_bal(REFNO, SDATE, CUSCODE, AMOUNT, BALANCE, Cancell, trn_type, vatrate, totpay, tmp_no, company) values 
            ('" . $rowM['jobno'] . "', '" . date("Y-m-d") . "', '" . $rowM["cuscode"] . "', '" . $cost . "', '" . $cost . "', '0', 'ARN', '" . $vatrate . "', 0, '', '" . $rowM['department'] . "')";
            $conn->exec($sql1);

            $sqllog = "insert into entry_log(refno, username, docname, trnType, stime, sdate) values
            ('" . $rowM['jobno'] . "', '" . $_SESSION["CURRENT_USER"] . "', 'SEND OTHER TO INVOICE', 'Save', '" . date("Y-m-d H:i:s") . "', '" . date("Y-m-d") . "')";
            $conn->query($sqllog);

            $conn->commit();
            echo json_encode(['status' => 'success', 'message' => 'SEND INVOICE']);
        } else {
            echo json_encode(['status' => 'error', 'message' => 'Item not found']);
        }

    } catch (Exception $e) {
        $conn->rollBack();
        echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
    }
    exit;
}

// Fallback
echo json_encode(['status' => 'error', 'message' => 'Invalid Command']);
?>