var returnChequeList = [];
var newPaymentList = [];

document.addEventListener("DOMContentLoaded", function () {
    loadInitialData();
});

function loadInitialData() {
    fetch('ret_chq_settle_data.php?Command=get_initial_data')
        .then(response => response.json())
        .then(data => {
            if (data.status === 'success') {
                const salesRepSelect = document.getElementById('salesrep');
                data.data.reps.forEach(rep => {
                    let option = new Option(rep.code + " " + rep.name, rep.code);
                    salesRepSelect.add(option);
                });

                const costCenterSelect = document.getElementById('costcenter');
                data.data.costcenters.forEach(cc => {
                    let option = new Option(cc.code + " " + cc.name, cc.code);
                    costCenterSelect.add(option);
                });

                const accSelect = document.getElementById('account');
                data.data.accounts.forEach(acc => {
                    let option = new Option(acc.code + " " + acc.name, acc.code);
                    accSelect.add(option);
                });
            }
        });
}

function new_inv() {
    fetch('ret_chq_settle_data.php?Command=new_rec')
        .then(response => response.json())
        .then(data => {
            if (data.status === 'success') {
                document.getElementById('invno').value = data.recno;
                document.getElementById('invdate').value = data.date;

                // Reset State
                returnChequeList = [];
                newPaymentList = [];
                document.getElementById('cuscode').value = '';
                document.getElementById('cusname').value = '';
                document.getElementById('chq_table_body').innerHTML = '';
                document.getElementById('payment_list_body').innerHTML = '';
                updateTotals();

                document.getElementById('chqno').value = '';
                document.getElementById('chqdate').value = '';
                document.getElementById('bank').value = '';
                document.getElementById('chqamt').value = '';
                document.getElementById('cashamt').value = '';

            }
        });
}

function custno(code) {
    document.getElementById('cuscode').value = code;
    // Potentially fetch name/address too if needed
    // Fetch Returned Cheques

    fetch(`ret_chq_settle_data.php?Command=get_returned_cheques&cuscode=${code}`)
        .then(response => response.json())
        .then(data => {
            if (data.status === 'success') {
                returnChequeList = data.cheques;
                renderReturnedCheques();
            } else {
                alert(data.message);
            }
        });
}

function renderReturnedCheques() {
    const tbody = document.getElementById('chq_table_body');
    tbody.innerHTML = '';

    returnChequeList.forEach((item, index) => {
        const row = tbody.insertRow();
        row.innerHTML = `
            <td>${item.refno}</td>
            <td>${item.cheque_no}</td>
            <td>${item.date}</td>
            <td class="text-right">${parseFloat(item.amount).toFixed(2)}</td>
            <td class="text-right">${parseFloat(item.balance).toFixed(2)}</td>
            <td><input type="number" class="form-control input-sm text-right" 
                value="${item.settle_amount || 0}" 
                onchange="updateSettleAmount(${index}, this.value)"></td>
        `;
    });
    updateTotals();
}

function updateSettleAmount(index, amount) {
    // Validate
    let val = parseFloat(amount) || 0;
    if (val > parseFloat(returnChequeList[index].balance)) {
        alert("Settle amount cannot exceed balance");
        val = 0;
    }
    returnChequeList[index].settle_amount = val;
    renderReturnedCheques();
}


function add_payment_cheque() {
    const chqno = document.getElementById('chqno').value;
    const date = document.getElementById('chqdate').value;
    const bank = document.getElementById('bank').value;
    const amt = parseFloat(document.getElementById('chqamt').value) || 0;

    if (!chqno || !amt) {
        alert("Please enter Cheque No and Amount");
        return;
    }

    newPaymentList.push({
        type: 'Cheque',
        no: chqno,
        date: date,
        bank: bank,
        amount: amt
    });

    renderPaymentList();

    document.getElementById('chqno').value = '';
    document.getElementById('chqamt').value = '';
    document.getElementById('bank').value = '';
}

function renderPaymentList() {
    const tbody = document.getElementById('payment_list_body');
    tbody.innerHTML = '';

    newPaymentList.forEach((item, index) => {
        const row = tbody.insertRow();
        row.innerHTML = `
            <td>${item.type}</td>
            <td>${item.no || '-'}</td>
             <td>${item.date || '-'}</td>
             <td class="text-right">${item.amount.toFixed(2)}</td>
             <td><button onclick="removePayment(${index})" class="btn btn-xs btn-danger"><i class="fa fa-trash"></i></button></td>
         `;
    });
    updateTotals();
}

function removePayment(index) {
    newPaymentList.splice(index, 1);
    renderPaymentList();
}

function updateTotals() {
    // Calculate Total Settle Amount
    let totalSettle = 0;
    returnChequeList.forEach(item => {
        totalSettle += (parseFloat(item.settle_amount) || 0);
    });
    document.getElementById('txttotalsettle').value = totalSettle.toFixed(2);

    // Calculate Total Payments
    let totalPay = 0;

    // Cash
    const cash = parseFloat(document.getElementById('cashamt').value) || 0;
    totalPay += cash;

    // Cheques
    newPaymentList.forEach(item => {
        totalPay += item.amount;
    });

    document.getElementById('txttotalpay').value = totalPay.toFixed(2);

    const diff = totalPay - totalSettle;
    document.getElementById('txtoverunder').value = diff.toFixed(2);
}

function save_crec() {
    const recno = document.getElementById('invno').value;
    const cuscode = document.getElementById('cuscode').value;

    if (!recno || !cuscode) {
        alert("Missing Data");
        return;
    }

    const payload = {
        recno: recno,
        date: document.getElementById('invdate').value,
        cuscode: cuscode,
        payType: document.getElementById('paytype').value,
        amount: parseFloat(document.getElementById('txttotalsettle').value) || 0,
        cashTotal: parseFloat(document.getElementById('cashamt').value) || 0,
        allocations: returnChequeList.filter(i => (i.settle_amount || 0) > 0),
        newPayments: newPaymentList
    };

    fetch('ret_chq_settle_data.php?Command=save_settlement', {
        method: 'POST',
        headers: { 'Content-Type': 'application/json' },
        body: JSON.stringify(payload)
    })
        .then(res => res.json())
        .then(data => {
            if (data.status === 'success') {
                alert("Saved Successfully");
                new_inv();
            } else {
                alert("Error: " + data.message);
            }
        });
}


// Search Popup Support
function NewWindow(mypage, myname, w, h, scroll) {
    var winl = (screen.width - w) / 2;
    var wint = (screen.height - h) / 2;
    winprops = 'height=' + h + ',width=' + w + ',top=' + wint + ',left=' + winl + ',scrollbars=' + scroll + ',resizable'
    win = window.open(mypage, myname, winprops)
    if (parseInt(navigator.appVersion) >= 4) { win.window.focus(); }
}