
// Reject List Controller

$(document).ready(function () {
    load_list();
});

function load_list() {
    if ($.fn.DataTable.isDataTable('#example')) {
        $('#example').DataTable().destroy();
    }

    $('#example').DataTable({
        "ajax": {
            "url": "reject_list_data.php?Command=get_list",
            "type": "GET"
        },
        "columns": [
            {
                "data": null, "render": function (data, type, row, meta) {
                    return meta.row + 1;
                }
            },
            {
                "data": "jobno", "render": function (data, type, row) {
                    return `<span style="background-color:#ffeb00; display:block; padding:5px;">${data}</span>`;
                }
            },
            { "data": "refno" },
            { "data": "sdate" },
            { "data": "cusname" },
            { "data": "marker" },
            { "data": "size" },
            { "data": "serialno" },
            { "data": "amount" },
            { "data": "repair" },
            { "data": "total" },
            { "data": "onhand_date" },
            { "data": "pro_date" },
            { "data": "remark" },
            {
                "data": null, "render": function (data, type, row) {
                    return `<button class="btn btn-warning btn-xs revert-btn" onclick="revert_production('${row.refno}', '${row.serialno}')"><i class="fa fa-undo"></i> REVERT TO PROD</button>`;
                }
            }
        ],
        "dom": 'Bfrtip',
        "buttons": [
            'pageLength',
            {
                extend: 'print',
                title: 'REJECT LIST'
            }
        ],
        "pageLength": 10,
        "responsive": true
    });
}

function revert_production(refno, serialno) {
    if (!confirm("Are you sure you want to revert this item back to PRODUCTION?")) return;

    let params = new URLSearchParams();
    params.append('Command', 'revert_production');
    params.append('refno', refno);
    params.append('serialno', serialno);

    fetch('reject_list_data.php', {
        method: 'POST',
        body: params
    })
        .then(response => response.json())
        .then(data => {
            if (data.status === 'success') {
                alert(data.message);
                load_list();
            } else {
                alert(data.message);
            }
        })
        .catch(error => {
            console.error('Error:', error);
            alert('An error occurred');
        });
}
