
// Purchase Return Module JavaScript

function new_inv() {
    document.getElementById('form1').reset();
    document.getElementById('refno').value = "New";
    document.getElementById('itemTableBody').innerHTML = "";
    document.getElementById('total_value').value = "0.00";
    document.getElementById('msg_box').innerHTML = "";
    // Set default date
    document.getElementById('date').valueAsDate = new Date();
}

function search_arn() {
    // Open Search Modal (using existing PHP search or new one? Using existing serach_arn for now)
    // The existing serach_arn.php uses query stname=arn. 
    // We'll create a new window or use a modal.
    // For modernization, let's try to reuse the existing window popups but catch the value efficiently.
    // OR better, we implement a simple search modal inside the page if possible.
    // Given the constraints, I will stick to the existing window.open pattern but ensure it calls back correctly.

    // However, the user wants "Modern UI". The existing `js/arn_pur_ret.js` pattern relied on `opener.document...`.
    // I will try to support `arnno` function if it's called from the popup.

    let url = "serach_arn_pur_ret.php?stname=pur_ret_new";
    window.open(url, "mywin", "width=800, height=700");
}

// Callback function called by serach_arn.php (if we modify it or if it tries to call arnno)
// If the legacy search file expects 'arnno' function, we provide it.
function arnno(code, stname) {
    // This is called by the popup
    get_arn_details(code);
}

// Fetch ARN Details from Backend
async function get_arn_details(arnNo) {
    try {
        let response = await fetch(`purchase_ret_data.php?Command=get_arn&arnno=${arnNo}`);
        let data = await response.json();

        if (data.status === 'success') {
            let h = data.header;
            document.getElementById('arnno').value = h.REFNO;
            document.getElementById('supplier_code').value = h.SUP_CODE;
            document.getElementById('supplier_name').value = h.SUP_NAME;
            document.getElementById('department').value = h.DEPARTMENT || '';

            // Populate Table
            let tbody = document.getElementById('itemTableBody');
            tbody.innerHTML = "";

            data.items.forEach((item, index) => {
                let row = tbody.insertRow();

                // Calculate max returnable (REC_QTY - whatever previously returned?)
                // For simplicity assuming REC_QTY is what's available from that ARN
                let qty = parseFloat(item.REC_QTY);

                row.innerHTML = `
                    <td>${item.STK_NO}</td>
                    <td>${item.DESCRIPT}</td>
                    <td class="text-right">${qty}</td>
                    <td class="text-right">${parseFloat(item.PRICE).toFixed(2)}</td>
                    <td>
                        <input type="number" class="form-control input-sm text-right qty-input" 
                            data-price="${item.PRICE}" 
                            data-code="${item.STK_NO}"
                            data-desc="${item.DESCRIPT}"
                            data-cost="${item.COST}"
                            max="${qty}" min="0" value="0" oninput="calculate_totals()">
                    </td>
                    <td class="text-right row-total">0.00</td>
                `;
            });

            calculate_totals();
        } else {
            alert(data.message);
        }
    } catch (error) {
        console.error('Error:', error);
        alert('Failed to fetch ARN details');
    }
}

function calculate_totals() {
    let total = 0;
    let rows = document.querySelectorAll('#itemTableBody tr');

    rows.forEach(row => {
        let input = row.querySelector('.qty-input');
        let price = parseFloat(input.dataset.price);
        let qty = parseFloat(input.value) || 0;
        let pqty = parseFloat(input.getAttribute('max'));

        if (qty > pqty) {
            alert("Return quantity cannot exceed received quantity!");
            input.value = 0;
            qty = 0;
        }

        let rowVal = price * qty;
        row.querySelector('.row-total').textContent = rowVal.toFixed(2);
        total += rowVal;
    });

    document.getElementById('total_value').value = total.toFixed(2);
}

async function save_inv() {
    if (!confirm("Are you sure you want to save this return?")) return;

    let items = [];
    let rows = document.querySelectorAll('#itemTableBody tr');

    rows.forEach(row => {
        let input = row.querySelector('.qty-input');
        let qty = parseFloat(input.value) || 0;
        if (qty > 0) {
            items.push({
                code: input.dataset.code,
                description: input.dataset.desc,
                price: parseFloat(input.dataset.price),
                cost: parseFloat(input.dataset.cost),
                return_qty: qty
            });
        }
    });

    if (items.length === 0) {
        alert("Please enter at least one return quantity.");
        return;
    }

    let formData = new FormData();
    formData.append('Command', 'save_return');
    formData.append('refno', document.getElementById('refno').value);
    formData.append('arnno', document.getElementById('arnno').value);
    formData.append('date', document.getElementById('date').value);
    formData.append('department', document.getElementById('department').value);
    formData.append('supplier_code', document.getElementById('supplier_code').value);
    formData.append('supplier_name', document.getElementById('supplier_name').value);
    formData.append('remarks', document.getElementById('remarks').value);
    formData.append('total_value', document.getElementById('total_value').value);
    formData.append('items', JSON.stringify(items));

    try {
        let response = await fetch('purchase_ret_data.php?Command=save_return', {
            method: 'POST',
            body: formData
        });

        let data = await response.json();

        if (data.status === 'success') {
            alert(data.message);
            new_inv();
        } else {
            alert("Error: " + data.message);
        }
    } catch (error) {
        console.error('Error:', error);
        alert('Failed to save return');
    }
}

function cancel_inv() {
    alert("Cancel functionality not yet implemented in backend.");
}

function close_form() {
    window.location.href = "index.php"; // Or window.close()
}

// Initialize on load
window.onload = function () {
    new_inv();
};
