
// Other Send List Controller

$(document).ready(function () {
    load_list();
});

function load_list() {
    if ($.fn.DataTable.isDataTable('#example')) {
        $('#example').DataTable().destroy();
    }

    $('#example').DataTable({
        "ajax": {
            "url": "othersendlist_data.php?Command=get_list",
            "type": "GET"
        },
        "columns": [
            {
                "data": null, "render": function (data, type, row, meta) {
                    return meta.row + 1;
                }
            },
            {
                "data": "jobno", "render": function (data, type, row) {
                    return `<span style="background-color:#ffeb00; display:block; padding:5px;">${data}</span>`;
                }
            },
            { "data": "refno" },
            { "data": "sdate" },
            { "data": "customer" },
            { "data": "marker" },
            { "data": "size" },
            { "data": "belt" },
            { "data": "serialno" },
            { "data": "cascost" },
            { "data": "remark" },
            { "data": "ocompany" },
            { "data": "onhand_date" },
            {
                "data": "history_count", "render": function (data, type, row) {
                    return `<span style="background-color:red; color:white; display:block; padding:5px;">${data}</span>`;
                }
            },
            {
                "data": "id", "render": function (data, type, row) {
                    return `<button onclick="open_invoice_modal('${data}', '${row.jobno}', '${row.belt}', '${row.remark}')" class="btn btn-primary btn-xs"><i class="fa fa-mail-forward"></i> SEND TO INVOICE</button>`;
                }
            }
        ],
        "dom": 'Bfrtip',
        "buttons": [
            'pageLength',
            {
                extend: 'print',
                title: 'OTHER COMPANY SEND LIST'
            }
        ],
        "pageLength": 10,
        "responsive": true
    });
}

// Modal handling
function open_invoice_modal(id, currentJobNo, currentBelt, currentRemark) {
    // Clear previous values
    $('#inv_id').val(id);
    $('#inv_newjobno').val('');
    $('#inv_belt').val(currentBelt); // Pre-fill if useful
    $('#inv_cost').val('');
    $('#inv_selling').val('');
    $('#inv_remark').val('');
    $('#inv_warrenty').val('');

    // Show modal
    $('#invoiceModal').modal('show');
}

function save_invoice() {
    let id = $('#inv_id').val();
    let newjobno = $('#inv_newjobno').val();
    let belt = $('#inv_belt').val();
    let cost = $('#inv_cost').val();
    let selling = $('#inv_selling').val();
    let remark = $('#inv_remark').val();
    let warrenty = $('#inv_warrenty').val();

    // Validation
    if (newjobno === "") { alert("Enter New Job No"); return; }
    if (belt === "") { alert("Enter Belt"); return; }
    if (cost === "") { alert("Enter Cost Price"); return; }
    if (selling === "") { alert("Enter Selling Price"); return; }
    if (remark === "") { alert("Enter Remark"); return; }
    if (warrenty === "") { alert("Enter Warranty"); return; }

    // Send Data
    let params = new URLSearchParams();
    params.append('Command', 'sendinvoice');
    params.append('id', id);
    params.append('newjobno', newjobno);
    params.append('belt', belt);
    params.append('cost', cost);
    params.append('selling', selling);
    params.append('remark', remark);
    params.append('warrenty', warrenty);

    fetch('othersendlist_data.php', {
        method: 'POST',
        body: params
    })
        .then(response => response.json())
        .then(data => {
            if (data.status === 'success') {
                $('#invoiceModal').modal('hide');
                alert(data.message);
                load_list();
            } else {
                alert(data.message);
            }
        })
        .catch(error => {
            console.error('Error:', error);
            alert('An error occurred');
        });
}
