
// Other Receive List Controller

$(document).ready(function () {
    load_list();
});

function load_list() {
    if ($.fn.DataTable.isDataTable('#example')) {
        $('#example').DataTable().destroy();
    }

    $('#example').DataTable({
        "ajax": {
            "url": "otherreclist_data.php?Command=get_list",
            "type": "GET"
        },
        "columns": [
            {
                "data": null, "render": function (data, type, row, meta) {
                    return meta.row + 1;
                }
            },
            {
                "data": "jobno", "render": function (data, type, row) {
                    return `<span style="background-color:#ffeb00; display:block; padding:5px;">${data}</span>`;
                }
            },
            { "data": "refno" },
            { "data": "sdate" },
            { "data": "customer" },
            { "data": "marker" },
            { "data": "size" },
            { "data": "belt" },
            { "data": "serialno" },
            { "data": "cascost" },
            { "data": "cost" },
            { "data": "total" },
            { "data": "remark" },
            { "data": "ocompany" },
            { "data": "onhand_date" },
            { "data": "com_date" },
            {
                "data": "history_count", "render": function (data, type, row) {
                    return `<span style="background-color:red; color:white; display:block; padding:5px;">${data}</span>`;
                }
            },
            {
                "data": null, "render": function (data, type, row) {
                    return `<button onclick="sendreject('${row.refno}', '${row.serialno}')" class="btn btn-primary btn-xs"><i class="fa fa-save"></i> SEND TO REJECT</button>`;
                }
            },
            {
                "data": null, "render": function (data, type, row) {
                    return `<span style="background-color:${row.status_bg}; display:block; padding:5px;">${row.status_html}</span>`;
                }
            }
        ],
        "dom": 'Bfrtip',
        "buttons": [
            'pageLength',
            {
                extend: 'print',
                title: 'OTHER COMPANY RECEIVED LIST'
            }
        ],
        "pageLength": 10,
        "responsive": true
    });
}

function sendreject(refno, serialno) {
    if (!confirm("Do you want to send this to REJECT?")) return;

    let params = new URLSearchParams();
    params.append('Command', 'sendreject');
    params.append('refno', refno);
    params.append('serialno', serialno);

    fetch('otherreclist_data.php', {
        method: 'POST',
        body: params
    })
        .then(response => response.json())
        .then(data => {
            if (data.status === 'success') {
                alert(data.message);
                load_list();
            } else {
                alert(data.message);
            }
        })
        .catch(error => {
            console.error('Error:', error);
            alert('An error occurred');
        });
}
