
// OnHand List Controller

$(document).ready(function () {
    load_list();

    // Refresh interval if needed, or just manual reload
});

function load_list() {
    // Destroy if exists
    if ($.fn.DataTable.isDataTable('#example')) {
        $('#example').DataTable().destroy();
    }

    $('#example').DataTable({
        "ajax": {
            "url": "onhandlist_data.php?Command=get_list",
            "type": "GET"
        },
        "columns": [
            {
                "data": null, "render": function (data, type, row, meta) {
                    return meta.row + 1;
                }
            },
            {
                "data": "jobno", "render": function (data, type, row) {
                    return `<span style="background-color:#ffeb00; display:block; padding:5px;">${data}</span>`;
                }
            },
            { "data": "refno" },
            { "data": "sdate" },
            { "data": "customer" },
            { "data": "marker" },
            { "data": "size" },
            { "data": "belt" },
            { "data": "serialno" },
            { "data": "cascost" },
            { "data": "remark" },
            {
                "data": "history_count", "render": function (data, type, row) {
                    return `<span style="background-color:red; color:white; display:block; padding:5px;">${data}</span>`;
                }
            },
            {
                "data": "id", "render": function (data, type, row) {
                    return `<button onclick="sendother('${data}')" class="btn btn-primary btn-xs"><i class="fa fa-mail-forward"></i> SEND OTHER COMPANY</button>`;
                }
            },
            {
                "data": "id", "render": function (data, type, row) {
                    return `<button onclick="sendakeesha('${data}')" class="btn btn-primary btn-xs"><i class="fa fa-mail-forward"></i> SEND</button>`;
                }
            },
            {
                "data": "id", "render": function (data, type, row) {
                    return `<button onclick="sendinvoice('${data}')" class="btn btn-primary btn-xs"><i class="fa fa-mail-forward"></i> SEND TO INVOICE</button>`;
                }
            }
        ],
        "dom": 'Bfrtip',
        "buttons": [
            'pageLength',
            {
                extend: 'print',
                title: 'ONHAND LIST'
            }
        ],
        "pageLength": 10,
        "responsive": true
    });
}

function sendother(id) {
    if (!confirm("Do you want to Continue this?")) return;

    let ocompany = prompt("Please Enter Company Name", "");
    if (ocompany == null || ocompany.trim() == "") {
        alert("Enter Company");
        return;
    }

    perform_action('sendother', id, ocompany);
}

function sendakeesha(id) {
    if (!confirm("Do you want to Continue this?")) return;
    perform_action('sendother', id, "AKEESHA");
}

function sendinvoice(id) {
    if (!confirm("Do you want to Continue this?")) return;
    perform_action('sendinvoice', id);
}

async function perform_action(command, id, ocompany = "") {
    let params = new URLSearchParams();
    params.append('Command', command);
    params.append('id', id);
    if (ocompany !== "") params.append('ocompany', ocompany);

    try {
        let response = await fetch('onhandlist_data.php', {
            method: 'POST',
            body: params
        });
        let data = await response.json();

        if (data.status === 'success') {
            alert(data.message);
            load_list(); // Refresh table
        } else {
            alert(data.message);
        }
    } catch (error) {
        console.error("Error:", error);
        alert("An error occurred");
    }
}
