
// DAG Transfer Controller

let transferList = [];

$(document).ready(function () {
    // Set default date
    document.getElementById('sdate').valueAsDate = new Date();

    // Load Departments
    loadDepartments();

    // Item Search Enter Key
    $('#search_input').on('keypress', function (e) {
        if (e.which == 13) {
            searchItems();
        }
    });
});

function loadDepartments() {
    fetch('dag_transfer_data.php?Command=get_departments')
        .then(response => response.json())
        .then(data => {
            if (data.status === 'success') {
                let options = ""; // "<option value=''>Select Department</option>";
                data.data.forEach(dep => {
                    options += `<option value="${dep.code}">${dep.description}</option>`;
                });
                $('#from_dep').html(options);
                $('#to_dep').html(options);

                // Set defaults if needed or leave as first item
            }
        });
}

function searchItemByCode() {
    let jobno = $('#jobno_input').val();
    if (jobno === '') return;

    // Direct fetch details if full code known (simulated) or open search
    // For now, let's open search modal or direct fetch
    // Implementing direct fetch for UX if user types jobno and tabs

    fetch(`dag_transfer_data.php?Command=get_item_details&jobno=${jobno}`)
        .then(response => response.json())
        .then(data => {
            if (data.status === 'success') {
                selectItem(data.data);
            } else {
                // Not found, maybe open search?
                alert('Item not found. Please use search.');
            }
        });
}

// Global Item Select (from Modal or Direct)
function selectItem(item) {
    if (transferList.some(i => i.jobno === item.jobno && i.serialno === item.serialno)) {
        alert('Item already added to list.');
        return;
    }

    transferList.push(item);
    renderTable();

    // Clear Input
    $('#jobno_input').val('');
}

function removeItem(index) {
    transferList.splice(index, 1);
    renderTable();
}

function renderTable() {
    let tbody = $('#item_table_body');
    tbody.empty();

    transferList.forEach((item, index) => {
        let row = `
            <tr>
                <td>${index + 1}</td>
                <td>${item.jobno}</td>
                <td>${item.refno}</td>
                <td>${item.serialno}</td>
                <td>${item.marker}</td> <!-- Make -->
                <td>${item.size}</td>
                <td>${item.cascost}</td>
                <td>1</td> <!-- Qty always 1 for unique items -->
                <td>
                    <button class="btn btn-danger btn-xs" onclick="removeItem(${index})"><i class="fa fa-trash"></i></button>
                </td>
            </tr>
        `;
        tbody.append(row);
    });

    $('#total_items').text(transferList.length);
}

function saveTransfer() {
    if (transferList.length === 0) {
        alert("No items to transfer.");
        return;
    }

    let from_dep = $('#from_dep').val();
    let to_dep = $('#to_dep').val();
    let sdate = $('#sdate').val();

    if (from_dep === to_dep) {
        alert("From and To Departments cannot be the same.");
        return;
    }

    if (!confirm("Process Transfer?")) return;

    let payload = {
        sdate: sdate,
        from_dep: from_dep,
        to_dep: to_dep,
        items: transferList
    };

    fetch('dag_transfer_data.php?Command=save_transfer', {
        method: 'POST',
        headers: { 'Content-Type': 'application/json' },
        body: JSON.stringify(payload)
    })
        .then(response => response.json())
        .then(data => {
            if (data.status === 'success') {
                alert(data.message + "\nRef No: " + data.ref_no);
                // Reset
                transferList = [];
                renderTable();
                // Optional: Print Logic
                // window.open('dag_transfer_print.php?ref=' + data.ref_no);
            } else {
                alert("Error: " + data.message);
            }
        })
        .catch(error => {
            console.error('Error:', error);
            alert('An error occurred');
        });
}

function cancelTransfer() {
    if (confirm("Clear current list?")) {
        transferList = [];
        renderTable();
    }
}

// Modal Search Logic
function openSearchModal() {
    $('#searchModal').modal('show');
    $('#search_results').empty();
    $('#search_input').val('');
}

function searchItems() {
    let query = $('#search_input').val();
    let from_dep = $('#from_dep').val();

    fetch(`dag_transfer_data.php?Command=search_items&query=${query}&from_dep=${from_dep}`)
        .then(response => response.json())
        .then(data => {
            if (data.status === 'success') {
                let html = "";
                data.data.forEach(item => {
                    // Pass item as JSON string to button
                    let itemStr = JSON.stringify(item).replace(/"/g, '&quot;');
                    html += `
                    <tr>
                        <td>${item.jobno}</td>
                        <td>${item.serialno}</td>
                        <td>${item.marker}</td>
                        <td><button class="btn btn-success btn-xs" onclick="selectItemFromSearch(${itemStr})">Select</button></td>
                    </tr>
                `;
                });
                $('#search_results').html(html);
            }
        });
}

function selectItemFromSearch(item) {
    selectItem(item);
    $('#searchModal').modal('hide');
}
