
// Complete List Controller

$(document).ready(function () {
    load_list();
});

function load_list() {
    if ($.fn.DataTable.isDataTable('#example')) {
        $('#example').DataTable().destroy();
    }

    $('#example').DataTable({
        "ajax": {
            "url": "comp_list_data.php?Command=get_list",
            "type": "GET"
        },
        "columns": [
            {
                "data": null, "render": function (data, type, row, meta) {
                    return meta.row + 1;
                }
            },
            {
                "data": "jobno", "render": function (data, type, row) {
                    return `<span style="background-color:#ffeb00; display:block; padding:5px;">${data}</span>`;
                }
            },
            { "data": "refno" },
            { "data": "sdate" },
            { "data": "cusname" },
            { "data": "belt" },
            { "data": "marker" },
            { "data": "size" },
            { "data": "serialno" },
            { "data": "warrenty" },
            { "data": "adpayment" },
            { "data": "cascost" },
            { "data": "cost", "visible": false }, // Logic for Admin check can be added if needed via class/server
            { "data": "amount" },
            { "data": "repair" },
            {
                "data": "total", "render": function (data) {
                    return `<span style="background-color:#f39c12; display:block; padding:5px;">${data}</span>`;
                }
            },
            { "data": "pro_date" },
            { "data": "remark" },
            {
                "data": "history_count", "render": function (data, type, row) {
                    return `<span style="background-color:red; color:white; display:block; padding:5px;">${data}</span>`;
                }
            },
            {
                "data": null, "render": function (data, type, row) {
                    // Pass all needed data to modal function as base64 or stored object to avoid quote issues
                    // Simplified: passing ID and key fields. We can fetch details or just use row data if we store it.
                    // For simplicity, I'll pass fields individually properly escaped, or better yet, attach event listener in drawCallback
                    return `<button class="btn btn-primary btn-xs view-btn" data-id="${row.id}"><i class="fa fa-fullscreen"></i> VIEW</button>`;
                }
            }
        ],
        "fnDrawCallback": function (oSettings) {
            // Attach event listeners to buttons
            $('.view-btn').off('click').on('click', function () {
                var tr = $(this).closest('tr');
                var row = $('#example').DataTable().row(tr);
                open_details_modal(row.data());
            });
        },
        "dom": 'Bfrtip',
        "buttons": [
            'pageLength',
            {
                extend: 'print',
                title: 'COMPLETE LIST'
            }
        ],
        "pageLength": 10,
        "responsive": true
    });
}

function open_details_modal(data) {
    // Populate Modal Fields
    $('#id').val(data.id);
    $('#jobno').val(data.jobno);
    $('#refno').val(data.refno);
    $('#regdate').val(data.sdate);
    $('#cusname').val(data.cusname);
    // $('#design').val(data.design);
    $('#make').val(data.marker);
    $('#size').val(data.size);
    $('#serialno').val(data.serialno);
    $('#adpay').val(data.adpayment);
    $('#totalamou').val(data.total);
    $('#prodate').val(data.pro_date);
    $('#warrenty').val(data.warrenty);

    // Store ref/serial for actions
    $('#current_refno').val(data.refno);
    $('#current_serialno').val(data.serialno);

    $('#exampleModal').modal('show');
}

function sendproduction() {
    let refno = $('#current_refno').val();
    let serialno = $('#current_serialno').val();

    if (!confirm("Send to PRODUCTION?")) return;

    let params = new URLSearchParams();
    params.append('Command', 'sendproduction');
    params.append('refno', refno);
    params.append('serialno', serialno);

    perform_action(params);
}

function sendreject() {
    let refno = $('#current_refno').val();
    let serialno = $('#current_serialno').val();

    if (!confirm("Send to REJECT?")) return;

    let params = new URLSearchParams();
    params.append('Command', 'sendreject');
    params.append('refno', refno);
    params.append('serialno', serialno);

    perform_action(params);
}

function perform_action(params) {
    fetch('comp_list_data.php', {
        method: 'POST',
        body: params
    })
        .then(response => response.json())
        .then(data => {
            if (data.status === 'success') {
                $('#exampleModal').modal('hide');
                alert(data.message);
                load_list();
            } else {
                alert(data.message);
            }
        })
        .catch(error => {
            console.error('Error:', error);
            alert('An error occurred');
        });
}
