
// All List Controller

$(document).ready(function () {
    load_list();
});

function load_list() {
    if ($.fn.DataTable.isDataTable('#example')) {
        $('#example').DataTable().destroy();
    }

    $('#example').DataTable({
        "ajax": {
            "url": "all_list_data.php?Command=get_list",
            "type": "GET"
        },
        "columns": [
            {
                "data": null, "render": function (data, type, row, meta) {
                    return meta.row + 1;
                }
            },
            {
                "data": "jobno", "render": function (data, type, row) {
                    return `<span style="background-color:#ffeb00; display:block; padding:5px;">${data}</span>`;
                }
            },
            { "data": "refno" },
            { "data": "sdate" },
            { "data": "cusname" },
            { "data": "marker" },
            { "data": "size" },
            { "data": "belt" },
            { "data": "serialno" },
            { "data": "adpayment" },
            { "data": "amount" },
            { "data": "repair" },
            { "data": "total" },
            { "data": "onhand_date" },
            { "data": "pro_date" },
            { "data": "invno" },
            { "data": "inv_date" },
            { "data": "inv_cus_name" },
            {
                "data": null, "render": function (data, type, row) {
                    return `<span style="background-color:${row.status_bg}; display:block; padding:5px;">${row.status_html}</span>`;
                }
            },
            { "data": "warrenty" },
            { "data": "remark" }
        ],
        "dom": 'Bfrtip',
        "buttons": [
            'pageLength',
            {
                extend: 'print',
                title: 'ALL LIST'
            }
        ],
        "pageLength": 10,
        "responsive": true
    });
}