<?php 
session_start();
require_once("connectioni.php");
date_default_timezone_set('Asia/Colombo');

if ($_SESSION['company'] == "") { 
    exit("Please Login");
}
if ($_SESSION['CURRENT_USER'] == "") { 
    exit("Please Login");
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Item Claim</title>
    <!-- Bootstrap 3.3.7 -->
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/css/bootstrap.min.css">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
    
    <!-- Scripts -->
    <script type="text/javascript" src="js/item_claim_gin.js"></script>
    <script type="text/javascript" src="js/ord.js"></script>

    <script type="text/javascript">
    function load_calader(tar){
        // Native HTML5 date picker used, shim for compatibility
    }
    
    function close_form() {
        close();
    }
    
    // Window Popup Helper
    function NewWindow(mypage,myname,w,h,scroll,pos){
        if(pos=="random"){LeftPosition=(screen.width)?Math.floor(Math.random()*(screen.width-w)):100;TopPosition=(screen.height)?Math.floor(Math.random()*((screen.height-h)-75)):100;}
        if(pos=="center"){LeftPosition=(screen.width)?(screen.width-w)/2:100;TopPosition=(screen.height)?(screen.height-h)/2:100;}
        else if((pos!="center" && pos!="random") || pos==null){LeftPosition=0;TopPosition=20}
        settings='width='+w+',height='+h+',top='+TopPosition+',left='+LeftPosition+',scrollbars='+scroll+',location=no,directories=no,status=no,menubar=no,toolbar=no,resizable=no';
        win=window.open(mypage,myname,settings);
    }
    </script>

    <style>
        body {
            background-color: #ecf0f5;
            font-family: 'Source Sans Pro', 'Helvetica Neue', Helvetica, Arial, sans-serif;
            font-size: 14px;
        }
        
        /* Navbar Styles */
        .navbar-custom {
            background-color: #2c3e50;
            color: white;
            padding: 10px 20px;
            display: flex;
            justify-content: space-between;
            align-items: center;
            box-shadow: 0 2px 5px rgba(0,0,0,0.1);
            margin-bottom: 20px;
        }
        .navbar-brand {
            font-size: 24px;
            font-weight: bold;
            color: white !important;
            text-decoration: none;
            padding: 0;
            height: auto;
            line-height: normal;
        }
        .page-title-box {
            background: rgba(255, 255, 255, 0.1);
            border: 1px solid rgba(255, 255, 255, 0.2);
            padding: 8px 30px;
            border-radius: 5px;
            font-size: 18px;
            font-weight: 600;
            letter-spacing: 1px;
            text-transform: uppercase;
        }
        .user-info {
            display: flex;
            align-items: center;
            gap: 15px;
        }
        .logout-btn {
            background-color: #e74c3c;
            color: white;
            border: none;
            padding: 6px 15px;
            border-radius: 4px;
            font-weight: 600;
            transition: background 0.3s;
            text-decoration: none !important;
        }
        .logout-btn:hover {
            background-color: #c0392b;
            color: white;
        }
        .user-name {
            font-weight: bold;
        }

        /* Content Wrapper */
        .content-wrapper {
            padding: 20px;
        }
        
        /* Box/Card Styling */
        .box {
            background: #fff;
            border-top: 3px solid #d2d6de;
            margin-bottom: 20px;
            width: 100%;
            box-shadow: 0 1px 1px rgba(0,0,0,0.1);
            border-radius: 3px;
        }
        .box-primary { border-top-color: #3c8dbc; }
        .box-success { border-top-color: #00a65a; }
        .box-warning { border-top-color: #f39c12; }
        .box-danger  { border-top-color: #dd4b39; }
        
        .box-header {
            color: #444;
            display: block;
            padding: 10px;
            position: relative;
            border-bottom: 1px solid #f4f4f4;
            background-color: #f9fafc;
        }
        .box-header .box-title {
            display: inline-block;
            font-size: 18px;
            margin: 0;
            line-height: 1;
            font-weight: 600;
        }
        .box-body {
            border-top-left-radius: 0;
            border-top-right-radius: 0;
            border-bottom-right-radius: 3px;
            border-bottom-left-radius: 3px;
            padding: 20px;
        }

        /* Form Controls */
        .form-control {
            border-radius: 0;
            box-shadow: none;
            border-color: #d2d6de;
        }
        .form-control:focus {
            border-color: #3c8dbc;
            box-shadow: none;
        }
        .form-control[disabled], .form-control[readonly], fieldset[disabled] .form-control {
            background-color: #eee;
        }

        /* Buttons */
        .btn {
            border-radius: 3px;
            box-shadow: none;
            border: 1px solid transparent;
        }
        .btn-app {
            border-radius: 3px;
            position: relative;
            padding: 15px 5px;
            margin: 0 0 10px 10px;
            min-width: 80px;
            height: 60px;
            text-align: center;
            color: #666;
            border: 1px solid #ddd;
            background-color: #f4f4f4;
            font-size: 12px;
        }
        .btn-app > .fa, .btn-app > .glyphicon, .btn-app > .ion {
            font-size: 20px;
            display: block;
            margin-bottom: 10px;
        }
        .btn-app:hover {
            background: #f4f4f4;
            color: #444;
            border-color: #aaa;
        }
        
        /* Specific Styles */
        .threads-table th {
            text-align: center;
            background-color: #eee;
        }
        .threads-table input {
            text-align: center;
        }
        textarea {
            resize: vertical;
        }
    </style>
</head>
<body class="hold-transition skin-blue layout-top-nav">

    <!-- Custom Navbar -->
    <div class="navbar-custom">
        <div class="navbar-brand">ERP SYSTEM MENU</div>
        
        <div class="page-title-box">
            Item Claim (GIN)
        </div>
        
        <div class="user-info">
             <span>Welcome, <span class="user-name"><?php echo $_SESSION['user_name']; ?></span> [<?php echo $_SESSION['company']; ?>]</span>
            <a href="logout.php" class="logout-btn">Logout (Ctrl+Q)</a>
        </div>
    </div>

<div class="content-wrapper">
    <section class="content">

        <!-- Action Toolbar -->
        <div class="box box-solid">
            <div class="box-body">
                <a onclick="new_inv1();" class="btn btn-app">
                    <i class="fa fa-plus"></i> New
                </a>
                <a onclick="save_inv1();" class="btn btn-app">
                    <i class="fa fa-save"></i> Save
                </a>
                <a onclick="cancel_inv();" class="btn btn-app">
                    <i class="fa fa-ban"></i> Cancel
                </a>
                <a onclick="print_inv1();" class="btn btn-app">
                    <i class="fa fa-print"></i> Print
                </a>
                <a onclick="close_form();" class="btn btn-app">
                    <i class="fa fa-close"></i> Close
                </a>
            </div>
        </div>

        <form role="form" name="form1" id="form1">
            <input type="hidden" name="txt_cuscode" id="txt_cuscode" value="" />
            <input type="hidden" name="c_subcode" id="c_subcode" value="" />

            <div class="row">
                <!-- Left Column: General Info -->
                <div class="col-md-6">
                    <div class="box box-primary">
                        <div class="box-header with-border">
                            <h3 class="box-title">General Information</h3>
                        </div>
                        <div class="box-body">
                            <div class="form-group row">
                                <label class="col-sm-2 control-label">Ref No</label>
                                <div class="col-sm-4">
                                    <div class="input-group">
                                        <input type="text" disabled class="form-control" name="txtrefno" id="txtrefno">
                                        <span class="input-group-btn">
                                            <button class="btn btn-default" type="button" onclick="NewWindow('item_claim_gin_search.php?stname=claim_item','mywin','800','700','yes','center');return false"><i class="fa fa-search"></i></button>
                                        </span>
                                    </div>
                                </div>
                                <label class="col-sm-2 control-label">Ent Date</label>
                                <div class="col-sm-4">
                                    <input type="date" disabled class="form-control" name="txtentdate" id="txtentdate" value="<?php echo date("Y-m-d"); ?>">
                                </div>
                            </div>
                            
                            <div class="form-group row">
                                <label class="col-sm-2 control-label">GatePass</label>
                                <div class="col-sm-4">
                                     <input type="date" class="form-control" name="dtf" id="dtf" value="<?php echo date("Y-m-d"); ?>">
                                </div>
                                <label class="col-sm-2 control-label">Date</label>
                                <div class="col-sm-4">
                                     <!-- Placeholder for spacing or future field -->
                                </div>
                            </div>

                             <div class="form-group row">
                                <label class="col-sm-2 control-label">Claim No</label>
                                <div class="col-sm-4">
                                    <input type="text" class="form-control" name="txtcl_no" id="txtcl_no">
                                </div>
                                <div class="col-sm-6">
                                    <div class="checkbox">
                                        <label>
                                            <input type="checkbox" name="Prn_md" id="Prn_md"> Print to Management
                                        </label>
                                    </div>
                                </div>
                            </div>

                            <div class="form-group row">
                                <label class="col-sm-2 control-label">Rec Date</label>
                                <div class="col-sm-4">
                                     <input type="date" class="form-control" name="DTPicker_recdate" id="DTPicker_recdate" value="<?php echo date("Y-m-d"); ?>">
                                </div>
                                 <label class="col-sm-2 control-label">Ret Date</label>
                                <div class="col-sm-4">
                                     <input type="date" class="form-control" name="dtto" id="dtto" value="<?php echo date("Y-m-d"); ?>">
                                </div>
                            </div>

                             <div class="form-group row">
                                <label class="col-sm-2 control-label">Photo No</label>
                                <div class="col-sm-4">
                                    <input type="text" class="form-control" name="txtphotono" id="txtphotono">
                                </div>
                            </div>

                        </div>
                    </div>
                    
                     <div class="box box-info">
                        <div class="box-header with-border">
                            <h3 class="box-title">Customer & Item Details</h3>
                        </div>
                        <div class="box-body">
                             <div class="form-group row">
                                <label class="col-sm-2 control-label">Agent</label>
                                <div class="col-sm-3">
                                    <input type="text" disabled class="form-control" name="txtag_code" id="txtag_code">
                                </div>
                                <div class="col-sm-5">
                                    <input type="text" disabled class="form-control" name="txtag_name" id="txtag_name">
                                </div>
                                <div class="col-sm-2">
                                     <button class="btn btn-default" type="button" name="searchcust" id="searchcust" onclick="NewWindow('item_claim_gin_cus_search.php?stname=item_claim','mywin','800','700','yes','center');return false"><i class="fa fa-search"></i></button>
                                </div>
                            </div>
                            
                            <div class="form-group row">
                                <label class="col-sm-2 control-label">Customer</label>
                                <div class="col-sm-4">
                                    <input type="text" class="form-control" name="txtcus_name" id="txtcus_name">
                                </div>
                                <label class="col-sm-2 control-label">Address</label>
                                <div class="col-sm-4">
                                    <input type="text" class="form-control" name="txtcus_add" id="txtcus_add">
                                </div>
                            </div>
                            
                            <hr>
                            
                             <div class="form-group row">
                                <label class="col-sm-2 control-label">Stk No</label>
                                <div class="col-sm-4">
                                    <div class="input-group">
                                        <input type="text" disabled class="form-control" name="txtstk_no" id="txtstk_no">
                                        <span class="input-group-btn">
                                            <button class="btn btn-default" type="button" name="searchcust2" id="searchcust2" onclick="NewWindow('item_claim_gin_item_search.php?stname=claim_item','mywin','1000','700','yes','center');return false"><i class="fa fa-search"></i></button>
                                        </span>
                                    </div>
                                </div>
                                <label class="col-sm-2 control-label">Desc</label>
                                <div class="col-sm-4">
                                    <input type="text" disabled class="form-control" name="txtdes" id="txtdes">
                                </div>
                            </div>
                            
                            <div class="form-group row">
                                <label class="col-sm-2 control-label">Brand</label>
                                <div class="col-sm-4">
                                    <input type="text" disabled class="form-control" name="txtbrand" id="txtbrand">
                                </div>
                                <label class="col-sm-2 control-label">Pattern</label>
                                <div class="col-sm-4">
                                     <input type="text" disabled class="form-control" name="txtpatt" id="txtpatt">
                                </div>
                            </div>
                            
                             <div class="form-group row">
                                <label class="col-sm-2 control-label">Serial No</label>
                                <div class="col-sm-10">
                                    <input type="text" class="form-control" name="txtseri_no" id="txtseri_no">
                                </div>
                            </div>

                        </div>
                    </div>
                </div>

                <!-- Right Column: Details & Refund -->
                <div class="col-md-6">
                    <div class="box box-warning">
                        <div class="box-header with-border">
                            <h3 class="box-title">Observation & Refund</h3>
                        </div>
                        <div class="box-body">
                             <div class="form-group">
                                <label>Type of Defects</label>
                                <select name="Combo1" id="Combo1" class="form-control" onchange="settec_obs();">
                                    <option value=""></option>
                                    <?php
                                    $sql="select tc_ob from c_clamas_gin group by tc_ob order by tc_ob";
                                    $result = mysqli_query($GLOBALS['dbinv'], $sql);
                                    while($row = mysqli_fetch_array($result)){
                                        echo "<option value='".$row["tc_ob"]."'>".$row["tc_ob"]."</option>";
                                    }
                                    ?>
                                </select>
                             </div>
                             
                             <div class="form-group">
                                <label>Technical Observation</label>
                                <textarea name="txttc_ob" id="txttc_ob" class="form-control" rows="3"></textarea>
                             </div>
                             
                             <div class="form-group row">
                                 <label class="col-sm-2 control-label">Refund</label>
                                 <div class="col-sm-10">
                                    <select name="Cmb_refund" id="Cmb_refund" class="form-control" onchange="setord();">
                                        <option value='Not Recommended'>Not Recommended</option>
                                        <option value='Recommended'>Recommended</option>
                                    </select>
                                 </div>
                             </div>
                             
                              <div class="form-group row">
                                <div class="col-sm-4">
                                     <label>Spec</label>
                                     <input type="text" class="form-control" name="txtspec" id="txtspec">
                                </div>
                                <div class="col-sm-4">
                                     <label>Remming</label>
                                     <input type="text" class="form-control" name="txtremming" id="txtremming">
                                </div>
                                <div class="col-sm-4">
                                     <label>Ref Per</label>
                                     <input type="text" class="form-control" name="txtref_per" id="txtref_per">
                                </div>
                              </div>
                              
                              <!-- Threads Table -->
                              <table class="table table-bordered threads-table">
                                  <thead>
                                      <tr>
                                          <th colspan="5">Remaining Threads %</th>
                                          <th rowspan="2" style="vertical-align: middle;">Rem %</th>
                                      </tr>
                                  </thead>
                                  <tbody>
                                      <tr>
                                        <td><input type="text" class="form-control" name="txtremin1" id="txtremin1" onblur="calc_rem();"></td>
                                        <td><input type="text" class="form-control" name="txtremin2" id="txtremin2" onblur="calc_rem();"></td>
                                        <td><input type="text" class="form-control" name="txtremin3" id="txtremin3" onblur="calc_rem();"></td>
                                        <td><input type="text" class="form-control" name="txtremin4" id="txtremin4" onblur="calc_rem();"></td>
                                        <td><input type="text" class="form-control" name="txtremin5" id="txtremin5" onblur="calc_rem();"></td>
                                        <td rowspan="2" style="background:#fff;"><input type="text" class="form-control" name="txtrem_per" id="txtrem_per"></td>
                                      </tr>
                                       <tr>
                                        <td><input type="text" disabled class="form-control" name="txtorigin1" id="txtorigin1" onblur="calc_rem();"></td>
                                        <td><input type="text" class="form-control" name="txtorigin2" id="txtorigin2" onblur="calc_rem();"></td>
                                        <td><input type="text" class="form-control" name="txtorigin3" id="txtorigin3" onblur="calc_rem();"></td>
                                        <td><input type="text" class="form-control" name="txtorigin4" id="txtorigin4" onblur="calc_rem();"></td>
                                        <td><input type="text" class="form-control" name="txtorigin5" id="txtorigin5" onblur="calc_rem();"></td>
                                      </tr>
                                  </tbody>
                              </table>
                              
                               <div class="form-group row">
                                 <label class="col-sm-2 control-label">Commercialy</label>
                                 <div class="col-sm-4">
                                     <select name="cmb_comm" id="cmb_comm" class="form-control" onchange="chngcomm();">
                                        <option value='Not Allowed'>Not Allowed</option>
                                        <option value='Allowed'>Allowed</option>
                                     </select>
                                 </div>
                                 <div class="col-sm-6">
                                     <div class="checkbox">
                                        <label>
                                            <input type="checkbox" name="Check1" id="Check1" onclick="show_hide()"> Additional Refund
                                        </label>
                                        <div id="additional" style="display:inline-block;">
                                            <input type="text" class="form-control input-sm" name="txtadd_ref1" id="txtadd_ref1" style="width: 80px; display: inline-block; visibility:hidden;">
                                            <input type="text" class="form-control input-sm" name="txtadd_ref2" id="txtadd_ref2" style="width: 80px; display: inline-block; visibility:hidden;">
                                        </div>
                                    </div>
                                 </div>
                               </div>

                        </div>
                    </div>
                </div>
            </div><!-- /.row -->
            
            <div class="row">
                <!-- Management Obs Check (Hidden but present in original) -->
                 <div class="col-md-6">
                    <div class="box box-danger">
                        <div class="box-header with-border">
                            <h3 class="box-title">Management</h3>
                        </div>
                        <div class="box-body">
                             <div class="form-group row" style="display: none;">
                                <label class="col-sm-2 control-label">Approved By</label>
                                <div class="col-sm-4">
                                     <select name="approvedby" id="approvedby" class="form-control">
                                         <option value=''></option>
                                         <option value='MD'>MD</option>
                                         <option value='WD'>WD</option>
                                     </select>
                                     <input type="hidden" name="apprby" id="apprby">
                                </div>
                             </div>
                             
                             <div class="form-group">
                                 <label>Management Further Observation</label>
                                 <textarea name="txtmn_ob" id="txtmn_ob" class="form-control" rows="3"></textarea>
                             </div>
                        </div>
                    </div>
                </div>

                <!-- DGRN Section -->
                 <div class="col-md-6">
                    <div class="box box-default">
                        <div class="box-header with-border">
                            <h3 class="box-title">DGRN References</h3>
                        </div>
                        <div class="box-body">
                            <div class="form-group row">
                                <label class="col-sm-2 control-label">DGRN 1</label>
                                <div class="col-sm-3"><input type="text" disabled class="form-control input-sm" name="txtCRD_no" id="txtCRD_no"></div>
                                <label class="col-sm-1 control-label">Date</label>
                                <div class="col-sm-3"><input type="text" disabled class="form-control input-sm" name="txtCRE_date" id="txtCRE_date"></div>
                                <label class="col-sm-1 control-label">Amt</label>
                                <div class="col-sm-2"><input type="text" disabled class="form-control input-sm" name="txtCRE_amount" id="txtCRE_amount"></div>
                            </div>
                            <div class="form-group row">
                                <label class="col-sm-2 control-label">DGRN 2</label>
                                <div class="col-sm-3"><input type="text" disabled class="form-control input-sm" name="txtCRD_no2" id="txtCRD_no2"></div>
                                <label class="col-sm-1 control-label">Date</label>
                                <div class="col-sm-3"><input type="text" disabled class="form-control input-sm" name="txtCRE_date2" id="txtCRE_date2"></div>
                                <label class="col-sm-1 control-label">Amt</label>
                                <div class="col-sm-2"><input type="text" disabled class="form-control input-sm" name="txtCRE_amount2" id="txtCRE_amount2"></div>
                            </div>
                            <div class="form-group row">
                                <label class="col-sm-2 control-label">DGRN 3</label>
                                <div class="col-sm-3"><input type="text" disabled class="form-control input-sm" name="txtCRD_no3" id="txtCRD_no3"></div>
                                <label class="col-sm-1 control-label">Date</label>
                                <div class="col-sm-3"><input type="text" disabled class="form-control input-sm" name="txtCRE_date3" id="txtCRE_date3"></div>
                                <label class="col-sm-1 control-label">Amt</label>
                                <div class="col-sm-2"><input type="text" disabled class="form-control input-sm" name="txtCRE_amount3" id="txtCRE_amount3"></div>
                            </div>
                        </div>
                    </div>
                 </div>

            </div>
        </form>

    </section>
</div>

<script>
    // Initialize
    new_inv1();

    // Keyboard Shortcut for Logout (Ctrl+Q)
    document.addEventListener('keydown', function(event) {
        if (event.ctrlKey && (event.key === 'q' || event.key === 'Q')) {
            event.preventDefault();
            window.location.href = 'logout.php';
        }
    });
</script>
</body>
</html>
