<?php 
session_start();
require_once("connectioni.php");
date_default_timezone_set('Asia/Colombo');
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Sales Return (GRN)</title>
    <!-- Bootstrap 3.3.7 -->
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/css/bootstrap.min.css">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
    
    <!-- Scripts -->
    <script language="JavaScript" src="js/grn.js"></script>

    <!-- Popup Window Script -->
    <script language="javascript" type="text/javascript">
    var win=null;
    function NewWindow(mypage,myname,w,h,scroll,pos){
        if(pos=="random"){LeftPosition=(screen.width)?Math.floor(Math.random()*(screen.width-w)):100;TopPosition=(screen.height)?Math.floor(Math.random()*((screen.height-h)-75)):100;}
        if(pos=="center"){LeftPosition=(screen.width)?(screen.width-w)/2:100;TopPosition=(screen.height)?(screen.height-h)/2:100;}
        else if((pos!="center" && pos!="random") || pos==null){LeftPosition=0;TopPosition=20}
        settings='width='+w+',height='+h+',top='+TopPosition+',left='+LeftPosition+',scrollbars='+scroll+',location=no,directories=no,status=no,menubar=no,toolbar=no,resizable=no';
        win=window.open(mypage,myname,settings);
    }
    function close_form() {
        close();
    }
    </script>
    
    <!-- Initial Load Script -->
    <script type="text/javascript">
     window.onload = function(){
        new_inv(); // Initialize
     };
    </script>

    <style>
        body {
            background-color: #ecf0f5;
            font-family: 'Source Sans Pro', 'Helvetica Neue', Helvetica, Arial, sans-serif;
            font-size: 14px;
        }
        
        /* Navbar Styles */
        .navbar-custom {
            background-color: #2c3e50;
            color: white;
            padding: 10px 20px;
            display: flex;
            justify-content: space-between;
            align-items: center;
            box-shadow: 0 2px 5px rgba(0,0,0,0.1);
            margin-bottom: 20px;
        }
        .navbar-brand {
            font-size: 24px;
            font-weight: bold;
            color: white !important;
            text-decoration: none;
            padding: 0;
            height: auto;
            line-height: normal;
        }
        .page-title-box {
            background: rgba(255, 255, 255, 0.1);
            border: 1px solid rgba(255, 255, 255, 0.2);
            padding: 8px 30px;
            border-radius: 5px;
            font-size: 18px;
            font-weight: 600;
            letter-spacing: 1px;
            text-transform: uppercase;
        }
        .user-info {
            display: flex;
            align-items: center;
            gap: 15px;
        }
        .logout-btn {
            background-color: #e74c3c;
            color: white;
            border: none;
            padding: 6px 15px;
            border-radius: 4px;
            font-weight: 600;
            transition: background 0.3s;
            text-decoration: none !important;
        }
        .logout-btn:hover {
            background-color: #c0392b;
            color: white;
        }
        .user-name {
            font-weight: bold;
        }

        /* Content Wrapper */
        .content-wrapper {
            padding: 20px;
        }
        
        /* Box/Card Styling */
        .box {
            background: #fff;
            border-top: 3px solid #d2d6de;
            margin-bottom: 20px;
            width: 100%;
            box-shadow: 0 1px 1px rgba(0,0,0,0.1);
            border-radius: 3px;
        }
        .box.box-primary {
            border-top-color: #3c8dbc;
        }
        .box-header {
            color: #444;
            display: block;
            padding: 10px;
            position: relative;
            border-bottom: 1px solid #f4f4f4;
        }
        .box-header .box-title {
            display: inline-block;
            font-size: 18px;
            margin: 0;
            line-height: 1;
        }
        .box-body {
            border-top-left-radius: 0;
            border-top-right-radius: 0;
            border-bottom-right-radius: 3px;
            border-bottom-left-radius: 3px;
            padding: 20px;
        }

        /* Form Controls */
        .form-control {
            border-radius: 0;
            box-shadow: none;
            border-color: #d2d6de;
        }
        .form-control:focus {
            border-color: #3c8dbc;
            box-shadow: none;
        }
        .control-label {
            font-weight: 600;
            text-align: left !important;
            padding-top: 7px;
        }
        
        /* Buttons */
        .btn {
            border-radius: 3px;
            box-shadow: none;
            border: 1px solid transparent;
        }

        /* Radio Buttons */
        .radio-inline {
            font-weight: bold;
            font-size: 14px;
            padding-left: 25px;
        }

        /* Table Styling Overrides */
        #itemdetails table, #storgrid table {
            width: 100%;
            margin-bottom: 20px;
            border: 1px solid #f4f4f4;
            border-collapse: collapse;
            font-size: 13px;
        }
        #itemdetails table th, #itemdetails table td,
        #storgrid table th, #storgrid table td {
            padding: 8px;
            line-height: 1.42857143;
            vertical-align: top;
            border: 1px solid #ddd;
        }
        #itemdetails table tr:first-child td,
        #storgrid table tr:first-child td {
            background-color: #3c8dbc !important;
            color: white !important;
            font-weight: bold;
            border-bottom: 2px solid #3c8dbc;
        }
        
        /* Utility */
        .mt-10 { margin-top: 10px; }
        
        /* Legacy overrides */
        .hidden { display: none; }
        input[disabled], select[disabled], textarea[disabled] {
            cursor: not-allowed;
            background-color: #eee;
            opacity: 1;
        }
    </style>
</head>
<body class="hold-transition skin-blue layout-top-nav">

    <!-- Custom Navbar -->
    <div class="navbar-custom">
        <div class="navbar-brand">ERP SYSTEM MENU</div>
        
        <div class="page-title-box">
            Sales Return
        </div>
        
        <div class="user-info">
             <span>Welcome, <span class="user-name"><?php echo $_SESSION['user_name']; ?></span> [<?php echo $_SESSION['company']; ?>]</span>
            <a href="logout.php" class="logout-btn">Logout (Ctrl+Q)</a>
        </div>
    </div>

<div class="content-wrapper">
    <section class="content">

        <!-- Action Toolbar -->
        <div class="box box-solid">
            <div class="box-body">
                <a onclick="new_inv();" class="btn btn-app">
                    <i class="fa fa-plus"></i> New
                </a>
                <a onclick="save_inv();" class="btn btn-app">
                    <i class="fa fa-save"></i> Save
                </a>
                <a onclick="cancel_inv();" class="btn btn-app">
                    <i class="fa fa-ban"></i> Cancel
                </a>
                <a onclick="print_inv();" class="btn btn-app">
                    <i class="fa fa-print"></i> Print
                </a>
                <a onclick="close_form();" class="btn btn-app">
                    <i class="fa fa-close"></i> Close
                </a>
            </div>
        </div>

        <div class="row">
            <!-- Details -->
            <div class="col-md-12">
                <div class="box box-primary">
                    <div class="box-header with-border">
                        <h3 class="box-title">Return Details</h3>
                    </div>
                    <div class="box-body">
                        <form role="form" name="form1" id="form1" class="form-horizontal">
                            
                            <!-- Row 1: GRN No, Search, Date, Department -->
                            <div class="form-group bg-info" style="padding: 10px 0; margin-bottom: 15px;">
                                <label class="col-sm-1 control-label">GRN No</label>
                                <div class="col-sm-3">
                                    <div class="input-group">
                                        <input type="text" class="form-control input-sm" name="grnno" id="grnno" disabled onkeypress="keyset('searchcust',event);" onfocus="got_focus('grnno');"  onblur="lost_focus('grnno');">
                                        <span class="input-group-btn">
                                            <a class="btn btn-default btn-sm" href="search_grn.php?stname=grn" onClick="NewWindow(this.href,'mywin','800','700','yes','center');return false"><i class="fa fa-search"></i></a>
                                        </span>
                                    </div>
                                </div>
                                <label class="col-sm-1 control-label">Date</label>
                                <div class="col-sm-3">
                                     <input type="date" class="form-control input-sm" name="grndate" id="grndate" value="<?php echo date("Y-m-d"); ?>" disabled>
                                </div>
                                <label class="col-sm-1 control-label">Dept</label>
                                <div class="col-sm-3">
                                    <select name="department" id="department" disabled onkeypress="keyset('brand',event);" onchange="setord();" class="form-control input-sm">
                                      <?php
                                         if ($_SESSION["CURRENT_DEP"] != "") {
                                           $sql="select * from s_stomas where  act='1' and CODE='".$_SESSION["CURRENT_DEP"] ."' order by CODE";
                                        }else{
                                          $sql="select * from s_stomas where  act='1'  order by CODE";
                                        }
                                        $result =mysqli_query($GLOBALS['dbinv'],$sql) ; 
                                        while($row = mysqli_fetch_array($result)){
                                        echo "<option value='".$row["CODE"]."'>".$row["CODE"]." ".$row["DESCRIPTION"]."</option>";
                                        }
                                        ?>
                                    </select>
                                </div>
                            </div>
                            
                            <!-- Row 2: R.No, Sto. Ref, Hidden Fields -->
                            <div class="form-group">
                                <label class="col-sm-1 control-label">R.No</label>
                                <div class="col-sm-3">
                                     <input type="text" class="form-control input-sm" name="rno" id="rno" disabled onkeypress="keyset('searchcust',event);" onfocus="got_focus('grnno');"  onblur="lost_focus('grnno');">
                                </div>
                                <label class="col-sm-1 control-label">Sto. Ref.</label>
                                <div class="col-sm-3">
                                     <input type="text" class="form-control input-sm" name="txtstoRef" id="txtstoRef">
                                </div>
                                <input type="hidden" id="gst">
                                <input id="dte_dor" name="dte_dor" type="hidden" value="">
                            </div>

                            <!-- Row 3: Payment Method, VAT Group -->
                            <div class="form-group">
                                <div class="col-sm-3">
                                    <label class="radio-inline">
                                        <input type="radio" name="paymethod" value="credit" id="paymethod_0"> Credit
                                    </label>
                                    <label class="radio-inline">
                                        <input type="radio" name="paymethod" value="cash" id="paymethod_1"> Cash
                                    </label>
                                </div>
                                <div class="col-sm-9">
                                    <label class="radio-inline"><input type="radio" name="vatgroup" value="vat" id="vatgroup_0" onkeypress="keyset('discount1',event);"> VAT Invoice</label>
                                    <label class="radio-inline"><input type="radio" name="vatgroup" value="non" id="vatgroup_1" onkeypress="keyset('discount1',event);"> Non VAT Invoice</label>
                                    <label class="radio-inline"><input type="radio" name="vatgroup" value="svat" id="vatgroup_2" onkeypress="keyset('discount1',event);"> SVAT Invoice</label>
                                    <label class="radio-inline"><input type="radio" name="vatgroup" value="evat" id="vatgroup_3" onkeypress="keyset('discount1',event);"> EVAT Invoice</label>
                                </div>
                            </div>
                            
                            <hr>

                            <!-- Row 4: Customer, Search, Invoice No -->
                            <div class="form-group">
                                <label class="col-sm-1 control-label">Customer</label>
                                <div class="col-sm-2">
                                     <div class="input-group">
                                        <input type="text" class="form-control input-sm" name="firstname_hidden" id="firstname_hidden" onkeypress="keyset('searchinv2',event);" onblur="custno_ind();">
                                        <span class="input-group-btn">
                                            <a class="btn btn-default btn-sm" href="" onClick="NewWindow('serach_customer.php?stname=grn','mywin','800','700','yes','center');return false"><i class="fa fa-search"></i></a>
                                        </span>
                                    </div>
                                </div>
                                <div class="col-sm-3">
                                    <input type="text" class="form-control input-sm" id="firstname" disabled name="firstname">
                                </div>
                                <label class="col-sm-1 control-label">Inv No</label>
                                <div class="col-sm-3">
                                    <div class="input-group">
                                        <input type="text" class="form-control input-sm" name="invno" id="invno" disabled onkeypress="keyset('balance',event);">
                                        <span class="input-group-btn">
                                            <a class="btn btn-default btn-sm" href="serach_inv.php?stname=grn" onClick="NewWindow(this.href,'mywin','800','700','yes','center');return false"><i class="fa fa-search"></i></a>
                                        </span>
                                    </div>
                                </div>
                            </div>
                            
                            <!-- Row 5: Address, Invoice Date -->
                             <div class="form-group">
                                <label class="col-sm-1 control-label">Address</label>
                                <div class="col-sm-5">
                                    <input type="text" class="form-control input-sm" id="cus_address" name="cus_address" disabled>
                                </div>
                                <label class="col-sm-1 control-label">Inv Date</label>
                                <div class="col-sm-3">
                                     <input type="text" class="form-control input-sm" name="invdate" id="invdate" disabled onkeypress="keyset('department',event);">
                                </div>
                             </div>

                             <!-- Row 6: Brand, Sales Rep, Cost Center, Serial No -->
                             <div class="form-group">
                                <label class="col-sm-1 control-label">Brand</label>
                                <div class="col-sm-3">
                                    <select name="brand" id="brand" disabled onkeypress="keyset('searchitem',event);" onchange="setord();" class="form-control input-sm">
                                      <?php
                                        if (($_SESSION["CURRENT_DEP"] != "") and (!is_numeric($_SESSION["CURRENT_DEP"]))) {
                                            $sql="select * from brand_mas where act ='1' and costcenter='".$_SESSION["CURRENT_DEP"]."' order by barnd_name"; 
                                        }else{
                                            $sql="select * from brand_mas where act ='1' order by barnd_name";
                                        } 
                                        $result =mysqli_query($GLOBALS['dbinv'],$sql) ; 
                                        while($row = mysqli_fetch_array($result)){
                                             echo "<option value='".$row["barnd_name"]."'>".$row["barnd_name"]."</option>";
                                        }
                                        ?>
                                    </select>
                                </div>
                                <label class="col-sm-1 control-label">Sales Rep</label>
                                <div class="col-sm-3">
                                    <select name="salesrep" id="salesrep" disabled onkeypress="keyset('dte_dor',event);" onchange="setord();" class="form-control input-sm">
                                      <?php
                                        require_once("connectioni.php");
                                            if ($_SESSION["MANAGER"]!="") { 			 						
                                                $sql="select * from s_salrep where pactive='1' and manager='".$_SESSION["MANAGER"]."'order by REPCODE"; 
                                                $result =mysqli_query($GLOBALS['dbinv'],$sql) ; 
                                                while($row = mysqli_fetch_array($result)){
                                                    echo "<option value='".$row["REPCODE"]."'>".$row["REPCODE"]." ".$row["Name"]."</option>";
                                                }
                                             }else if ($_SESSION["CURRENT_REP"]=="") { 			 						
                                                $sql="select * from s_salrep where pactive='1' order by REPCODE";
                                                $result =mysqli_query($GLOBALS['dbinv'],$sql) ; 
                                                while($row = mysqli_fetch_array($result)){
                                                    echo "<option value='".$row["REPCODE"]."'>".$row["REPCODE"]." ".$row["Name"]."</option>";
                                                }
                                             } else {
                                                 $sql="select * from s_salrep where pactive='1' and repcode = '" . $_SESSION["CURRENT_REP"] ."' order by REPCODE";
                                                 $result =mysqli_query($GLOBALS['dbinv'],$sql) ; 
                                                 while($row = mysqli_fetch_array($result)){
                                                 echo "<option value='".$row["REPCODE"]."'>".$row["REPCODE"]." ".$row["Name"]."</option>";
                                                 }
                                             }
                                        ?>
                                    </select>
                                </div>
                                <label class="col-sm-1 control-label">Cost C.</label>
                                <div class="col-sm-1">
                                    <select name="costcenter" id="costcenter" disabled class="form-control input-sm">
                                      <?php 
                                            for ($i=1; $i<51; $i++){
                                                echo "<option value=".$i.">".$i."</option>";
                                            }
                                         ?>
                                    </select>
                                </div>
                                <label class="col-sm-1 control-label">Serial(MC)</label>
                                <div class="col-sm-1">
                                    <input type="text" class="form-control input-sm" name="serialno" id="serialno" value="0" onkeypress="keyset('itemd_hidden',event);">
                                </div>
                            </div>
                            
                            <div class="form-group">
                                <label class="col-sm-2 control-label">Invoice No (Chk)</label>
                                <div class="col-sm-1">
                                     <input type="checkbox" name="chkinvno" id="chkinvno" onclick="enable_disable();" >
                                </div>
                            </div>

                            <hr>
                            <h4 class="box-title text-primary">Item Details</h4>
                            <input type="hidden" name="mcou" id="mcou" value="0" />
                            
                            <!-- Item Input Row -->
                             <div class="row" style="margin-bottom: 10px;">
                                <div class="col-sm-2">
                                    <label>Code</label>
                                    <input type="text" class="form-control input-sm" name="item_code" id="item_code" disabled onkeypress="keyset('qty',event);" onblur="itno_ind();">
                                </div>
                                <div class="col-sm-1">
                                     <label>&nbsp;</label>
                                     <button type="button" class="btn btn-default btn-sm btn-block" name="searchitem" id="searchitem" disabled onclick="NewWindow('serach_item.php?stname=grn_item','mywin','800','700','yes','center');return false"><i class="fa fa-search"></i></button>
                                </div>
                                <div class="col-sm-3">
                                    <label>Description</label>
                                    <input type="text" class="form-control input-sm" id="itemd" name="itemd" disabled onkeypress="keyset('rate',event);">
                                </div>
                                <div class="col-sm-1">
                                    <label>Rate</label>
                                    <input type="text" class="form-control input-sm" name="rate" id="rate" disabled onkeypress="keyset('qty',event);">
                                </div>
                                <div class="col-sm-1">
                                    <label>Ret. Qty</label>
                                    <input type="text" class="form-control input-sm" name="qty" id="qty" disabled onblur="calc_tot();" onkeypress="keyset('discount',event);">
                                </div>
                                <div class="col-sm-1">
                                    <label>Discount</label>
                                    <input type="text" class="form-control input-sm" name="discount" id="discount" value="0" disabled onblur="calc_tot();" onkeypress="keyset('additem_tmp',event);">
                                    <input type="hidden" name="discount_amt" id="discount_amt" value="0" >
                                </div>
                                <div class="col-sm-2">
                                    <label>Sub Total</label>
                                    <input type="text" class="form-control input-sm" name="subtot_new" id="subtot_new" disabled onkeypress="keyset('additem_tmp',event);">
                                </div>
                                <div class="col-sm-1">
                                    <label>&nbsp;</label>
                                    <button type="button" class="btn btn-primary btn-sm btn-block" name="additem_tmp" id="additem_tmp" onclick="add_tmp();">Add</button>
                                </div>
                            </div>
                            
                            <div class="row mt-10">
                                <div class="col-md-12">
                                    <div id="itemdetails" style="min-height: 150px; overflow-y: auto;">
                                        <!-- AJAX Grid Content -->
                                    </div>
                                </div>
                            </div>
                            
                             <!-- Another Grid? itemdetails1 in grn_details -->
                            <div class="row">
                                <div class="col-md-12">
                                     <div id="itemdetails1"></div>
                                </div>
                            </div>

                             <!-- Inventory & Credit Info -->
                            <div class="row" style="margin-top:15px;">
                                <div class="col-sm-6">
                                    <div class="form-group">
                                         <label class="col-sm-2 control-label">Remarks</label>
                                         <div class="col-sm-10">
                                            <textarea name="remarks" id="remarks" class="form-control" rows="5"></textarea>
                                         </div>
                                    </div>
                                     <div class="form-group">
                                         <div class="col-sm-12">
                                            <div id="storgrid"></div>
                                         </div>
                                    </div>
                                </div>
                                
                                <!-- Totals -->
                                <div class="col-sm-6">
                                     <div class="form-group">
                                        <label class="col-sm-8 control-label">Sub Total</label>
                                        <div class="col-sm-4">
                                            <input type="text" class="form-control input-sm text-right" name="subtot" id="subtot" disabled value="0">
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label class="col-sm-8 control-label">Discount</label>
                                        <div class="col-sm-4">
                                            <input type="text" class="form-control input-sm text-right" name="totdiscount" id="totdiscount" disabled value="0">
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label class="col-sm-8 control-label">Tax</label>
                                        <div class="col-sm-4">
                                            <input type="text" class="form-control input-sm text-right" name="tax" id="tax" disabled value="0">
                                        </div>
                                    </div>
                                     <div class="form-group">
                                        <label class="col-sm-8 control-label" style="font-size: 16px;">Invoice Total</label>
                                        <div class="col-sm-4">
                                            <input type="text" class="form-control input-sm text-right" name="invtot" id="invtot" disabled value="0" style="font-size: 16px; font-weight:bold;">
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                            
                        </form>
                    </div><!-- /.box-body -->
                </div><!-- /.box -->
            </div><!-- /.col -->
        </div><!-- /.row -->

    </section>
</div>

<script>
    // Keyboard Shortcut for Logout (Ctrl+Q)
    document.addEventListener('keydown', function(event) {
        if (event.ctrlKey && (event.key === 'q' || event.key === 'Q')) {
            event.preventDefault();
            window.location.href = 'logout.php';
        }
    });
</script>
</body>
</html>