<?php
session_start();
require_once("connectioni.php");

header('Content-Type: application/json');

$command = isset($_GET['Command']) ? $_GET['Command'] : (isset($_POST['Command']) ? $_POST['Command'] : '');

if ($command == "new_inv") {
    $company = $_SESSION['company'];
    // Generate Ref No
    // Check invpara or count s_deftrn_gin?
    // Using a simple generation logic similar to what we did for defective_item.php

    // Assuming 'DGRN' column in invpara or fallback
    $sql = "SELECT DGRN FROM invpara WHERE flag = '$company'";
    $result = mysqli_query($GLOBALS['dbinv'], $sql);
    $newRef = "";
    if ($row = mysqli_fetch_assoc($result)) {
        $newRef = "DGRN/" . $company . "/" . str_pad($row['DGRN'], 6, "0", STR_PAD_LEFT);
    } else {
        $newRef = "DGRN/" . $company . "/" . date("ymdHis");
    }

    echo json_encode([
        'status' => 'success',
        'refno' => $newRef,
        'date' => date('Y-m-d')
    ]);
    exit();
}

if ($command == "save_item") {
    try {
        $GLOBALS['dbinv']->begin_transaction();

        $refno = $_POST['txtrefno'];
        $sdate = $_POST['dtdate'];
        $cus_code = $_POST['txt_cuscode'];
        $cus_name = $_POST['txt_cusname'];
        $amount = $_POST['txt_net'];
        $remarks = $_POST['txtremark'];
        $department = $_POST['com_dep'];
        $sales_rep = $_POST['Com_rep'];

        $claim_no = $_POST['txtcl_no'];
        $defect_reason = $_POST['Cmbres'];
        $shipment = $_POST['cmbShip'];
        $refInv = $_POST['refInv'];

        $items = json_decode($_POST['items'], true);

        $company = $_SESSION['company'];
        $user = $_SESSION['CurrentUser'];

        // 1. Insert Header
        $sqlHead = "INSERT INTO s_deftrn_gin (REFNO, SDATE, CUS_CODE, CUS_NAME, AMOUNT, DEPARTMENT, SAL_EX, REMARKS, CLAM_NO, DEF_REASON, SHIPMENT, REF_INV, CANCELL, company, USER) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, '0', ?, ?)";

        $stmt = $GLOBALS['dbinv']->prepare($sqlHead);
        $stmt->bind_param("ssssssssssssss", $refno, $sdate, $cus_code, $cus_name, $amount, $department, $sales_rep, $remarks, $claim_no, $defect_reason, $shipment, $refInv, $company, $user);
        $stmt->execute();

        // 2. Insert Details
        // Table: s_deftrn_gin_itm (Assumed)
        $sqlItem = "INSERT INTO s_deftrn_gin_itm (REFNO, STK_NO, DESCRIPT, QTY, RATE, SUBTOTAL, DISC_PER, DISC_AMT) VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
        $stmtItem = $GLOBALS['dbinv']->prepare($sqlItem);

        foreach ($items as $item) {
            $stmtItem->bind_param("ssssssss", $refno, $item['itemCode'], $item['itemName'], $item['qty'], $item['rate'], $item['total'], $item['disc'], $item['discAmount']);
            $stmtItem->execute();
        }

        // Update Sequence
        $sqlSeq = "UPDATE invpara SET DGRN = DGRN + 1 WHERE flag = '$company'";
        mysqli_query($GLOBALS['dbinv'], $sqlSeq);

        $GLOBALS['dbinv']->commit();
        echo json_encode(['status' => 'success', 'message' => 'Saved Successfully']);

    } catch (Exception $e) {
        $GLOBALS['dbinv']->rollback();
        echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
    }
    exit();
}

if ($command == "get_item") {
    $itemCode = $_GET['itemCode'];
    $sql = "SELECT STK_NO, DESCRIPT, SELLING, COST, PART_NO FROM s_mas WHERE STK_NO = '$itemCode'";
    $result = mysqli_query($GLOBALS['dbinv'], $sql);
    if ($row = mysqli_fetch_assoc($result)) {
        echo json_encode(['status' => 'success', 'data' => $row]);
    } else {
        echo json_encode(['status' => 'error', 'message' => 'Item not found']);
    }
    exit();
}

if ($command == "load_claim") {
    $refno = $_GET['refno'];
    // Assuming c_clamas_gin structure based on search file
    $sql = "SELECT * FROM c_clamas_gin WHERE refno = '$refno'";
    $result = mysqli_query($GLOBALS['dbinv'], $sql);
    if ($row = mysqli_fetch_assoc($result)) {
        echo json_encode(['status' => 'success', 'data' => $row]);
    } else {
        echo json_encode(['status' => 'error', 'message' => 'Claim not found']);
    }
    exit();
}
?>