<?php
session_start();
require_once("connection_sql.php");
header('Content-Type: application/json');
date_default_timezone_set('Asia/Colombo');

$command = isset($_POST['Command']) ? $_POST['Command'] : (isset($_GET['Command']) ? $_GET['Command'] : '');

if ($command == "get_departments") {
    try {
        $sql = "select * from s_stomas where act='1' order by CODE";
        $result = $conn->query($sql);
        $data = [];
        foreach ($result as $row) {
            $data[] = [
                'code' => $row['CODE'],
                'description' => $row['DESCRIPTION']
            ];
        }
        echo json_encode(['status' => 'success', 'data' => $data]);
    } catch (Exception $e) {
        echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
    }
    exit;
}

if ($command == "search_items") {
    try {
        $from_dep = $_GET['from_dep'] ?? '';
        $query = $_GET['query'] ?? '';

        // Search in dag_item where cancel=0
        // Ideally filter by department if known, but legacy didn't strict filter in some places.
        // We will filter by department if provided to ensure we only transfer items actually IN the source department.

        $sql = "SELECT * FROM dag_item WHERE cancel='0' ";

        if (!empty($from_dep)) {
            $sql .= " AND (department = '$from_dep' OR department IS NULL OR department = '') ";
            // Allow items with no dept to be picked? Or strictly match?
            // Legacy usually allowed picking if found. Let's be safer and search broadly if not found in dept,
            // but strictly speaking a transfer should reduce stock from source.
            // For now, I'll allow searching all to avoid blocking legacy workflows where dept might be messy.
        }

        if (!empty($query)) {
            $sql .= " AND (jobno LIKE '%$query%' OR serialno LIKE '%$query%' OR refno LIKE '%$query%') ";
        }

        $sql .= " LIMIT 20";

        $result = $conn->query($sql);
        $data = [];
        foreach ($result as $row) {
            $data[] = [
                'jobno' => $row['jobno'],
                'refno' => $row['refno'],
                'serialno' => $row['serialno'],
                'marker' => $row['marker'],
                'size' => $row['size'],
                'cascost' => $row['cascost'],
                'department' => $row['department'] ?? ''
            ];
        }
        echo json_encode(['status' => 'success', 'data' => $data]);
    } catch (Exception $e) {
        echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
    }
    exit;
}

if ($command == "get_item_details") {
    try {
        $jobno = $_GET['jobno'] ?? '';
        $serialno = $_GET['serialno'] ?? '';

        $sql = "SELECT * FROM dag_item WHERE cancel='0' AND (jobno = '$jobno' OR serialno = '$serialno') LIMIT 1";
        $result = $conn->query($sql);
        $row = $result->fetch(PDO::FETCH_ASSOC);

        if ($row) {
            echo json_encode([
                'status' => 'success',
                'data' => [
                    'jobno' => $row['jobno'],
                    'refno' => $row['refno'],
                    'serialno' => $row['serialno'],
                    'marker' => $row['marker'],
                    'size' => $row['size'],
                    'cascost' => $row['cascost'],
                    'department' => $row['department']
                ]
            ]);
        } else {
            echo json_encode(['status' => 'error', 'message' => 'Item not found']);
        }
    } catch (Exception $e) {
        echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
    }
    exit;
}

if ($command == "save_transfer") {
    try {
        $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        $conn->beginTransaction();

        $input = json_decode(file_get_contents('php://input'), true);

        $sdate = $input['sdate'];
        $from_dep = $input['from_dep'];
        $to_dep = $input['to_dep'];
        $arno = $input['arno'] ?? ''; // ARN Number
        $items = $input['items'];

        if (empty($items)) {
            throw new Exception("No items to transfer.");
        }

        if ($from_dep == $to_dep) {
            throw new Exception("From and To Departments cannot be the same.");
        }

        // Generate ID
        // Format: GIN/YYMM/Random
        $ref_no = "GIN/" . date("ym") . "/" . rand(1000, 9999);

        // Fetch Dept Names
        $stmtDep = $conn->prepare("SELECT DESCRIPTION FROM s_stomas WHERE CODE = ?");
        $stmtDep->execute([$from_dep]);
        $from_desc = $stmtDep->fetchColumn();
        $stmtDep->execute([$to_dep]);
        $to_desc = $stmtDep->fetchColumn();

        // Insert Header
        // Assuming s_ginmas structure supports REQ_NO or similar for ARN, or maybe just purely reference.
        // We will start simply.
        $sqlHeader = "INSERT INTO s_ginmas (REF_NO, SDATE, DEP_FROM, DEP_TO, DEP_F_NAME, DEP_T_NAME, TYPE, cancel, company, tmp_no) 
                      VALUES (?, ?, ?, ?, ?, ?, 'DAG GIN TRANSFER', '0', ?, ?)";

        $tmp_no = uniqid();

        $conn->prepare($sqlHeader)->execute([$ref_no, $sdate, $from_dep, $to_dep, $from_desc, $to_desc, $_SESSION['company'] ?? '', $tmp_no]);

        // Process Items
        $sqlItemUpdate = "UPDATE dag_item SET department = ? WHERE jobno = ? AND serialno = ?";
        // Use s_gintrn to store transaction details
        $sqlDetailInsert = "INSERT INTO s_gintrn (REF_NO, SDATE, STK_NO, DESCRIPT, QTY, JOB_NO, BRAND, c_code) VALUES (?, ?, ?, ?, ?, ?, ?, ?)";

        $stmtUpdate = $conn->prepare($sqlItemUpdate);
        $stmtDetail = $conn->prepare($sqlDetailInsert);

        foreach ($items as $item) {
            $jobno = $item['jobno'];
            $serialno = $item['serialno'];
            $make = $item['make'];
            $refno = $item['refno'];

            // Update Department
            $stmtUpdate->execute([$to_dep, $jobno, $serialno]);

            // Insert Detail
            $stmtDetail->execute([$ref_no, $sdate, $refno, "", 1, $jobno, $make, $serialno]);

            // Log
            $logMsg = "GIN Transfer Item $jobno ($serialno) from $from_desc to $to_desc";
            $conn->query("INSERT INTO entry_log(refno, username, docname, trnType, stime, sdate) values ('$ref_no', '" . $_SESSION["CURRENT_USER"] . "', '$logMsg', 'Save', '" . date("Y-m-d H:i:s") . "', '" . date("Y-m-d") . "')");
        }

        $conn->commit();
        echo json_encode(['status' => 'success', 'message' => 'GIN Transfer Saved Successfully', 'ref_no' => $ref_no]);

    } catch (Exception $e) {
        $conn->rollBack();
        echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
    }
    exit;
}
if ($command == "pass_inv") {
    try {
        $invno = $_GET['invno'] ?? ''; // This is passed as tmp_no from search

        // Fetch Header
        // Trying to match by tmp_no first, then REF_NO
        $sql = "SELECT * FROM s_ginmas WHERE tmp_no = '$invno' OR REF_NO = '$invno'";
        $result = $conn->query($sql);
        $header = $result->fetch(PDO::FETCH_ASSOC);

        if ($header) {
            $ref_no = $header['REF_NO'];
            // Fetch Items
            // Legacy s_gintrn columns: REF_NO, STK_NO, DESCRIPT, QTY, JOB_NO, BRAND, c_code (serial)
            $sqlItems = "SELECT * FROM s_gintrn WHERE REF_NO = '$ref_no'";
            $resItems = $conn->query($sqlItems);
            $items = [];
            foreach ($resItems as $row) {
                $items[] = [
                    'jobno' => $row['JOB_NO'],
                    'refno' => $row['STK_NO'],
                    'serialno' => $row['c_code'], // stored serial here in save_transfer
                    'make' => $row['BRAND'],
                    'size' => '', // not stored in gintrn usually, but maybe?
                    'cascost' => 0 // pricing might not be stored in gintrn
                ];
            }

            echo json_encode([
                'status' => 'success',
                'data' => [
                    'header' => [
                        'invno' => $header['REF_NO'],
                        'sdate' => $header['SDATE'],
                        'from_dep' => $header['DEP_FROM'],
                        'to_dep' => $header['DEP_TO'],
                        'arno' => '', // If we stored it, retrieve it.
                        'tmpno' => $header['tmp_no']
                    ],
                    'items' => $items
                ]
            ]);
        } else {
            echo json_encode(['status' => 'error', 'message' => 'Transfer not found']);
        }
    } catch (Exception $e) {
        echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
    }
    exit;
}
?>