<?php
session_start();
require_once("connectioni.php");

if (!isset($_SESSION['company']) || $_SESSION['company'] == "") {
    exit("Please Login");
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>DAG GIN Transfer</title>

    <!-- Bootstrap 3.3.7 -->
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/css/bootstrap.min.css">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">

    <style>
        body {
            background-color: #ecf0f5;
            font-family: 'Source Sans Pro', 'Helvetica Neue', Helvetica, Arial, sans-serif;
            font-size: 14px;
        }

        .navbar-custom {
            background-color: #2c3e50;
            color: white;
            padding: 10px 20px;
            display: flex;
            justify-content: space-between;
            align-items: center;
            box-shadow: 0 2px 5px rgba(0, 0, 0, 0.1);
            margin-bottom: 20px;
        }

        .navbar-brand {
            font-size: 24px;
            font-weight: bold;
            color: white !important;
            padding: 0;
            line-height: normal;
        }

        .page-title-box {
            background: rgba(255, 255, 255, 0.1);
            padding: 8px 30px;
            border-radius: 5px;
            font-size: 18px;
            font-weight: 600;
            text-transform: uppercase;
        }

        .user-info {
            display: flex;
            align-items: center;
            gap: 15px;
        }

        .logout-btn {
            background-color: #e74c3c;
            color: white;
            padding: 6px 15px;
            border-radius: 4px;
            font-weight: 600;
            text-decoration: none !important;
        }

        .content-wrapper {
            padding: 20px;
        }

        .box {
            background: #fff;
            border-top: 3px solid #d2d6de;
            box-shadow: 0 1px 1px rgba(0, 0, 0, 0.1);
            margin-bottom: 20px;
            border-radius: 3px;
        }

        .box.box-primary {
            border-top-color: #3c8dbc;
        }

        .box-header {
            color: #444;
            border-bottom: 1px solid #f4f4f4;
            padding: 10px;
        }

        .box-body {
            padding: 20px;
        }

        .form-control {
            border-radius: 0;
            border-color: #d2d6de;
        }

        .btn {
            border-radius: 3px;
        }
    </style>

    <script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/js/bootstrap.min.js"></script>

    <script src="js/dag_gin_transfer.js"></script>
</head>

<body class="hold-transition skin-blue layout-top-nav">

    <!-- Navbar -->
    <div class="navbar-custom">
        <div class="navbar-brand">ERP SYSTEM MENU</div>
        <div class="page-title-box">DAG GIN TRANSFER</div>
        <div class="user-info">
            <span>Welcome, <span
                    class="user-name"><?php echo isset($_SESSION['CURRENT_USER']) ? $_SESSION['CURRENT_USER'] : 'User'; ?></span>
                [<?php echo isset($_SESSION['company']) ? $_SESSION['company'] : ''; ?>]</span>
            <a href="logout.php" class="logout-btn">Logout (Ctrl+Q)</a>
        </div>
    </div>

    <!-- Content -->
    <div class="content-wrapper">
        <section class="content">

            <!-- Toolbar -->
            <div class="box box-solid">
                <div class="box-body">
                    <button onclick="window.location.reload()" class="btn btn-default"><i class="fa fa-file"></i>
                        New</button>
                    <button onclick="saveTransfer()" class="btn btn-success"><i class="fa fa-save"></i> Save</button>
                    <button onclick="cancelTransfer()" class="btn btn-danger"><i class="fa fa-times"></i>
                        Cancel</button>
                    <!-- <button onclick="printTransfer()" class="btn btn-default"><i class="fa fa-print"></i> Print</button> -->
                    <a href="dag_gin_transfer_search.php" target="_blank" class="btn btn-info"><i
                            class="fa fa-search"></i>
                        Find</a>
                </div>
            </div>

            <!-- Main Form -->
            <div class="box box-primary">
                <div class="box-header with-border">
                    <h3 class="box-title">Transfer Details</h3>
                </div>
                <div class="box-body">

                    <!-- Header -->
                    <div class="row">
                        <div class="col-md-3">
                            <div class="form-group">
                                <label>Ref No</label>
                                <input type="text" id="invno" class="form-control" placeholder="Auto Generated"
                                    disabled>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label>Date</label>
                                <input type="date" id="sdate" class="form-control" value="<?php echo date('Y-m-d'); ?>">
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label>ARN No</label>
                                <div class="input-group">
                                    <input type="text" id="txtarno" class="form-control" placeholder="ARN No" disabled>
                                    <span class="input-group-btn">
                                        <button class="btn btn-default" onclick="openArnSearch()"><i
                                                class="fa fa-search"></i></button>
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-3">
                            <div class="form-group">
                                <label>From Department</label>
                                <select id="from_dep" class="form-control"></select>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label>To Department</label>
                                <select id="to_dep" class="form-control"></select>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <!-- Search / Add Item -->
                            <label>Add Item (Job No / Search)</label>
                            <div class="input-group">
                                <input type="text" id="jobno_input" class="form-control" placeholder="Scan/Type Job No">
                                <span class="input-group-btn">
                                    <button class="btn btn-primary" onclick="searchItemByCode()"><i
                                            class="fa fa-plus"></i></button>
                                    <button class="btn btn-warning" onclick="openSearchModal()"><i
                                            class="fa fa-search"></i></button>
                                </span>
                            </div>
                        </div>
                    </div>

                    <!-- Item List -->
                    <div class="table-responsive" style="margin-top: 20px;">
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr class="bg-info">
                                    <th>Job No</th>
                                    <th>Ref No</th>
                                    <th>Serial No</th>
                                    <th>Make</th>
                                    <th>Size</th>
                                    <th>Cost</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody id="item_list_body">
                                <tr>
                                    <td colspan="7" class="text-center text-muted">No items added</td>
                                </tr>
                            </tbody>
                        </table>
                    </div>

                </div>
            </div>

        </section>
    </div>

    <!-- Search Modal -->
    <div id="item_modal_search" class="modal fade" role="dialog">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                    <h4 class="modal-title">Search Items</h4>
                </div>
                <div class="modal-body">
                    <div class="form-group">
                        <div class="input-group">
                            <input type="text" id="search_input" class="form-control"
                                placeholder="Search by Job No, Serial...">
                            <span class="input-group-btn">
                                <button class="btn btn-default" onclick="searchItems()"><i
                                        class="fa fa-search"></i></button>
                            </span>
                        </div>
                    </div>
                    <div class="table-responsive">
                        <table class="table table-hover table-bordered">
                            <thead>
                                <tr>
                                    <th>Job No</th>
                                    <th>Serial No</th>
                                    <th>Make</th>
                                    <th>Size</th>
                                    <th>Ref No</th>
                                    <th>Select</th>
                                </tr>
                            </thead>
                            <tbody id="search_results"></tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script>
        document.addEventListener('keydown', function (event) {
            if (event.ctrlKey && (event.key === 'q' || event.key === 'Q')) {
                event.preventDefault();
                window.location.href = 'logout.php';
            }
        });
    </script>
</body>

</html>