<?php
session_start();

// Security check
if (empty($_SESSION['CURRENT_USER'])) {
    header('Content-Type: application/json');
    echo json_encode(['status' => 'error', 'message' => 'Please Login']);
    exit;
}

require_once("connectioni.php");

header('Content-Type: application/json');
date_default_timezone_set('Asia/Colombo');

$command = isset($_GET['Command']) ? $_GET['Command'] : '';

// 1. GEN REF NO (New Invoice)
if ($command == "new_inv") {
    $department = $_GET["department"] ?? '';

    // Generate Ref No
    $refno = "";
    $sql = "select refno from dag order by id desc limit 1";
    $result = mysqli_query($GLOBALS['dbinv'], $sql);
    if ($row = mysqli_fetch_array($result)) {
        $last_ref = $row['refno'];
        // Assuming format DAG/000001 or similar number. 
        // If simply a number:
        $num = (int) $last_ref;
        // If format is complex, we might need regex. Let's assume numeric for now or simple increment.
        // Actually, let's look at `invpara`. But since we are recreating, let's use a standard incrementor if param table isn't known for 'DAG'.
        // Let's safe-guard:
        $refno = str_pad($num + 1, 6, "0", STR_PAD_LEFT);
    } else {
        $refno = "000001";
    }

    // Uniq ID for temp items
    $uniq = uniqid();

    echo json_encode([
        'status' => 'success',
        'refno' => $refno,
        'uniq' => $uniq,
        'sdate' => date('Y-m-d')
    ]);
    exit;
}

// 2. SET JOB NO
if ($command == "setjobno") {
    $department = $_GET["department"] ?? '';
    // This logic usually fetches the next Job No for the department.
    // Simplifying for reconstruction:
    $jobno = "";
    // Verify if we can query `dag_item` for last jobno in department?
    // Let's just return success for now, or fetch from a sequence if exists.
    // The legacy JS implies it returns a 'scode' (jobno).

    echo json_encode(['status' => 'success', 'jobno' => 'JOB-New', 'refno' => $_GET['refno'] ?? '']);
    exit;
}

// 3. ADD ITEM (Add Tmp)
if ($command == "add_tmp") {

    $department = $_GET["department"] ?? '';
    $refno = $_GET["refno"] ?? '';
    $uniq = $_GET["uniq"] ?? '';
    $jobno = $_GET["jobno"] ?? '';
    $serialno = $_GET["serialno"] ?? '';
    $cuscode = $_GET["cuscode"] ?? '';
    $cusname = $_GET["cusname"] ?? '';
    $marker = $_GET["marker"] ?? ''; // Make
    $size = $_GET["size"] ?? '';
    $belt = $_GET["belt"] ?? '';
    $warranty = $_GET["warranty"] ?? '';
    $remark = $_GET["remark"] ?? '';
    $cascost = $_GET["cascost"] ?? 0;
    $dagtype = $_GET["dagtype"] ?? '';

    // Validation
    if (empty($jobno) || empty($serialno)) {
        echo json_encode(['status' => 'error', 'message' => 'JobNo or SerialNo missing']);
        exit;
    }

    $sql = "INSERT INTO dag_item (refno, jobno, serialno, cuscode, cusname, marker, size, belt, warrenty, remark, cost, uniq, flag, cancel, company, department) VALUES 
            ('$refno', '$jobno', '$serialno', '$cuscode', '$cusname', '$marker', '$size', '$belt', '$warranty', '$remark', '$cascost', '$uniq', '0', '0', '" . $_SESSION['company'] . "', '$department')";

    $result = mysqli_query($GLOBALS['dbinv'], $sql);

    if ($result) {
        echo get_item_grid_json($uniq, $refno);
    } else {
        echo json_encode(['status' => 'error', 'message' => mysqli_error($GLOBALS['dbinv'])]);
    }
    exit;
}

// 4. DELETE ITEM
if ($command == "del_item") {
    $id = $_GET['id'] ?? 0;
    $uniq = $_GET['uniq'] ?? '';
    $refno = $_GET['refno'] ?? '';

    $sql = "DELETE FROM dag_item WHERE id='$id'";
    mysqli_query($GLOBALS['dbinv'], $sql);

    echo get_item_grid_json($uniq, $refno);
    exit;
}

// 5. GET GRID
if ($command == "getdt") {
    $uniq = $_GET['uniq'] ?? '';
    $refno = $_GET['refno'] ?? '';
    echo get_item_grid_json($uniq, $refno);
    exit;
}

function get_item_grid_json($uniq, $refno)
{
    // If refno is permanent, we select by refno. If new (uniq), we select by uniq.
    // Usually legacy mixes both.
    $sql = "SELECT * FROM dag_item WHERE (uniq='$uniq' OR refno='$refno') AND cancel='0'";
    $result = mysqli_query($GLOBALS['dbinv'], $sql);

    $items = [];
    while ($row = mysqli_fetch_array($result)) {
        $items[] = [
            'id' => $row['id'],
            'jobno' => $row['jobno'],
            'serialno' => $row['serialno'],
            'marker' => $row['marker'],
            'size' => $row['size'],
            'warrenty' => $row['warrenty'], // note spelling in legacy
            'cost' => $row['cost']
        ];
    }

    return json_encode(['status' => 'success', 'items' => $items]);
}

// 6. SAVE INVOICE
if ($command == "save_item") {

    $refno = $_GET["refno"] ?? '';
    $uniq = $_GET["uniq"] ?? '';
    $sdate = $_GET["sdate"] ?? date('Y-m-d');
    $cuscode = $_GET["cuscode"] ?? '';
    $cusname = $_GET["cusname"] ?? '';
    $department = $_GET["department"] ?? '';
    $invno = $_GET["invno"] ?? '';
    $adpayment = $_GET["adpayment"] ?? 0;
    $cascost = $_GET["cascost"] ?? 0;
    $dagtype = $_GET["dagtype"] ?? ''; // Ensure this is passed

    mysqli_query($GLOBALS['dbinv'], "SET AUTOCOMMIT=0");
    mysqli_query($GLOBALS['dbinv'], "START TRANSACTION");

    $sql_status = 0;

    // Check if exists
    $sql_check = "SELECT * FROM dag WHERE refno='$refno'";
    $result_check = mysqli_query($GLOBALS['dbinv'], $sql_check);
    if (mysqli_num_rows($result_check) > 0) {
        $sql = "UPDATE dag SET sdate='$sdate', cuscode='$cuscode', cusname='$cusname', department='$department', invno='$invno', adpayment='$adpayment', cascost='$cascost' WHERE refno='$refno'";
        $result = mysqli_query($GLOBALS['dbinv'], $sql);
        if (!$result)
            $sql_status = 1;
    } else {
        $sql = "INSERT INTO dag (refno, sdate, cuscode, cusname, department, invno, adpayment, cascost, company, cancel) VALUES 
                ('$refno', '$sdate', '$cuscode', '$cusname', '$department', '$invno', '$adpayment', '$cascost', '" . $_SESSION['company'] . "', '0')";
        $result = mysqli_query($GLOBALS['dbinv'], $sql);
        if (!$result)
            $sql_status = 2;

        // Update Auto Increment logic if using parameter table, skipped for now
    }

    // Update Items Flag
    $sql = "UPDATE dag_item SET flag='1', refno='$refno' WHERE uniq='$uniq' OR refno='$refno'";
    $result = mysqli_query($GLOBALS['dbinv'], $sql);
    if (!$result)
        $sql_status = 3;

    if ($sql_status == 0) {
        mysqli_query($GLOBALS['dbinv'], "COMMIT");
        echo json_encode(['status' => 'success', 'message' => 'Saved Successfully']);
    } else {
        mysqli_query($GLOBALS['dbinv'], "ROLLBACK");
        echo json_encode(['status' => 'error', 'message' => 'Error Saving: ' . $sql_status . ' - ' . mysqli_error($GLOBALS['dbinv'])]);
    }
    exit;
}

// 7. CANCEL INVOICE
if ($command == "cancel_inv") {
    $refno = $_GET["refno"] ?? '';

    mysqli_query($GLOBALS['dbinv'], "SET AUTOCOMMIT=0");
    mysqli_query($GLOBALS['dbinv'], "START TRANSACTION");

    $sql_status = 0;

    $sql = "UPDATE dag SET cancel='1' WHERE refno='$refno'";
    $result = mysqli_query($GLOBALS['dbinv'], $sql);
    if (!$result)
        $sql_status = 1;

    $sql = "UPDATE dag_item SET cancel='1' WHERE refno='$refno'";
    $result = mysqli_query($GLOBALS['dbinv'], $sql);
    if (!$result)
        $sql_status = 2;

    if ($sql_status == 0) {
        mysqli_query($GLOBALS['dbinv'], "COMMIT");
        echo json_encode(['status' => 'success', 'message' => 'Cancelled Successfully']);
    } else {
        mysqli_query($GLOBALS['dbinv'], "ROLLBACK");
        echo json_encode(['status' => 'error', 'message' => 'Error Cancelling']);
    }
    exit;
}

// 8. PASS QUOT (Customer)
if ($command == "pass_quot") {
    $custno = $_GET['custno'] ?? '';
    // This seems to be customer search mapping?
    // Not actually quote, but customer.
    // Wait, the legacy JS `custno` function called `pass_quot` but it seemed to set `refno`, `cuscode` etc. from a response? 
    // Actually `dag_search.php` calls `custno`. So this is "Load DAG Entry".

    // Fetch DAG Header
    $sql = "SELECT * FROM dag WHERE refno='$custno'";
    $result = mysqli_query($GLOBALS['dbinv'], $sql);
    if ($row = mysqli_fetch_array($result)) {
        // Fetch Items
        $items_json = get_item_grid_json('', $row['refno']);
        $grid_data = json_decode($items_json, true);

        echo json_encode([
            'status' => 'success',
            'refno' => $row['refno'],
            'sdate' => $row['sdate'],
            'cuscode' => $row['cuscode'],
            'cusname' => $row['cusname'],
            'department' => $row['department'],
            'invno' => $row['invno'],
            'adpayment' => $row['adpayment'],
            'cascost' => $row['cascost'],
            // Grid items
            'items' => $grid_data['items']
        ]);
    } else {
        echo json_encode(['status' => 'error', 'message' => 'Entry not found']);
    }
    exit;
}

echo json_encode(['status' => 'error', 'message' => 'Invalid Command']);
?>