<?php 
session_start();
require_once("connectioni.php");
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Credit Note Auto</title>
    <!-- Bootstrap 3.3.7 -->
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/css/bootstrap.min.css">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
    
    <!-- Scripts -->
    <script type="text/javascript" src="js/credit_note_auto.js"></script>

    <script type="text/javascript">
    function load_calader(tar){
        // Native HTML5 date picker used, this is for legacy compatibility if called
    }
    
    function close_form() {
        close();
    }
    </script>

    <style>
        body {
            background-color: #ecf0f5;
            font-family: 'Source Sans Pro', 'Helvetica Neue', Helvetica, Arial, sans-serif;
            font-size: 14px;
        }
        
        /* Navbar Styles */
        .navbar-custom {
            background-color: #2c3e50;
            color: white;
            padding: 10px 20px;
            display: flex;
            justify-content: space-between;
            align-items: center;
            box-shadow: 0 2px 5px rgba(0,0,0,0.1);
            margin-bottom: 20px;
        }
        .navbar-brand {
            font-size: 24px;
            font-weight: bold;
            color: white !important;
            text-decoration: none;
            padding: 0;
            height: auto;
            line-height: normal;
        }
        .page-title-box {
            background: rgba(255, 255, 255, 0.1);
            border: 1px solid rgba(255, 255, 255, 0.2);
            padding: 8px 30px;
            border-radius: 5px;
            font-size: 18px;
            font-weight: 600;
            letter-spacing: 1px;
            text-transform: uppercase;
        }
        .user-info {
            display: flex;
            align-items: center;
            gap: 15px;
        }
        .logout-btn {
            background-color: #e74c3c;
            color: white;
            border: none;
            padding: 6px 15px;
            border-radius: 4px;
            font-weight: 600;
            transition: background 0.3s;
            text-decoration: none !important;
        }
        .logout-btn:hover {
            background-color: #c0392b;
            color: white;
        }
        .user-name {
            font-weight: bold;
        }

        /* Content Wrapper */
        .content-wrapper {
            padding: 20px;
        }
        
        /* Box/Card Styling */
        .box {
            background: #fff;
            border-top: 3px solid #d2d6de;
            margin-bottom: 20px;
            width: 100%;
            box-shadow: 0 1px 1px rgba(0,0,0,0.1);
            border-radius: 3px;
        }
        .box-primary {
            border-top-color: #3c8dbc;
        }
        .box-header {
            color: #444;
            display: block;
            padding: 10px;
            position: relative;
            border-bottom: 1px solid #f4f4f4;
        }
        .box-header .box-title {
            display: inline-block;
            font-size: 18px;
            margin: 0;
            line-height: 1;
        }
        .box-body {
            border-top-left-radius: 0;
            border-top-right-radius: 0;
            border-bottom-right-radius: 3px;
            border-bottom-left-radius: 3px;
            padding: 20px;
        }

        /* Form Controls */
        .form-control {
            border-radius: 0;
            box-shadow: none;
            border-color: #d2d6de;
        }
        .form-control:focus {
            border-color: #3c8dbc;
            box-shadow: none;
        }
        .control-label {
            font-weight: 600;
            text-align: left !important;
            padding-top: 7px;
        }
        
        /* Buttons */
        .btn {
            border-radius: 3px;
            box-shadow: none;
            border: 1px solid transparent;
        }

        /* Table Styling Overrides */
        .CSSTableGenerator table {
            width: 100%;
            border-collapse: collapse;
            background-color: #fff;
        }
        .CSSTableGenerator th {
            background-color: #3c8dbc;
            color: white;
            padding: 8px;
            text-align: left;
        }
        .CSSTableGenerator td {
            padding: 8px;
            border: 1px solid #f4f4f4;
        }
        
        /* Scrollable table containers */
        .table-scroll {
            overflow-y: auto;
            border: 1px solid #f4f4f4;
        }
    </style>
</head>
<body class="hold-transition skin-blue layout-top-nav">

    <!-- Custom Navbar -->
    <div class="navbar-custom">
        <div class="navbar-brand">ERP SYSTEM MENU</div>
        
        <div class="page-title-box">
            Credit Note Auto
        </div>
        
        <div class="user-info">
             <span>Welcome, <span class="user-name"><?php echo $_SESSION['user_name']; ?></span> [<?php echo $_SESSION['company']; ?>]</span>
            <a href="logout.php" class="logout-btn">Logout (Ctrl+Q)</a>
        </div>
    </div>

<div class="content-wrapper">
    <section class="content">

        <!-- Action Toolbar -->
        <div class="box box-solid">
            <div class="box-body">
                <a onclick="view_inv();" class="btn btn-app">
                    <i class="fa fa-eye"></i> View
                </a>
                <a onclick="save_inv();" class="btn btn-app">
                    <i class="fa fa-save"></i> Save
                </a>
                <a onclick="cancel_inv();" class="btn btn-app">
                    <i class="fa fa-times"></i> Cancel
                </a>
                <a onclick="print_inv();" class="btn btn-app">
                    <i class="fa fa-print"></i> Print
                </a>
                <a href="qty_credit_note_auto.php" class="btn btn-app">
                    <i class="fa fa-file-text-o"></i> Qty Credit Note
                </a>
                <a onclick="close_form();" class="btn btn-app">
                    <i class="fa fa-close"></i> Close
                </a>
            </div>
        </div>

        <div class="row">
            <!-- Filter & Details -->
            <div class="col-md-12">
                <div class="box box-primary">
                    <div class="box-body">
                        <form role="form" name="form1" id="form1" class="form-horizontal">
                            
                            <!-- Row 1: Filters -->
                            <div class="form-group">
                                <label class="col-sm-1 control-label">From</label>
                                <div class="col-sm-2">
                                     <input type="date" class="form-control" id="dtfrom" name="dtfrom">
                                </div>
                                
                                <label class="col-sm-1 control-label">To</label>
                                <div class="col-sm-2">
                                     <input type="date" class="form-control" id="dtto" name="dtto">
                                </div>
                                
                                <label class="col-sm-1 control-label">Brand</label>
                                <div class="col-sm-2">
                                    <select name="combo1" id="combo1" class="form-control">
                                        <option value='LASSA'>LASSA</option>
                                        <option value='FALKEN'>FALKEN</option>
                                        <option value='RADAR'>RADAR</option>
                                        <option value='SAILUN'>SAILUN</option>
                                        <option value='SUNSTAR'>SUNSTAR</option> 
                                    </select>
                                </div>
                                
                                <label class="col-sm-1 control-label">Date</label>
                                <div class="col-sm-2">
                                     <input type="date" class="form-control" id="dte_dor" name="dte_dor">
                                </div>
                            </div>
                            
                             <div class="form-group">
                                <div class="col-sm-12 text-center" id="wait_res"></div>
                            </div>

                            <!-- Table -->
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="CSSTableGenerator" id="itemdetails">
                                        <table class="table table-bordered table-striped">
                                            <tr>
                                                <th width="10%">Code</th>
                                                <th width="20%">Name</th>
                                                <th width="10%">43% Amount</th>
                                                <th width="10%">43% Qty</th>
                                                <th width="10%">40% Amount</th>
                                                <th width="10%">40% Qty</th>
                                                <th width="10%">CRN No</th>
                                                <th width="10%">Date</th>
                                                <th width="10%">Amount</th>
                                            </tr>
                                        </table>
                                     </div>
                                </div>
                             </div>
                            
                        </form>
                    </div><!-- /.box-body -->
                </div><!-- /.box -->
            </div><!-- /.col -->
        </div><!-- /.row -->

    </section>
</div>

<script>
    // Keyboard Shortcut for Logout (Ctrl+Q)
    document.addEventListener('keydown', function(event) {
        if (event.ctrlKey && (event.key === 'q' || event.key === 'Q')) {
            event.preventDefault();
            window.location.href = 'logout.php';
        }
    });
</script>
</body>
</html>
