<?php
session_start();
require_once("connection_sql.php");
header('Content-Type: application/json');
date_default_timezone_set('Asia/Colombo');

$command = isset($_POST['Command']) ? $_POST['Command'] : (isset($_GET['Command']) ? $_GET['Command'] : '');

if ($command == "get_list") {
    try {
        // Logic from original: (flag ='5' or flag ='6') and cancel='0' and invno is null
        $sql = "select * from dag_item WHERE (flag ='5' or flag ='6') and cancel='0' and invno is null";

        // Filter by company if needed
        // if(isset($_SESSION['company']) && $_SESSION['company'] != "" && $_SESSION['company'] != "ALL") {
        //     $sql .= " and company='".$_SESSION['company']."'";
        // }

        $sql .= " ORDER BY id DESC";

        $result = $conn->query($sql);

        $data = [];
        $i = 1;

        foreach ($result as $row) {

            // History Count Logic
            $sql1 = "Select count(*) as count from dag_item  where cancel='0'  and  serialno='" . $row['serialno'] . "' group by  serialno asc";
            $result_1 = $conn->query($sql1);
            $row_1 = $result_1->fetch();
            $history_count = $row_1['count'] ?? 0;

            // Calculate Total (Logic from original: repair is just a field, total is total)
            // Original UI displayed: amount, repair, total.

            $status_html = "";
            $status_bg = "";
            // Status Logic (Consistent with other lists)
            if ($row['reject'] == '0') {
                if ($row['flag'] == '5') {
                    $status_html = "COMPLETE";
                    $status_bg = "#1ef51e";
                } else if ($row['flag'] == '6') {
                    $status_html = "ONHAND TRANSFER PENDING";
                    $status_bg = "#eabb3d";
                }
            } else {
                $status_html = "REJECTED";
                $status_bg = "red";
            }


            $data[] = [
                'id' => $row['id'],
                'jobno' => $row['jobno'],
                'refno' => $row['refno'],
                'sdate' => $row['sdate'],
                'cusname' => $row['cusname'],
                'belt' => $row['belt'],
                'marker' => $row['marker'],
                'size' => $row['size'],
                'serialno' => $row['serialno'],
                'warrenty' => $row['warrenty'],
                'adpayment' => $row['adpayment'],
                'cascost' => $row['cascost'],
                'cost' => $row['cost'], // Admin only check in UI
                'amount' => $row['amount'],
                'repair' => $row['repair'],
                'total' => number_format($row['total'], 2),
                'pro_date' => $row['pro_date'],
                'remark' => $row['remark'],
                'history_count' => $history_count,
                'status_html' => $status_html,
                'status_bg' => $status_bg,
                // Raw values for modal
                'raw_total' => $row['total'],
                'regdate' => $row['sdate'] // mapped for modal
            ];
            $i++;
        }

        echo json_encode(['status' => 'success', 'data' => $data]);

    } catch (Exception $e) {
        echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
    }
    exit;
}

if ($command == "sendproduction") {
    try {
        $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        $conn->beginTransaction();

        $refno = $_POST['refno'] ?? '';
        $serialno = $_POST['serialno'] ?? '';

        // Update to Flag 1 (Production)
        $sql = "UPDATE dag_item set flag='1', com_date='" . date("Y-m-d") . "' where refno='" . $refno . "' and serialno='" . $serialno . "' and cancel='0'";
        $conn->query($sql);

        $sqllog = "insert into entry_log(refno, username, docname, trnType, stime, sdate) values ('" . trim($refno) . "', '" . $_SESSION["CURRENT_USER"] . "', 'SEND COMPLETE LIST TO PRODUCTION', 'Save', '" . date("Y-m-d H:i:s") . "', '" . date("Y-m-d") . "')";
        $conn->query($sqllog);

        $conn->commit();
        echo json_encode(['status' => 'success', 'message' => 'SEND TO PRODUCTION']);

    } catch (Exception $e) {
        $conn->rollBack();
        echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
    }
    exit;
}

if ($command == "sendreject") {
    try {
        $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        $conn->beginTransaction();

        $refno = $_POST['refno'] ?? '';
        $serialno = $_POST['serialno'] ?? '';

        // Update Reject = 1
        $sql = "UPDATE dag_item set reject='1' where refno='" . $refno . "' and serialno='" . $serialno . "' and cancel='0'";
        $conn->query($sql);

        $sqllog = "insert into entry_log(refno, username, docname, trnType, stime, sdate) values ('" . trim($refno) . "', '" . $_SESSION["CURRENT_USER"] . "', 'SEND COMPLETE LIST TO REJECT', 'Save', '" . date("Y-m-d H:i:s") . "', '" . date("Y-m-d") . "')";
        $conn->query($sqllog);

        $conn->commit();
        echo json_encode(['status' => 'success', 'message' => 'SEND TO REJECT']);

    } catch (Exception $e) {
        $conn->rollBack();
        echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
    }
    exit;
}
?>