<?php
session_start();
require_once("connectioni.php");
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Complete List</title>
    
    <!-- Bootstrap 3.3.7 -->
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/css/bootstrap.min.css">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
    <!-- DataTables -->
    <link rel="stylesheet" href="https://cdn.datatables.net/1.10.19/css/dataTables.bootstrap.min.css">
    <link rel="stylesheet" href="https://cdn.datatables.net/buttons/1.5.2/css/buttons.bootstrap.min.css">
    
    <style>
        body {
            background-color: #ecf0f5;
            font-family: 'Source Sans Pro', 'Helvetica Neue', Helvetica, Arial, sans-serif;
            font-size: 14px;
        }
        
        .navbar-custom {
            background-color: #2c3e50;
            color: white;
            padding: 10px 20px;
            display: flex;
            justify-content: space-between;
            align-items: center;
            box-shadow: 0 2px 5px rgba(0,0,0,0.1);
            margin-bottom: 20px;
        }
        .navbar-brand { font-size: 24px; font-weight: bold; color: white !important; padding: 0; line-height: normal; }
        .page-title-box { background: rgba(255, 255, 255, 0.1); padding: 8px 30px; border-radius: 5px; font-size: 18px; font-weight: 600; text-transform: uppercase; }
        .user-info { display: flex; align-items: center; gap: 15px; }
        .logout-btn { background-color: #e74c3c; color: white; padding: 6px 15px; border-radius: 4px; font-weight: 600; text-decoration: none !important; }
        
        .content-wrapper { padding: 20px; }
        .box { background: #fff; border-top: 3px solid #d2d6de; box-shadow: 0 1px 1px rgba(0,0,0,0.1); margin-bottom: 20px; border-radius: 3px; }
        .box.box-primary { border-top-color: #3c8dbc; }
        .box-header { color: #444; border-bottom: 1px solid #f4f4f4; padding: 10px; }
        .box-body { padding: 20px; }
        
        .modal-header { background: #3c8dbc; color: white; border-top-left-radius: 4px; border-top-right-radius: 4px; }
        .modal-title { font-weight: bold; }
        .close { color: white; opacity: 0.8; }
        
        .detail-row {
            margin-bottom: 10px;
            border-bottom: 1px solid #eee;
            padding-bottom: 5px;
        }
        .detail-label { font-weight: bold; color: #555; }
    </style>

    <script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/js/bootstrap.min.js"></script>
    
    <!-- DataTables Scripts -->
    <script src="https://cdn.datatables.net/1.10.19/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/1.10.19/js/dataTables.bootstrap.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/1.5.2/js/dataTables.buttons.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/1.5.2/js/buttons.bootstrap.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/1.5.2/js/buttons.print.min.js"></script>
    
    <script src="js/comp_list.js"></script>
</head>
<body class="hold-transition skin-blue layout-top-nav">

    <!-- Navbar -->
    <div class="navbar-custom">
        <div class="navbar-brand">ERP SYSTEM MENU</div>
        <div class="page-title-box">COMPLETE LIST</div>
        <div class="user-info">
            <span>Welcome, <span class="user-name"><?php echo isset($_SESSION['CURRENT_USER']) ? $_SESSION['CURRENT_USER'] : 'User'; ?></span> [<?php echo isset($_SESSION['company']) ? $_SESSION['company'] : ''; ?>]</span>
            <a href="logout.php" class="logout-btn">Logout (Ctrl+Q)</a>
        </div>
    </div>

    <div class="content-wrapper">
        <section class="content">
            <div class="box box-primary">
                <div class="box-header with-border">
                    <h3 class="box-title">Complete Items List</h3>
                </div>
                <div class="box-body">
                    <div class="table-responsive">
                        <table id="example" class="table table-striped table-bordered table-hover" style="width:100%">
                            <thead>
                                <tr class="danger">
                                    <th>#</th>
                                    <th>JOB NO</th>
                                    <th>INV NO</th>
                                    <th>DATE</th>
                                    <th>CUSTOMER</th>
                                    <th>BELT</th>
                                    <th>MAKE</th>
                                    <th>SIZE</th>
                                    <th>SERIAL NO</th>
                                    <th>WARRENTY</th>
                                    <th>AD PAY</th>
                                    <th>CASING COST</th>
                                    <th>COST</th>
                                    <th>AMOUNT</th>
                                    <th>REPAIR</th>
                                    <th>TOTAL</th>
                                    <th>PRO DATE</th>
                                    <th>REMARK</th>
                                    <th>HISTORY</th>
                                    <th>ACTION</th>
                                </tr>
                            </thead>
                            <tbody></tbody>
                        </table>
                    </div>
                </div>
            </div>
        </section>
    </div>

    <!-- Details Modal -->
    <div class="modal fade" id="exampleModal" tabindex="-1" role="dialog">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                    <h4 class="modal-title">Item Details & Actions</h4>
                </div>
                <div class="modal-body">
                    <form id="detailForm">
                        <input type="hidden" id="current_refno">
                        <input type="hidden" id="current_serialno">
                        <input type="hidden" id="id">
                        
                        <div class="row">
                            <div class="col-md-6 detail-row"><span class="detail-label">Job No:</span> <input type="text" id="jobno" class="form-control" readonly></div>
                            <div class="col-md-6 detail-row"><span class="detail-label">Ref No:</span> <input type="text" id="refno" class="form-control" readonly></div>
                            <div class="col-md-6 detail-row"><span class="detail-label">Customer:</span> <input type="text" id="cusname" class="form-control" readonly></div>
                            <div class="col-md-6 detail-row"><span class="detail-label">Reg Date:</span> <input type="text" id="regdate" class="form-control" readonly></div>
                            <div class="col-md-6 detail-row"><span class="detail-label">Make:</span> <input type="text" id="make" class="form-control" readonly></div>
                            <div class="col-md-6 detail-row"><span class="detail-label">Size:</span> <input type="text" id="size" class="form-control" readonly></div>
                            <div class="col-md-6 detail-row"><span class="detail-label">Serial No:</span> <input type="text" id="serialno" class="form-control" readonly></div>
                            <div class="col-md-6 detail-row"><span class="detail-label">Warranty:</span> <input type="text" id="warrenty" class="form-control" readonly></div>
                             <div class="col-md-6 detail-row"><span class="detail-label">Pro Date:</span> <input type="text" id="prodate" class="form-control" readonly></div>
                            <div class="col-md-6 detail-row"><span class="detail-label">Total Amount:</span> <input type="text" id="totalamou" class="form-control" readonly></div>
                           
                        </div>
                        
                        <div class="alert alert-info">
                            <strong>Note:</strong> Spare/Worker details view is currently unavailable.
                        </div>

                    </form>
                </div>
                <div class="modal-footer">
                     <button type="button" class="btn btn-warning pull-left" onclick="sendreject()"><i class="fa fa-ban"></i> Send to REJECT</button>
                    <button type="button" class="btn btn-success" onclick="sendproduction()"><i class="fa fa-save"></i> Send to PRODUCTION</button>
                    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>

    <script>
        document.addEventListener('keydown', function(event) {
            if (event.ctrlKey && (event.key === 'q' || event.key === 'Q')) {
                event.preventDefault();
                window.location.href = 'logout.php';
            }
        });
    </script>
</body>
</html>