<?php 
session_start();
require_once("connectioni.php");
date_default_timezone_set('Asia/Colombo');

if ($_SESSION['company'] == "") { 
    exit("Please Login");
}
if ($_SESSION['CURRENT_USER'] == "") { 
    exit("Please Login");
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Battery Claim</title>
    <!-- Bootstrap 3.3.7 -->
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/css/bootstrap.min.css">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
    
    <!-- Scripts -->
    <script type="text/javascript" src="js/battery_claim_data.js"></script>
    <script type="text/javascript" src="js/get_cat_description.js"></script>

    <script type="text/javascript">
    function load_calader(tar){
        // Native HTML5 date picker used, shim for compatibility
    }
    
    function close_form() {
        close();
    }
    
    // Window Popup Helper
    function NewWindow(mypage,myname,w,h,scroll,pos){
        if(pos=="random"){LeftPosition=(screen.width)?Math.floor(Math.random()*(screen.width-w)):100;TopPosition=(screen.height)?Math.floor(Math.random()*((screen.height-h)-75)):100;}
        if(pos=="center"){LeftPosition=(screen.width)?(screen.width-w)/2:100;TopPosition=(screen.height)?(screen.height-h)/2:100;}
        else if((pos!="center" && pos!="random") || pos==null){LeftPosition=0;TopPosition=20}
        settings='width='+w+',height='+h+',top='+TopPosition+',left='+LeftPosition+',scrollbars='+scroll+',location=no,directories=no,status=no,menubar=no,toolbar=no,resizable=no';
        win=window.open(mypage,myname,settings);
    }
    
    function NewWindow1(mypage,myname,w,h,scroll,pos){
        mypage=mypage+'&cus_id='+document.getElementById("txt_cuscode").value;
        if(pos=="random"){LeftPosition=(screen.width)?Math.floor(Math.random()*(screen.width-w)):100;TopPosition=(screen.height)?Math.floor(Math.random()*((screen.height-h)-75)):100;}
        if(pos=="center"){LeftPosition=(screen.width)?(screen.width-w)/2:100;TopPosition=(screen.height)?(screen.height-h)/2:100;}
        else if((pos!="center" && pos!="random") || pos==null){LeftPosition=0;TopPosition=20}
        settings='width='+w+',height='+h+',top='+TopPosition+',left='+LeftPosition+',scrollbars='+scroll+',location=no,directories=no,status=no,menubar=no,toolbar=no,resizable=no';
        win=window.open(mypage,myname,settings);
    }
    </script>

    <style>
        body {
            background-color: #ecf0f5;
            font-family: 'Source Sans Pro', 'Helvetica Neue', Helvetica, Arial, sans-serif;
            font-size: 14px;
        }
        
        /* Navbar Styles */
        .navbar-custom {
            background-color: #2c3e50;
            color: white;
            padding: 10px 20px;
            display: flex;
            justify-content: space-between;
            align-items: center;
            box-shadow: 0 2px 5px rgba(0,0,0,0.1);
            margin-bottom: 20px;
        }
        .navbar-brand {
            font-size: 24px;
            font-weight: bold;
            color: white !important;
            text-decoration: none;
            padding: 0;
            height: auto;
            line-height: normal;
        }
        .page-title-box {
            background: rgba(255, 255, 255, 0.1);
            border: 1px solid rgba(255, 255, 255, 0.2);
            padding: 8px 30px;
            border-radius: 5px;
            font-size: 18px;
            font-weight: 600;
            letter-spacing: 1px;
            text-transform: uppercase;
        }
        .user-info {
            display: flex;
            align-items: center;
            gap: 15px;
        }
        .logout-btn {
            background-color: #e74c3c;
            color: white;
            border: none;
            padding: 6px 15px;
            border-radius: 4px;
            font-weight: 600;
            transition: background 0.3s;
            text-decoration: none !important;
        }
        .logout-btn:hover {
            background-color: #c0392b;
            color: white;
        }
        .user-name {
            font-weight: bold;
        }

        /* Content Wrapper */
        .content-wrapper {
            padding: 20px;
        }
        
        /* Box/Card Styling */
        .box {
            background: #fff;
            border-top: 3px solid #d2d6de;
            margin-bottom: 20px;
            width: 100%;
            box-shadow: 0 1px 1px rgba(0,0,0,0.1);
            border-radius: 3px;
        }
        .box-primary { border-top-color: #3c8dbc; }
        .box-success { border-top-color: #00a65a; }
        .box-warning { border-top-color: #f39c12; }
        .box-danger  { border-top-color: #dd4b39; }
        
        .box-header {
            color: #444;
            display: block;
            padding: 10px;
            position: relative;
            border-bottom: 1px solid #f4f4f4;
            background-color: #f9fafc;
        }
        .box-header .box-title {
            display: inline-block;
            font-size: 18px;
            margin: 0;
            line-height: 1;
            font-weight: 600;
        }
        .box-body {
            border-top-left-radius: 0;
            border-top-right-radius: 0;
            border-bottom-right-radius: 3px;
            border-bottom-left-radius: 3px;
            padding: 20px;
        }

        /* Form Controls */
        .form-control {
            border-radius: 0;
            box-shadow: none;
            border-color: #d2d6de;
        }
        .form-control:focus {
            border-color: #3c8dbc;
            box-shadow: none;
        }
        .form-control[disabled], .form-control[readonly], fieldset[disabled] .form-control {
            background-color: #eee;
        }

        /* Buttons */
        .btn {
            border-radius: 3px;
            box-shadow: none;
            border: 1px solid transparent;
        }
        .btn-app {
            border-radius: 3px;
            position: relative;
            padding: 15px 5px;
            margin: 0 0 10px 10px;
            min-width: 80px;
            height: 60px;
            text-align: center;
            color: #666;
            border: 1px solid #ddd;
            background-color: #f4f4f4;
            font-size: 12px;
        }
        .btn-app > .fa, .btn-app > .glyphicon, .btn-app > .ion {
            font-size: 20px;
            display: block;
            margin-bottom: 10px;
        }
        .btn-app:hover {
            background: #f4f4f4;
            color: #444;
            border-color: #aaa;
        }
        
        /* Battery Test Table */
        .test-table th {
            text-align: center;
            background-color: #2c3e50;
            color: white;
            font-size: 12px;
            padding: 8px;
        }
        .test-table td {
            padding: 5px;
        }
        .test-table input, .test-table select {
            width: 100%;
            text-align: center;
            height: 30px;
            font-size: 12px;
        }
        
        textarea {
            resize: vertical;
        }
    </style>
</head>
<body class="hold-transition skin-blue layout-top-nav">

    <!-- Custom Navbar -->
    <div class="navbar-custom">
        <div class="navbar-brand">ERP SYSTEM MENU</div>
        
        <div class="page-title-box">
            Battery Claim
        </div>
        
        <div class="user-info">
             <span>Welcome, <span class="user-name"><?php echo $_SESSION['user_name']; ?></span> [<?php echo $_SESSION['company']; ?>]</span>
            <a href="logout.php" class="logout-btn">Logout (Ctrl+Q)</a>
        </div>
    </div>

<div class="content-wrapper">
    <section class="content">

        <!-- Action Toolbar -->
        <div class="box box-solid">
            <div class="box-body">
                <a onclick="new_inv1();" class="btn btn-app">
                    <i class="fa fa-plus"></i> New
                </a>
                <a onclick="save_inv1();" class="btn btn-app">
                    <i class="fa fa-save"></i> Save
                </a>
                <a onclick="cancel_inv();" class="btn btn-app">
                    <i class="fa fa-ban"></i> Cancel
                </a>
                <a onclick="print_inv();" class="btn btn-app">
                    <i class="fa fa-print"></i> Print
                </a>
                <a onclick="close_form();" class="btn btn-app">
                    <i class="fa fa-close"></i> Close
                </a>
            </div>
        </div>

        <form role="form" name="form1" id="form1">
            <input type="hidden" name="txt_cuscode" id="txt_cuscode" value="" />
            <input type="hidden" name="c_subcode" id="c_subcode" value="" />

            <div class="row">
                <!-- Left Column: General & Customer -->
                <div class="col-md-6">
                    <div class="box box-primary">
                        <div class="box-header with-border">
                            <h3 class="box-title">General Information</h3>
                        </div>
                        <div class="box-body">
                            <div class="form-group row">
                                <label class="col-sm-2 control-label">Ref No</label>
                                <div class="col-sm-4">
                                    <div class="input-group">
                                        <input type="text" disabled class="form-control" name="txtrefno" id="txtrefno">
                                        <span class="input-group-btn">
                                            <button class="btn btn-default" type="button" onclick="NewWindow('search_claim_item.php?stname=claim_item_b', 'mywin', '800', '700', 'yes', 'center');return false"><i class="fa fa-search"></i></button>
                                        </span>
                                    </div>
                                </div>
                                <label class="col-sm-2 control-label">Ent Date</label>
                                <div class="col-sm-4">
                                    <input type="date" class="form-control" name="txtentdate" id="txtentdate" value="<?php echo date("Y-m-d"); ?>" onblur="caldt();">
                                </div>
                            </div>
                            
                            <div class="form-group row">
                                <label class="col-sm-2 control-label">Sold(Dlr)</label>
                                <div class="col-sm-4">
                                     <input type="date" class="form-control" name="DTPicker_ddate" id="DTPicker_ddate" value="<?php echo date("Y-m-d"); ?>" onblur="caldt();">
                                </div>
                                <div class="col-sm-6">
                                    <div class="checkbox">
                                        <label>
                                            <input type="checkbox" name="Prn_md" id="Prn_md"> Print To Managment
                                        </label>
                                    </div>
                                </div>
                            </div>

                             <div class="form-group row">
                                <label class="col-sm-2 control-label">Claim No</label>
                                <div class="col-sm-4">
                                    <input type="text" class="form-control" name="txtcl_no" id="txtcl_no">
                                </div>
                                <label class="col-sm-2 control-label">Rec Date</label>
                                <div class="col-sm-4">
                                     <input type="date" class="form-control" name="DTPicker_recdate" id="DTPicker_recdate" value="<?php echo date("Y-m-d"); ?>" onblur="caldt();">
                                </div>
                            </div>
                            
                            <div class="form-group row">
                                <label class="col-sm-2 control-label">Sold(Cus)</label>
                                <div class="col-sm-4">
                                     <input type="date" class="form-control" name="DTPicker_cdate" id="DTPicker_cdate" value="<?php echo date("Y-m-d"); ?>" onblur="caldt();">
                                </div>
                                <div class="col-sm-6">
                                     <div class="checkbox">
                                        <label>
                                            <input type="checkbox" name="Check1" id="Check1"> Date ok
                                        </label>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="form-group row">
                                <label class="col-sm-2 control-label">Period (M)</label>
                                <div class="col-sm-2">
                                     <label style="font-weight:normal; font-size:12px;">To Dealer</label>
                                     <input type="text" class="form-control" id="TXTmon_dea" name="TXTmon_dea">
                                </div>
                                <div class="col-sm-2">
                                     <label style="font-weight:normal; font-size:12px;">To Cus</label>
                                     <input type="text" class="form-control" id="txtmon_cus" name="txtmon_cus">
                                </div>
                            </div>

                        </div>
                    </div>
                </div>
                
                 <div class="col-md-6">
                    <div class="box box-info">
                        <div class="box-header with-border">
                            <h3 class="box-title">Agent & Customer Details</h3>
                        </div>
                        <div class="box-body">
                             <div class="form-group row">
                                <label class="col-sm-2 control-label">Agent</label>
                                <div class="col-sm-3">
                                    <input type="text" disabled class="form-control" name="txtag_code" id="txtag_code">
                                </div>
                                <div class="col-sm-5">
                                    <input type="text" disabled class="form-control" name="txtag_name" id="txtag_name">
                                </div>
                                <div class="col-sm-2">
                                     <button class="btn btn-default" type="button" name="searchcust" id="searchcust" onclick="NewWindow('serach_customer.php?stname=item_claim', 'mywin', '800', '700', 'yes', 'center');return false"><i class="fa fa-search"></i></button>
                                </div>
                            </div>
                            
                            <div class="form-group row">
                                <label class="col-sm-2 control-label">Customer</label>
                                <div class="col-sm-10">
                                    <input type="text" class="form-control" name="txtcus_name" id="txtcus_name">
                                </div>
                            </div>
                            
                             <div class="form-group row">
                                <label class="col-sm-2 control-label">Agnt Addr</label>
                                <div class="col-sm-10">
                                    <input type="text" disabled class="form-control" name="txtagadd" id="txtagadd">
                                </div>
                            </div>
                             <div class="form-group row">
                                <label class="col-sm-2 control-label">Cus Addr</label>
                                <div class="col-sm-10">
                                    <input type="text" class="form-control" name="txtcus_add" id="txtcus_add">
                                </div>
                            </div>
                        </div>
                    </div>
                    
                     <div class="box box-success">
                        <div class="box-header with-border">
                            <h3 class="box-title">Item Details</h3>
                        </div>
                        <div class="box-body">
                             <div class="form-group row">
                                <label class="col-sm-2 control-label">Stk No</label>
                                <div class="col-sm-4">
                                     <div class="input-group">
                                        <input type="text" disabled class="form-control" name="txtstk_no" id="txtstk_no">
                                        <span class="input-group-btn">
                                            <button class="btn btn-default" type="button" name="searchcust2" id="searchcust2" onclick="NewWindow('serach_item_claim.php?stname=claim_item', 'mywin', '800', '700', 'yes', 'center');return false"><i class="fa fa-search"></i></button>
                                        </span>
                                    </div>
                                </div>
                                <label class="col-sm-2 control-label">Desc</label>
                                <div class="col-sm-4">
                                    <input type="text" disabled class="form-control" name="txtdes" id="txtdes">
                                </div>
                            </div>
                            <div class="form-group row">
                                <label class="col-sm-2 control-label">Brand</label>
                                <div class="col-sm-4">
                                    <input type="text" disabled class="form-control" name="txtbrand" id="txtbrand">
                                </div>
                                <label class="col-sm-2 control-label">Batch No</label>
                                <div class="col-sm-4">
                                    <input type="text" class="form-control" name="txtpatt" id="txtpatt">
                                </div>
                            </div>
                             <div class="form-group row">
                                <label class="col-sm-2 control-label">Serial No</label>
                                <div class="col-sm-10">
                                    <input type="text" class="form-control" name="txtseri_no" id="txtseri_no">
                                </div>
                            </div>
                        </div>
                    </div>
                 </div>
            </div>

            <!-- Battery Test Matrix -->
            <div class="row">
                <div class="col-md-12">
                    <div class="box box-warning">
                        <div class="box-header with-border">
                            <h3 class="box-title">Battery Test Results</h3>
                        </div>
                        <div class="box-body table-responsive">
                            <table class="table table-bordered test-table">
                                <tr>
                                    <th width="20%">Type</th>
                                    <th width="10%">Cell-1</th>
                                    <th width="10%">Cell-2</th>
                                    <th width="10%">Cell-3</th>
                                    <th width="10%">Cell-4</th>
                                    <th width="10%">Cell-5</th>
                                    <th width="10%">Cell-6</th>
                                    <th width="10%">OCV</th>
                                    <th width="10%">CCA</th>
                                </tr>
                                <tr>
                                    <td><strong>Electrolite Level</strong></td>
                                    <td><select id="t11" name="t11" class="form-control input-sm"><option value ="Good">Good</option><option value ="Bad">Bad</option></select></td>
                                    <td><select id="t12" name="t12" class="form-control input-sm"><option value ="Good">Good</option><option value ="Bad">Bad</option></select></td>
                                    <td><select id="t13" name="t13" class="form-control input-sm"><option value ="Good">Good</option><option value ="Bad">Bad</option></select></td>
                                    <td><select id="t14" name="t14" class="form-control input-sm"><option value ="Good">Good</option><option value ="Bad">Bad</option></select></td>
                                    <td><select id="t15" name="t15" class="form-control input-sm"><option value ="Good">Good</option><option value ="Bad">Bad</option></select></td>
                                    <td><select id="t16" name="t16" class="form-control input-sm"><option value ="Good">Good</option><option value ="Bad">Bad</option></select></td>
                                    <td><input name="t17" id="t17" type="text" class="form-control input-sm"/></td>
                                    <td><input name="t18" id="t18" type="text" class="form-control input-sm"/></td>
                                </tr>
                                <tr>
                                    <td><strong>Initial Level SPG</strong></td>
                                    <td><input name="t21" id="t21" type="text" class="form-control input-sm"/></td>
                                    <td><input name="t22" id="t22" type="text" class="form-control input-sm"/></td>
                                    <td><input name="t23" id="t23" type="text" class="form-control input-sm"/></td>
                                    <td><input name="t24" id="t24" type="text" class="form-control input-sm"/></td>
                                    <td><input name="t25" id="t25" type="text" class="form-control input-sm"/></td>
                                    <td><input name="t26" id="t26" type="text" class="form-control input-sm"/></td>
                                    <td><input name="t27" id="t27" type="text" class="form-control input-sm"/></td>
                                    <td><input name="t28" id="t28" type="text" class="form-control input-sm"/></td>
                                </tr>
                                <tr>
                                    <td><strong>After Charging SPG</strong></td>
                                    <td><input name="t31" id="t31" type="text" class="form-control input-sm"/></td>
                                    <td><input name="t32" id="t32" type="text" class="form-control input-sm"/></td>
                                    <td><input name="t33" id="t33" type="text" class="form-control input-sm"/></td>
                                    <td><input name="t34" id="t34" type="text" class="form-control input-sm"/></td>
                                    <td><input name="t35" id="t35" type="text" class="form-control input-sm"/></td>
                                    <td><input name="t36" id="t36" type="text" class="form-control input-sm"/></td>
                                    <td><input name="t37" id="t37" type="text" class="form-control input-sm"/></td>
                                    <td><input name="t38" id="t38" type="text" class="form-control input-sm"/></td>
                                </tr>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="row">
                <!-- Observations and Refund -->
                <div class="col-md-6">
                     <div class="box box-danger">
                        <div class="box-header with-border">
                            <h3 class="box-title">Observation & Report</h3>
                        </div>
                        <div class="box-body">
                            <div class="form-group">
                                <label>Type of Defects</label>
                                <select name="Combo1" id="Combo1" class="form-control" onchange="setord();">
                                    <?php
                                    $sql = "select tc_ob from c_clamas where type ='BAT' group by tc_ob order by tc_ob";
                                    $result = mysqli_query($GLOBALS['dbinv'], $sql);
                                    while ($row = mysqli_fetch_array($result)) {
                                        echo "<option value='" . $row["tc_ob"] . "'>" . $row["tc_ob"] . "</option>";
                                    }
                                    ?>
                                </select>
                            </div>
                             <div class="form-group">
                                <label>Technical Observation</label>
                                <textarea name="txttc_ob" id="txttc_ob" class="form-control" rows="3"></textarea>
                             </div>
                             
                             <div class="form-group row">
                                 <label class="col-sm-3 control-label">Re Issue</label>
                                 <div class="col-sm-9">
                                    <input name="rissue" id="rissue" type="text" class="form-control"/>
                                 </div>
                             </div>
                             
                              <div class="form-group row">
                                 <label class="col-sm-3 control-label">Claim</label>
                                 <div class="col-sm-4">
                                     <select name="Cmb_refund" id="Cmb_refund" class="form-control" onchange="show_claim();">
                                        <option value=''>Select</option>
                                        <option value='Recommended'>Recommended</option>
                                        <option value='Not Recommended'>Not Recommended</option>
                                        <option value='Pending'>Pending</option>                        
                                    </select>
                                 </div>
                                 <div class="col-sm-5">
                                      <div id="claim">
                                        <input type="hidden" class="form-control" value="Claim" id="cmb_cl_type" name="cmb_cl_type" disabled="disabled"/>
                                    </div>
                                 </div>
                             </div>
                             
                              <div class="form-group row">
                                 <label class="col-sm-3 control-label">Commercialy</label>
                                 <div class="col-sm-4">
                                      <div id="commerc">
                                        <input type="hidden" class="form-control" value="Commercialy" id="cmb_comm" name="cmb_comm" disabled="disabled"/>
                                    </div>
                                 </div>
                                 <div class="col-sm-5">
                                     <div id="commercialy_sub">
                                        <input type="hidden" class="form-control" value="Commercialy" id="cmb_c_Cl_type" name="cmb_c_Cl_type" disabled="disabled"/>
                                    </div>
                                    <div id="commercialy_ref">
                                        <input type="hidden" name="txtadd_ref1" id="txtadd_ref1" value="" />
                                        <input type="hidden" name="txtadd_ref2" id="txtadd_ref2" value="" />
                                    </div>
                                 </div>
                             </div>
                        </div>
                     </div>
                     
                     <div class="box box-default">
                        <div class="box-header with-border">
                            <h3 class="box-title">Images</h3>
                        </div>
                        <div class="box-body">
                             <div class="form-group row">
                                 <label class="col-sm-3 control-label">Image 1</label>
                                 <div class="col-sm-9">
                                     <button class="btn btn-primary btn-sm" name="idcopy" id="idcopy" onClick="NewWindow('upload_image.php?cou=image7','mywin','700','200','yes','center');return false">Upload</button>
                                     <button class="btn btn-info btn-sm" name="idcopy2" id="idcopy2" onclick="NewWindow1('display_image.php?cou=image7','mywin','900','800','yes','center');return false">Display</button>
                                 </div>
                             </div>
                             <div class="form-group row">
                                 <label class="col-sm-3 control-label">Image 2</label>
                                 <div class="col-sm-9">
                                     <button class="btn btn-primary btn-sm" name="idcopy" id="idcopy" onClick="NewWindow('upload_image.php?cou=image8','mywin','700','200','yes','center');return false">Upload</button>
                                     <button class="btn btn-info btn-sm" name="idcopy2" id="idcopy2" onclick="NewWindow1('display_image.php?cou=image8','mywin','900','800','yes','center');return false">Display</button>
                                 </div>
                             </div>
                             <div class="form-group row">
                                 <label class="col-sm-3 control-label">Image 3</label>
                                 <div class="col-sm-9">
                                     <button class="btn btn-primary btn-sm" name="idcopy" id="idcopy" onClick="NewWindow('upload_image.php?cou=image9','mywin','700','200','yes','center');return false">Upload</button>
                                     <button class="btn btn-info btn-sm" name="idcopy2" id="idcopy2" onclick="NewWindow1('display_image.php?cou=image9','mywin','900','800','yes','center');return false">Display</button>
                                 </div>
                             </div>
                        </div>
                     </div>
                </div>

                <!-- Approval & DGRN -->
                <div class="col-md-6">
                    <div class="box box-danger">
                        <div class="box-header with-border">
                             <h3 class="box-title">Management</h3>
                        </div>
                        <div class="box-body">
                             <div class="form-group row">
                                <label class="col-sm-3 control-label">Approved By</label>
                                <div class="col-sm-6">
                                    <input class="form-control" name="apprby" id="apprby" type="text" disabled>
                                    <select name="approvedby" id="approvedby" class="form-control" style="visibility: hidden;">
                                        <option value=""></option>
                                        <option value="MD">MD</option>
                                        <option value="WD">WD</option>
                                    </select>
                                </div>
                             </div>
                             <div class="form-group">
                                 <label>Management Further Observation</label>
                                 <textarea name="txtmn_ob" id="txtmn_ob" class="form-control" rows="3"></textarea>
                             </div>
                        </div>
                    </div>
                    
                     <div class="box box-default">
                        <div class="box-header with-border">
                            <h3 class="box-title">DGRN References</h3>
                        </div>
                        <div class="box-body">
                            <div class="form-group row">
                                <label class="col-sm-2 control-label">DGRN 1</label>
                                <div class="col-sm-3"><input type="text" class="form-control input-sm" name="txtCRD_no" id="txtCRD_no"></div>
                                <label class="col-sm-1 control-label">Date</label>
                                <div class="col-sm-3"><input type="text" class="form-control input-sm" name="txtCRE_date" id="txtCRE_date"></div>
                                <label class="col-sm-1 control-label">Amt</label>
                                <div class="col-sm-2"><input type="text" class="form-control input-sm" name="txtCRE_amount" id="txtCRE_amount"></div>
                            </div>
                            <div class="form-group row">
                                <label class="col-sm-2 control-label">DGRN 2</label>
                                <div class="col-sm-3"><input type="text" class="form-control input-sm" name="txtCRD_no2" id="txtCRD_no2"></div>
                                <label class="col-sm-1 control-label">Date</label>
                                <div class="col-sm-3"><input type="text" class="form-control input-sm" name="txtCRE_date2" id="txtCRE_date2"></div>
                                <label class="col-sm-1 control-label">Amt</label>
                                <div class="col-sm-2"><input type="text" class="form-control input-sm" name="txtCRE_amount2" id="txtCRE_amount2"></div>
                            </div>
                            <div class="form-group row">
                                <label class="col-sm-2 control-label">DGRN 3</label>
                                <div class="col-sm-3"><input type="text" class="form-control input-sm" name="txtCRD_no3" id="txtCRD_no3"></div>
                                <label class="col-sm-1 control-label">Date</label>
                                <div class="col-sm-3"><input type="text" class="form-control input-sm" name="txtCRE_date3" id="txtCRE_date3"></div>
                                <label class="col-sm-1 control-label">Amt</label>
                                <div class="col-sm-2"><input type="text" class="form-control input-sm" name="txtCRE_amount3" id="txtCRE_amount3"></div>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </form>

    </section>
</div>

<script>
    // Initialize
    new_inv1();

    // Keyboard Shortcut for Logout (Ctrl+Q)
    document.addEventListener('keydown', function(event) {
        if (event.ctrlKey && (event.key === 'q' || event.key === 'Q')) {
            event.preventDefault();
            window.location.href = 'logout.php';
        }
    });
</script>
</body>
</html>