<?php
session_start();
require_once("connectioni.php");

if (!isset($_SESSION['company']) || $_SESSION['company'] == "") {
	exit("Please Login");
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
	<meta charset="UTF-8">
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	<title>Advance Receipt</title>

	<!-- Bootstrap 3.3.7 -->
	<link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/css/bootstrap.min.css">
	<!-- Font Awesome -->
	<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">

	<style>
		body {
			background-color: #ecf0f5;
			font-family: 'Source Sans Pro', 'Helvetica Neue', Helvetica, Arial, sans-serif;
			font-size: 14px;
		}

		.navbar-custom {
			background-color: #2c3e50;
			color: white;
			padding: 10px 20px;
			display: flex;
			justify-content: space-between;
			align-items: center;
			box-shadow: 0 2px 5px rgba(0, 0, 0, 0.1);
			margin-bottom: 20px;
		}

		.navbar-brand {
			font-size: 24px;
			font-weight: bold;
			color: white !important;
			padding: 0;
			line-height: normal;
		}

		.page-title-box {
			background: rgba(255, 255, 255, 0.1);
			padding: 8px 30px;
			border-radius: 5px;
			font-size: 18px;
			font-weight: 600;
			text-transform: uppercase;
		}

		.user-info {
			display: flex;
			align-items: center;
			gap: 15px;
		}

		.logout-btn {
			background-color: #e74c3c;
			color: white;
			padding: 6px 15px;
			border-radius: 4px;
			font-weight: 600;
			text-decoration: none !important;
		}

		.content-wrapper {
			padding: 20px;
		}

		.box {
			background: #fff;
			border-top: 3px solid #d2d6de;
			box-shadow: 0 1px 1px rgba(0, 0, 0, 0.1);
			margin-bottom: 20px;
			border-radius: 3px;
		}

		.box.box-primary {
			border-top-color: #3c8dbc;
		}

		.box-header {
			color: #444;
			border-bottom: 1px solid #f4f4f4;
			padding: 10px;
		}

		.box-body {
			padding: 20px;
		}

		.form-control {
			border-radius: 0;
			border-color: #d2d6de;
		}

		.btn {
			border-radius: 3px;
		}

		.text-red {
			color: red;
			font-weight: bold;
		}
	</style>

	<script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
	<script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/js/bootstrap.min.js"></script>

	<script src="js/advance.js"></script>
</head>

<body class="hold-transition skin-blue layout-top-nav">

	<!-- Navbar -->
	<div class="navbar-custom">
		<div class="navbar-brand">ERP SYSTEM MENU</div>
		<div class="page-title-box">ADVANCE RECEIPT</div>
		<div class="user-info">
			<span>Welcome, <span
					class="user-name"><?php echo isset($_SESSION['CURRENT_USER']) ? $_SESSION['CURRENT_USER'] : 'User'; ?></span>
				[<?php echo isset($_SESSION['company']) ? $_SESSION['company'] : ''; ?>]</span>
			<a href="logout.php" class="logout-btn">Logout (Ctrl+Q)</a>
		</div>
	</div>

	<!-- Content -->
	<div class="content-wrapper">
		<section class="content">

			<!-- Toolbar -->
			<div class="box box-solid">
				<div class="box-body">
					<button onclick="new_inv()" class="btn btn-default"><i class="fa fa-file"></i> New</button>
					<button onclick="save_crec()" class="btn btn-success"><i class="fa fa-save"></i> Save</button>
					<button onclick="window.close()" class="btn btn-danger"><i class="fa fa-times"></i> Close</button>
					<button onclick="print_inv()" class="btn btn-default"><i class="fa fa-print"></i> Print</button>
					<a onclick="NewWindow('serach_rec.php?stname=PAY', 'mywin', '800', '700', 'yes', 'center');"
						class="btn btn-info"><i class="fa fa-search"></i> Search Receipt</a>
				</div>
			</div>

			<!-- Main Form -->
			<div class="box box-primary">
				<div class="box-header with-border">
					<h3 class="box-title">Receipt Details</h3>
				</div>
				<div class="box-body">

					<!-- Header Row 1 -->
					<div class="row">
						<div class="col-md-3">
							<div class="form-group">
								<label>Receipt No</label>
								<input type="text" id="invno" class="form-control" placeholder="Auto Generated"
									disabled>
							</div>
						</div>
						<div class="col-md-3">
							<div class="form-group">
								<label>Date</label>
								<input type="date" id="invdate" class="form-control"
									value="<?php echo date('Y-m-d'); ?>">
							</div>
						</div>
						<div class="col-md-3">
							<div class="form-group">
								<label>Sales Rep</label>
								<select id="salesrep" class="form-control"></select>
							</div>
						</div>
						<div class="col-md-3">
							<div class="form-group">
								<label>Pay Type</label>
								<select id="paytype" class="form-control">
									<option value="Cash">Cash</option>
									<option value="Cheque" selected>Cheque</option>
									<option value="J/Entry">J/Entry</option>
									<option value="Cash TT">Cash TT</option>
									<option value="Credit Card Commision">Credit Card Commision</option>
								</select>
							</div>
						</div>
					</div>

					<!-- Header Row 2 -->
					<div class="row">
						<div class="col-md-2">
							<div class="form-group">
								<label>Customer Code</label>
								<input type="text" id="cuscode" class="form-control" disabled>
							</div>
						</div>
						<div class="col-md-4">
							<div class="form-group">
								<label>Customer Name</label>
								<div class="input-group">
									<input type="text" id="cusname" class="form-control" disabled>
									<span class="input-group-btn">
										<button class="btn btn-default"
											onclick="NewWindow('serach_customer.php?stname=cash_rec', 'mywin', '800', '700', 'yes', 'center')"><i
												class="fa fa-search"></i></button>
									</span>
								</div>
							</div>
						</div>
						<div class="col-md-3">
							<div class="form-group">
								<label>Cost Center</label>
								<select id="costcenter" class="form-control" disabled>
									<?php for ($i = 1; $i <= 50; $i++)
										echo "<option value='$i'>$i</option>"; ?>
								</select>
							</div>
						</div>
						<div class="col-md-3">
							<div class="form-group">
								<label>Account</label>
								<select id="accno" class="form-control"></select>
							</div>
						</div>
					</div>

					<hr>

					<!-- Cheque Entry -->
					<div class="row">
						<div class="col-md-6">
							<div class="panel panel-default">
								<div class="panel-heading">Cheque / Payment Entry</div>
								<div class="panel-body">
									<div class="row">
										<div class="col-md-4">
											<input type="text" id="chqno" class="form-control" placeholder="Cheque No">
										</div>
										<div class="col-md-4">
											<input type="date" id="chqdate" class="form-control">
										</div>
										<div class="col-md-4">
											<input type="text" id="bank" class="form-control" placeholder="Bank">
										</div>
									</div>
									<div class="row" style="margin-top: 10px;">
										<div class="col-md-6">
											<div class="input-group">
												<input type="number" id="chqamt" class="form-control"
													placeholder="Amount">
												<span class="input-group-btn">
													<button class="btn btn-primary" onclick="add_cheque()"><i
															class="fa fa-plus"></i></button>
												</span>
											</div>
										</div>
									</div>

									<table class="table table-bordered table-condensed" style="margin-top: 10px;">
										<thead>
											<tr>
												<th>Ref/Chq No</th>
												<th>Date</th>
												<th>Bank</th>
												<th>Amount</th>
												<th></th>
											</tr>
										</thead>
										<tbody id="cheque_list_body"></tbody>
									</table>
								</div>
							</div>
						</div>

						<!-- Totals -->
						<div class="col-md-6">
							<div class="form-horizontal">
								<div class="form-group">
									<label class="col-sm-4 control-label">Cheque Total</label>
									<div class="col-sm-8">
										<input type="text" id="chqtot" class="form-control text-right" disabled
											value="0.00">
									</div>
								</div>
								<div class="form-group">
									<label class="col-sm-4 control-label">Cash Total</label>
									<div class="col-sm-8">
										<input type="number" id="cashtot" class="form-control text-right"
											placeholder="0.00" onkeyup="updateTotals()">
									</div>
								</div>
								<div class="form-group">
									<label class="col-sm-4 control-label">Allocated</label>
									<div class="col-sm-8">
										<input type="text" id="txtpaytot" class="form-control text-right" disabled
											value="0.00">
									</div>
								</div>
								<div class="form-group">
									<label class="col-sm-4 control-label">Over/Under Pay</label>
									<div class="col-sm-8">
										<input type="text" id="txtoverpay" class="form-control text-right" disabled
											value="0.00">
									</div>
								</div>
								<div class="form-group">
									<label class="col-sm-4 control-label hidden">Remarks</label>
									<div class="col-sm-12">
										<textarea id="remarks" class="form-control" placeholder="Remarks"
											rows="2"></textarea>
									</div>
								</div>
							</div>
						</div>
					</div>

					<hr>

					<!-- Invoice Allocation -->
					<div class="row">
						<div class="col-md-12">
							<h4>Invoice Allocation <button class="btn btn-xs btn-warning" onclick="auto_allocate()">Auto
									Allocate</button></h4>
							<div class="table-responsive" style="max-height: 300px; overflow-y: auto;">
								<table class="table table-bordered table-striped">
									<thead>
										<tr>
											<th>Invoice No</th>
											<th>Date</th>
											<th class="text-right">Amount</th>
											<th class="text-right">Paid</th>
											<th class="text-right">Balance</th>
											<th class="text-right" width="150">Settle</th>
										</tr>
									</thead>
									<tbody id="invoice_list_body">
										<tr>
											<td colspan="6" class="text-center">Select Customer to Load Invoices</td>
										</tr>
									</tbody>
								</table>
							</div>
						</div>
					</div>

				</div>
			</div>

		</section>
	</div>

	<!-- Hidden Uniq for compatibility if needed -->
	<input type="hidden" id="uniq">

	<script>
		document.addEventListener('keydown', function (event) {
			if (event.ctrlKey && (event.key === 'q' || event.key === 'Q')) {
				event.preventDefault();
				window.location.href = 'logout.php';
			}
		});

		// Init
		new_inv();
	</script>
</body>

</html>