# DB Converter - Access to MySQL Conversion Tool

**DB Converter** is a web-based application designed to bridge the gap between Microsoft Access and MySQL. It allows users to upload Access database files (`.mdb`, `.accdb`), view their contents, validate data integrity, and convert tables to MySQL—or vice versa.

## 🚀 Key Features
* **Two-Way Conversion:** * **Access → MySQL:** Reads table structures and inserts data safely.
    ***MySQL → Access:** Exports SQL tables into a new `.mdb` file.
* **Data Validation:** Checks for incompatible column names, invalid dates, and text length issues before conversion.
* **Smart UI:** Clean, responsive interface with Dark Mode and real-time progress indicators.
* **Error Logging:** Automatically captures conversion failures and generates downloadable error reports.

## 🛠 Prerequisites
To run this application, your environment must meet the following requirements:

1.  **Operating System:** Windows (Recommended for native Access Driver support).
2.  **Web Server:** Apache or Nginx (via XAMPP, WAMP, or IIS).
3.  **PHP Version:** 7.4 or higher.
4.  **Database:** MySQL 5.7 or higher.
5.  **Required Drivers:**
    * **Microsoft Access Database Engine (2010 or 2016):** Required for ODBC connectivity.
    * **PHP Extensions:** Ensure `extension=pdo_mysql` and `extension=pdo_odbc` are enabled in your `php.ini`.

## 📂 Installation

1.  **Clone/Download:** Place the `db_converter` folder into your web server's root directory (e.g., `C:\xampp\htdocs\`).

2.  **Create Directories:**
    Ensure the following folders exist and have **write permissions**:
    * `/uploads/` (Stores temporary Access files and logs).
    * `/templates/` (Stores the blank Access database).

3.  **Setup Template File:**
    * You **must** place an empty Microsoft Access file named `blank.mdb` inside the `/templates/` directory. This is used for generating new Access files during reverse conversion.

4.  **Configure PHP:**
    Open `php.ini` and verify these lines are uncommented (no `;` at the start):
    ```ini
    extension=pdo_mysql
    extension=pdo_odbc
    ```

## 🏗 File Structure
```text
/db-converter-pro/
├── index.html       # Main User Interface (Bootstrap 5)
├── script.js        # Frontend Logic (AJAX, Event Listeners)
├── api.php          # Backend Router (Handles all HTTP requests)
├── functions.php    # Core Logic (DB Connection, Validation, Conversion)
├── README.md        # This documentation
├── /uploads/        # (Writable) Temp storage
└── /templates/      # Contains 'blank.mdb'