<?php
 
require_once("connectioni.php");

class DBConnector
{

private $server = '';
private $userName = '';
private $password = '';
private $database = '';

private $con = null;

	// Object construction with database connectivity - Default Constructor
	function __construct()
	{	
		$this->server = DB_SERVER ;
		$this->userName = DB_USER_NAME;
		$this->password = DB_PASSWORD;
		$this->database = DB_DATABSE;
	}

	/*
	 * DBConnector::OpenConnection()
	 * 
	 * Open mysql database connection
	 * 
	 * @access public
	 * 
	 * @return void
	 */
	public function OpenConnection()
	{
		// Use mysqli and select database on connect
		$this->con = mysqli_connect($this->server, $this->userName, $this->password, $this->database);

		if (!$this->con)
		{
		  die('Could not connect: ' . mysqli_connect_error());
		}
	}
}
	/*
	 * DBConnector::RunQuery()
	 * 
	 * Use to execute select statements
	 *
	 * @param String $SQL : The SQL statement to be executed
	 * 
	 * @access public
	 * 
	 * @return Array
	public function RunQuery($SQL)
	{
		$this->OpenConnection();
		// mysqli_connect already selected the database, but ensure it's set
		mysqli_select_db($this->con, $this->database);
		$result = mysqli_query($this->con, $SQL);
		$this->CloseConnection();
		return $result;
	}
	}
	
	/*
	 * DBConnector::ExecuteQuery()
	 * 
	 * Use to execute insert, update and delete statements
	 *
	 * @param String $SQL : The SQL statement to be executed
	 * 
	 * @access public
	 * 
	public function ExecuteQuery($SQL)
	{
		$this->OpenConnection();
		mysqli_select_db($this->con, $this->database);
		$result = mysqli_query($this->con, $SQL);
		if (mysqli_error($this->con))
			$result = false;
		$this->CloseConnection();
		return $result;
	}
		return $result;
	}	
	
	/*
	 * DBConnector::CheckRecordAvailability()
	 * 
	 * Checks whtether records available or not for the given SQL statement
	 *
	 * @param String $SQL : The SQL statement to be executed
	 * 
	 * @access public
	 * 
	public function CheckRecordAvailability($SQL)
	{
		$this->OpenConnection();
		mysqli_select_db($this->con, $this->database);
		$result = mysqli_query($this->con, $SQL);
		$this->CloseConnection();
		if(mysqli_num_rows($result) > 0)
			return true;
		return false;
	}
  		return false;		
	}
	
	/*
	 * DBConnector::AutoIncrementExecuteQuery()
	 * 
	 * Get generated auto increment key/ID, after the execution of given SQL statement
	 *
	 * @param String $SQL : The SQL statement to be executed
	 * 
	 * @access public
	 * 
	public function AutoIncrementExecuteQuery($SQL)
	{
		$id = -1;
		$this->OpenConnection();
		mysqli_select_db($this->con, $this->database);
		$result = mysqli_query($this->con, $SQL);
		echo mysqli_error($this->con);
		$id =  mysqli_insert_id($this->con);
		$this->CloseConnection();
		return $id;
	}
		return $id;
	}
	
	/*
	 * DBConnector::CloseConnection()
	 * 
	 * Close MySQL Connection
	 * 
	 * @access public
	 * 
	public function CloseConnection()
	{
		mysqli_close($this->con);
	}
		mysql_close($this->con);		
	}
} */

?>
